/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.generator.ClassWriter;
import org.glassfish.admin.rest.generator.CommandResourceMetaData;
import org.glassfish.admin.rest.generator.GeneratorException;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.hk2.api.ServiceLocator;

public class TextClassWriter
implements ClassWriter {
    Writer writer;
    ServiceLocator habitat;

    public TextClassWriter(ServiceLocator habitat, File generationDir, String className, String baseClassName, String resourcePath) throws IOException {
        this.habitat = habitat;
        File file = new File(generationDir, className + ".java");
        boolean success = file.createNewFile();
        if (!success) {
            RestLogging.restLogger.log(Level.FINE, "Error creating file: {0} in {1}", new String[]{className + ".java", generationDir.getAbsolutePath()});
        }
        FileWriter fstream = new FileWriter(file);
        this.writer = new BufferedWriter(fstream);
        this.writeCopyRightHeader();
        this.writePackageHeader();
        this.writeImportStatements();
        if (resourcePath != null) {
            this.writer.write("@Path(\"/" + resourcePath + "/\")\n");
        }
        this.writer.write("public class " + className + " extends " + baseClassName + "  {\n\n");
    }

    private void writePackageHeader() throws IOException {
        this.writer.write("package org.glassfish.admin.rest.resources.generated;\n");
    }

    private void writeCopyRightHeader() throws IOException {
        this.writer.write("/*\n");
        this.writer.write(" * Copyright (c) 2010, 2018 Oracle and/or its affiliates. All rights reserved.\n");
        this.writer.write(" *\n");
        this.writer.write(" * This program and the accompanying materials are made available under the\n");
        this.writer.write(" * terms of the Eclipse Public License v. 2.0, which is available at\n");
        this.writer.write(" * http://www.eclipse.org/legal/epl-2.0.\n");
        this.writer.write(" *\n");
        this.writer.write(" * This Source Code may also be made available under the following Secondary\n");
        this.writer.write(" * Licenses when the conditions for such availability set forth in the\n");
        this.writer.write(" * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,\n");
        this.writer.write(" * version 2 with the GNU Classpath Exception, which is available at\n");
        this.writer.write(" * https://www.gnu.org/software/classpath/license.html.\n");
        this.writer.write(" *\n");
        this.writer.write(" * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0\n");
        this.writer.write(" */\n");
        this.writer.write("\n");
    }

    private void writeImportStatements() throws IOException {
        this.writer.write("import jakarta.ws.rs.Path;\n");
        this.writer.write("import jakarta.ws.rs.PathParam;\n");
        this.writer.write("import org.glassfish.admin.rest.resources.*;\n");
        this.writer.write("import org.glassfish.admin.rest.resources.custom.*;\n");
    }

    @Override
    public void createCommandResourceConstructor(String commandResourceClassName, String commandName, String httpMethod, boolean linkedToParent, CommandResourceMetaData.ParameterMetaData[] commandParams, String commandDisplayName, String commandAction) {
        try {
            this.writer.write("   public " + commandResourceClassName + "() {\n");
            this.writer.write("       super(\n");
            this.writer.write("          \"" + commandResourceClassName + "\",\n");
            this.writer.write("          \"" + commandName + "\",\n");
            this.writer.write("          \"" + httpMethod + "\",\n");
            if (!httpMethod.equals("GET")) {
                this.writer.write("          \"" + commandAction + "\",\n");
                this.writer.write("          \"" + commandDisplayName + "\",\n");
            }
            this.writer.write("          " + linkedToParent + ");\n");
            this.writer.write("    }\n");
            if (commandParams != null) {
                this.writer.write("@Override\n");
                this.writer.write("protected java.util.HashMap<String, String> getCommandParams() {\n");
                this.writer.write("\tjava.util.HashMap<String, String> hm = new java.util.HashMap<String, String>();\n");
                for (CommandResourceMetaData.ParameterMetaData commandParam : commandParams) {
                    this.writer.write("\thm.put(\"" + commandParam.name + "\",\"" + commandParam.value + "\");\n");
                }
                this.writer.write("\treturn hm;\n");
                this.writer.write("}\n");
            }
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetCommandResource(String commandResourceClassName, String resourcePath) {
        try {
            this.writer.write("@Path(\"" + resourcePath + "/\")\n");
            this.writer.write("public " + commandResourceClassName + " get" + commandResourceClassName + "() {\n");
            this.writer.write(commandResourceClassName + " resource = injector.inject(" + commandResourceClassName + ".class);\n");
            this.writer.write("return resource;\n");
            this.writer.write("}\n\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createCustomResourceMapping(String resourceClassName, String mappingPath) {
        try {
            this.writer.write("\n");
            this.writer.write("\t@Path(\"" + mappingPath + "/\")\n");
            this.writer.write("\tpublic " + resourceClassName + " get" + resourceClassName + "() {\n");
            this.writer.write("\t\t" + resourceClassName + " resource = injector.inject(" + resourceClassName + ".class);\n");
            this.writer.write("\t\tresource.setEntity(getEntity());\n");
            this.writer.write("\t\treturn resource;\n");
            this.writer.write("\t}\n\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetCommandResourcePaths(List<CommandResourceMetaData> commandMetaData) {
        assert (commandMetaData.size() > 0) : "It is assumed that this method is called only if commandMetaData.size() > 0";
        try {
            this.writer.write("@Override\n");
            this.writer.write("public String[][] getCommandResourcesPaths() {\n");
            StringBuilder commandResourcesPaths = new StringBuilder();
            for (CommandResourceMetaData metaData : commandMetaData) {
                if (!ResourceUtil.commandIsPresent(this.habitat, metaData.command)) continue;
                if (commandResourcesPaths.length() > 0) {
                    commandResourcesPaths = commandResourcesPaths.append(", ");
                }
                commandResourcesPaths = commandResourcesPaths.append("{").append('\"').append(metaData.resourcePath).append("\", ").append('\"').append(metaData.httpMethod).append("\", ").append('\"').append(metaData.command).append("\"} ");
            }
            this.writer.write("return new String[][] {" + String.valueOf(commandResourcesPaths) + "};\n");
            this.writer.write("}\n\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetDeleteCommand(String commandName) {
        try {
            this.writer.write("@Override\n");
            this.writer.write("public String getDeleteCommand() {\n");
            this.writer.write("\treturn \"" + commandName + "\";\n");
            this.writer.write("}\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetPostCommand(String commandName) {
        try {
            this.writer.write("@Override\n");
            this.writer.write("public String getPostCommand() {\n");
            this.writer.write("\treturn \"" + commandName + "\";\n");
            this.writer.write("}\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetChildResource(String path, String childResourceClassName) {
        try {
            this.writer.write("\t@Path(\"" + path + "/\")\n");
            this.writer.write("\tpublic " + childResourceClassName + " get" + childResourceClassName + "() {\n");
            this.writer.write("\t\t" + childResourceClassName + " resource = injector.inject(" + childResourceClassName + ".class);\n");
            this.writer.write("\t\tresource.setParentAndTagName(getEntity() , \"" + path + "\");\n");
            this.writer.write("\t\treturn resource;\n");
            this.writer.write("\t}\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetChildResourceForListResources(String keyAttributeName, String childResourceClassName) {
        try {
            this.writer.write("\n");
            this.writer.write("\t@Path(\"{" + keyAttributeName + "}/\")\n");
            this.writer.write("\tpublic " + childResourceClassName + " get" + childResourceClassName + "(@PathParam(\"" + keyAttributeName + "\") String id) {\n");
            this.writer.write("\t\t" + childResourceClassName + " resource = injector.inject(" + childResourceClassName + ".class);\n");
            this.writer.write("\t\tresource.setBeanByKey(entity, id, tagName);\n");
            this.writer.write("\t\treturn resource;\n");
            this.writer.write("\t}\n\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetPostCommandForCollectionLeafResource(String postCommandName) {
        try {
            this.writer.write("@Override\n");
            this.writer.write("protected String getPostCommand(){\n");
            this.writer.write("return \"" + postCommandName + "\";\n");
            this.writer.write("}\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetDeleteCommandForCollectionLeafResource(String deleteCommandName) {
        try {
            this.writer.write("@Override\n");
            this.writer.write("protected String getDeleteCommand(){\n");
            this.writer.write("return \"" + deleteCommandName + "\";\n");
            this.writer.write("}\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetDisplayNameForCollectionLeafResource(String displayName) {
        try {
            this.writer.write("@Override\n");
            this.writer.write("protected String getName(){\n");
            this.writer.write("return \"" + displayName + "\";\n");
            this.writer.write("}\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void done() {
        try {
            this.writer.write("}\n");
            this.writer.close();
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }
}

