/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.ClasspathOverrideSource;
import io.helidon.config.ConfigException;
import io.helidon.config.FileOverrideSource;
import io.helidon.config.InMemoryOverrideSource;
import io.helidon.config.UrlOverrideSource;
import io.helidon.config.spi.ConfigContent;
import io.helidon.config.spi.OverrideSource;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;

public final class OverrideSources {
    private OverrideSources() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static OverrideSource empty() {
        return OverridingSourceHolder.EMPTY;
    }

    public static OverrideSource create(Map<String, String> overrideValues) {
        return InMemoryOverrideSource.builder(overrideValues).build();
    }

    public static ClasspathOverrideSource.Builder classpath(String resourceName) {
        return ClasspathOverrideSource.builder().resource(resourceName);
    }

    public static FileOverrideSource.Builder file(String file) {
        return FileOverrideSource.builder().path(Paths.get(file, new String[0]));
    }

    public static UrlOverrideSource.Builder url(URL url) {
        return UrlOverrideSource.builder().url(url);
    }

    private static final class OverridingSourceHolder {
        private static final OverrideSource EMPTY = new EmptyOverrideSource();

        private OverridingSourceHolder() {
            throw new AssertionError((Object)"Instantiation not allowed.");
        }
    }

    private static final class EmptyOverrideSource
    implements OverrideSource {
        private EmptyOverrideSource() {
        }

        public Optional<ConfigContent.OverrideContent> load() throws ConfigException {
            return Optional.empty();
        }

        public String toString() {
            return "EmptyOverrideSource";
        }

        public boolean optional() {
            return true;
        }
    }
}

