/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.NullaryFunction;

public class ActivityCheckFilter
extends BaseFilter {
    private static final Logger LOGGER = Grizzly.logger(ActivityCheckFilter.class);
    public static final String ACTIVE_ATTRIBUTE_NAME = "connection-active-attribute";
    private static final Attribute<ActiveRecord> IDLE_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("connection-active-attribute", new NullaryFunction<ActiveRecord>(){

        @Override
        public ActiveRecord evaluate() {
            return new ActiveRecord();
        }
    });
    private final long timeoutMillis;
    private final DelayedExecutor.DelayQueue<Connection> queue;

    public ActivityCheckFilter(DelayedExecutor executor, long timeout, TimeUnit timeoutUnit) {
        this(executor, timeout, timeoutUnit, null);
    }

    public ActivityCheckFilter(DelayedExecutor executor, long timeout, TimeUnit timeoutUnit, TimeoutHandler handler) {
        this(executor, new DefaultWorker(handler), timeout, timeoutUnit);
    }

    protected ActivityCheckFilter(DelayedExecutor executor, DelayedExecutor.Worker<Connection> worker, long timeout, TimeUnit timeoutUnit) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        this.timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeoutUnit);
        this.queue = executor.createDelayQueue(worker, new Resolver());
    }

    @Override
    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        this.queue.add(ctx.getConnection(), this.timeoutMillis, TimeUnit.MILLISECONDS);
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        this.queue.add(ctx.getConnection(), this.timeoutMillis, TimeUnit.MILLISECONDS);
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        ActivityCheckFilter.IDLE_ATTR.get((AttributeStorage)ctx.getConnection()).timeoutMillis = System.currentTimeMillis() + this.timeoutMillis;
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        ActivityCheckFilter.IDLE_ATTR.get((AttributeStorage)ctx.getConnection()).timeoutMillis = System.currentTimeMillis() + this.timeoutMillis;
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        this.queue.remove(ctx.getConnection());
        return ctx.getInvokeAction();
    }

    public static DelayedExecutor createDefaultIdleDelayedExecutor() {
        return ActivityCheckFilter.createDefaultIdleDelayedExecutor(1000L, TimeUnit.MILLISECONDS);
    }

    public static DelayedExecutor createDefaultIdleDelayedExecutor(long checkInterval, TimeUnit checkIntervalUnit) {
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = new Thread(r);
                newThread.setName("Grizzly-ActiveTimeoutFilter-IdleCheck");
                newThread.setDaemon(true);
                return newThread;
            }
        });
        return new DelayedExecutor(executor, checkInterval > 0L ? checkInterval : 1000L, checkIntervalUnit != null ? checkIntervalUnit : TimeUnit.MILLISECONDS);
    }

    public long getTimeout(TimeUnit timeunit) {
        return timeunit.convert(this.timeoutMillis, TimeUnit.MILLISECONDS);
    }

    private static final class DefaultWorker
    implements DelayedExecutor.Worker<Connection> {
        private final TimeoutHandler handler;

        DefaultWorker(TimeoutHandler handler) {
            this.handler = handler;
        }

        @Override
        public boolean doWork(Connection connection) {
            if (this.handler != null) {
                this.handler.onTimeout(connection);
            }
            connection.closeSilently();
            return true;
        }
    }

    private static final class ActiveRecord {
        private volatile long timeoutMillis;

        private ActiveRecord() {
        }
    }

    private static final class Resolver
    implements DelayedExecutor.Resolver<Connection> {
        private Resolver() {
        }

        @Override
        public boolean removeTimeout(Connection connection) {
            ActivityCheckFilter.IDLE_ATTR.get((AttributeStorage)connection).timeoutMillis = 0L;
            return true;
        }

        @Override
        public long getTimeoutMillis(Connection connection) {
            return ActivityCheckFilter.IDLE_ATTR.get((AttributeStorage)connection).timeoutMillis;
        }

        @Override
        public void setTimeoutMillis(Connection connection, long timeoutMillis) {
            ActivityCheckFilter.IDLE_ATTR.get((AttributeStorage)connection).timeoutMillis = timeoutMillis;
        }
    }

    public static interface TimeoutHandler {
        public void onTimeout(Connection var1);
    }
}

