/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.ContainerType;
import com.sun.messaging.jmq.jmsclient.JMSContextImpl;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import com.sun.messaging.jms.JMSException;
import com.sun.messaging.jms.JMSSecurityException;
import com.sun.messaging.jms.ra.ConnectionCreator;
import com.sun.messaging.jms.ra.ConnectionRequestInfo;
import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.DirectQueueConnection;
import com.sun.messaging.jms.ra.DirectTopicConnection;
import com.sun.messaging.jms.ra.ManagedConnection;
import com.sun.messaging.jms.ra.ManagedConnectionFactory;
import com.sun.messaging.jms.ra.ResourceAdapter;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSContext;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.resource.Referenceable;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.SecurityException;
import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.transaction.xa.XAResource;

public class DirectConnectionFactory
extends ConnectionCreator
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
Referenceable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Properties configuration = null;
    private ResourceAdapter ra = null;
    private ManagedConnectionFactory mcf = null;
    private boolean inACC = false;
    private boolean inClusteredContainer = false;
    private String raNameSpace = null;
    private transient JMSService jmsservice = null;
    private ConnectionManager cm = null;
    private static final String _className = "com.sun.messaging.jms.ra.DirectConnectionFactory";
    private static final String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final String _lgrNameJMSConnectionFactory = "jakarta.jms.ConnectionFactory.mqjmsra";
    private static final Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    private static final Logger _loggerJF = Logger.getLogger("jakarta.jms.ConnectionFactory.mqjmsra");
    private static final String _lgrMIDPrefix = "MQJMSRA_DCF";
    private static final String _lgrMID_INF = "MQJMSRA_DCF1101: ";
    private static final String _lgrMID_EXC = "MQJMSRA_DCF4001: ";
    private static boolean _disableConnectionManagement = Boolean.getBoolean("imq.jmsra.direct.disableCM");

    public DirectConnectionFactory(JMSService jmsservice, Properties props) {
        Object[] params = new Object[]{jmsservice, props};
        _loggerOC.entering(_className, "constructor(jmsservice, props)", params);
        this.jmsservice = jmsservice;
        this.configuration = props;
        _loggerOC.exiting(_className, "constructor(jmsservice, props):config=" + this.toString());
    }

    public DirectConnectionFactory(ManagedConnectionFactory mcf, ConnectionManager cm) {
        Object[] params = new Object[]{mcf, cm};
        _loggerOC.entering(_className, "constructor(mcf, cm)", params);
        this.mcf = mcf;
        this.cm = cm;
        this.ra = (ResourceAdapter)mcf.getResourceAdapter();
        this.jmsservice = this.ra._getJMSService();
        this.inACC = this.ra.getInAppClientContainer();
        this.inClusteredContainer = this.ra.getInClusteredContainer();
        this.raNameSpace = this.ra._getRAUID();
        _loggerOC.exiting(_className, "constructor(mcf, cm):config=" + this.toString());
    }

    public void setReference(Reference ref) {
        _loggerJF.fine("MQJMSRA_DCF1101: setReference():Reference=" + ref);
    }

    public Reference getReference() throws NamingException {
        _loggerJF.fine("MQJMSRA_DCF1101: getReference():");
        throw new NamingException("MQRA:DCF:getReference:NOT Supported");
    }

    public Connection createConnection() throws jakarta.jms.JMSException {
        _loggerJF.fine("MQJMSRA_DCF1101: createConnection():");
        String password = null;
        String username = this.mcf == null || this.mcf.getUserName() == null ? "guest" : this.mcf.getUserName();
        password = this.mcf == null || this.mcf.getPassword() == null ? "guest" : this.mcf.getPassword();
        return this.createConnection(username, password);
    }

    public Connection createConnection(String username, String password) throws jakarta.jms.JMSException {
        _loggerJF.fine("MQJMSRA_DCF1101: createConnection(u,p):username=" + username);
        if (!_disableConnectionManagement) {
            return this._allocateConnection(username, password);
        }
        long connectionId = this._createConnectionId(username, password);
        DirectConnection dc = new DirectConnection(this, this.jmsservice, connectionId, this.inACC);
        return dc;
    }

    public JMSContext createContext() {
        return new JMSContextImpl(this, this.getContainerType());
    }

    public JMSContext createContext(String userName, String password) {
        return new JMSContextImpl(this, this.getContainerType(), userName, password);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        return new JMSContextImpl(this, this.getContainerType(), userName, password, sessionMode);
    }

    public JMSContext createContext(int sessionMode) {
        return new JMSContextImpl(this, this.getContainerType(), sessionMode);
    }

    private ContainerType getContainerType() {
        if (this.ra.getInAppClientContainer()) {
            return ContainerType.JavaEE_ACC;
        }
        return ContainerType.JavaEE_Web_or_EJB;
    }

    public QueueConnection createQueueConnection() throws jakarta.jms.JMSException {
        _loggerJF.fine("MQJMSRA_DCF1101: createQueueConnection():");
        String password = null;
        String username = this.mcf == null || this.mcf.getUserName() == null ? "guest" : this.mcf.getUserName();
        password = this.mcf == null || this.mcf.getPassword() == null ? "guest" : this.mcf.getPassword();
        return this.createQueueConnection(username, password);
    }

    public QueueConnection createQueueConnection(String username, String password) throws jakarta.jms.JMSException {
        _loggerJF.fine("MQJMSRA_DCF1101: createQueueConnection(u,p):username=" + username);
        if (!_disableConnectionManagement) {
            return (QueueConnection)this._allocateQueueConnection(username, password);
        }
        long connectionId = this._createConnectionId(username, password);
        DirectQueueConnection dc = new DirectQueueConnection(this, this.jmsservice, connectionId, this.inACC);
        return dc;
    }

    public TopicConnection createTopicConnection() throws jakarta.jms.JMSException {
        _loggerJF.fine("MQJMSRA_DCF1101: createTopicConnection():");
        String password = null;
        String username = this.mcf == null || this.mcf.getUserName() == null ? "guest" : this.mcf.getUserName();
        password = this.mcf == null || this.mcf.getPassword() == null ? "guest" : this.mcf.getPassword();
        return this.createTopicConnection(username, password);
    }

    public TopicConnection createTopicConnection(String username, String password) throws jakarta.jms.JMSException {
        _loggerJF.fine("MQJMSRA_DCF1101: createTopicConnection(u,p):username=" + username);
        if (!_disableConnectionManagement) {
            return (TopicConnection)this._allocateTopicConnection(username, password);
        }
        long connectionId = this._createConnectionId(username, password);
        DirectTopicConnection dc = new DirectTopicConnection(this, this.jmsservice, connectionId, this.inACC);
        return dc;
    }

    private long _createConnectionId(String username, String password) throws jakarta.jms.JMSException {
        long connectionId = 0L;
        if (this.jmsservice == null) {
            if (this.ra != null) {
                this.jmsservice = this.ra._getJMSService();
            }
            if (this.jmsservice == null) {
                this.jmsservice = ResourceAdapter._getRAJMSService();
            }
        }
        assert (this.jmsservice != null);
        try {
            JMSServiceReply reply = this.jmsservice.createConnection(username, password);
            try {
                connectionId = reply.getJMQConnectionID();
            }
            catch (NoSuchFieldException nsfe) {
                String exerrmsg = "MQJMSRA_DCF4001: JMSServiceException:Missing JMQConnectionID";
                jakarta.jms.JMSException jmse = new jakarta.jms.JMSException(exerrmsg);
                jmse.initCause((Throwable)nsfe);
                _loggerJF.severe(exerrmsg);
                throw jmse;
            }
        }
        catch (JMSServiceException jse) {
            String failure_cause;
            JMSServiceReply.Status status = jse.getJMSServiceReply().getStatus();
            boolean security_exception = true;
            switch (status) {
                case INVALID_LOGIN: {
                    failure_cause = "authentication failure.";
                    break;
                }
                case FORBIDDEN: {
                    failure_cause = "authorization failure.";
                    break;
                }
                default: {
                    failure_cause = "unkown JMSService server error.";
                    security_exception = false;
                }
            }
            String exerrmsg = "createConnection on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for username:" + username + " due to " + failure_cause;
            _loggerJF.severe(exerrmsg);
            Throwable jmsse = security_exception ? new jakarta.jms.JMSSecurityException(exerrmsg, jse.getJMSServiceReply().getErrorCode()) : new jakarta.jms.JMSException(exerrmsg, jse.getJMSServiceReply().getErrorCode());
            jmsse.initCause((Throwable)jse);
            throw jmsse;
        }
        return connectionId;
    }

    public void setResourceAdapter(ResourceAdapter ra) {
        this.ra = ra;
    }

    public Properties _getConfiguration() {
        return this.configuration;
    }

    public void setConfigurationProperty(String name, String value) {
    }

    protected boolean isRAClustered() {
        return this.inClusteredContainer;
    }

    protected String getRANamespace() {
        return this.raNameSpace;
    }

    @Override
    protected Connection _createConnection(String username, String password) throws jakarta.jms.JMSException {
        long connectionId = this._createConnectionId(username, password);
        DirectConnection dc = new DirectConnection(this, this.jmsservice, connectionId, this.inACC);
        return dc;
    }

    @Override
    protected Connection _createQueueConnection(String username, String password) throws jakarta.jms.JMSException {
        long connectionId = this._createConnectionId(username, password);
        DirectQueueConnection dc = new DirectQueueConnection(this, this.jmsservice, connectionId, this.inACC);
        return dc;
    }

    @Override
    protected Connection _createTopicConnection(String username, String password) throws jakarta.jms.JMSException {
        long connectionId = this._createConnectionId(username, password);
        DirectTopicConnection dc = new DirectTopicConnection(this, this.jmsservice, connectionId, this.inACC);
        return dc;
    }

    @Override
    protected XAResource _createXAResource(ManagedConnection mc, Object conn) throws jakarta.jms.JMSException {
        return null;
    }

    private Connection _allocateConnection(String username, String password) throws jakarta.jms.JMSException {
        ConnectionRequestInfo.ConnectionType connectionType = ConnectionRequestInfo.ConnectionType.UNIFIED_CONNECTION;
        ConnectionRequestInfo crinfo = new ConnectionRequestInfo(this.mcf, username, password, connectionType);
        try {
            DirectConnection dc = (DirectConnection)this.cm.allocateConnection((jakarta.resource.spi.ManagedConnectionFactory)this.mcf, (jakarta.resource.spi.ConnectionRequestInfo)crinfo);
            return dc;
        }
        catch (SecurityException se) {
            throw new JMSSecurityException("MQRA:DCF:allocation failure:createConnection:" + se.getMessage(), se.getErrorCode(), se);
        }
        catch (ResourceException re) {
            throw new JMSException("MQRA:DCF:allocation failure:createConnection:" + re.getMessage(), re.getErrorCode(), re);
        }
    }

    private Connection _allocateQueueConnection(String username, String password) throws jakarta.jms.JMSException {
        ConnectionRequestInfo.ConnectionType connectionType = ConnectionRequestInfo.ConnectionType.QUEUE_CONNECTION;
        ConnectionRequestInfo crinfo = new ConnectionRequestInfo(this.mcf, username, password, connectionType);
        try {
            DirectConnection dc = (DirectConnection)this.cm.allocateConnection((jakarta.resource.spi.ManagedConnectionFactory)this.mcf, (jakarta.resource.spi.ConnectionRequestInfo)crinfo);
            return dc;
        }
        catch (SecurityException se) {
            throw new JMSSecurityException("MQRA:DCF:allocation failure:createConnection:" + se.getMessage(), se.getErrorCode(), se);
        }
        catch (ResourceException re) {
            throw new JMSException("MQRA:DCF:allocation failure:createConnection:" + re.getMessage(), re.getErrorCode(), re);
        }
    }

    private Connection _allocateTopicConnection(String username, String password) throws jakarta.jms.JMSException {
        ConnectionRequestInfo.ConnectionType connectionType = ConnectionRequestInfo.ConnectionType.TOPIC_CONNECTION;
        ConnectionRequestInfo crinfo = new ConnectionRequestInfo(this.mcf, username, password, connectionType);
        try {
            DirectConnection dc = (DirectConnection)this.cm.allocateConnection((jakarta.resource.spi.ManagedConnectionFactory)this.mcf, (jakarta.resource.spi.ConnectionRequestInfo)crinfo);
            return dc;
        }
        catch (SecurityException se) {
            throw new JMSSecurityException("MQRA:DCF:allocation failure:createConnection:" + se.getMessage(), se.getErrorCode(), se);
        }
        catch (ResourceException re) {
            throw new JMSException("MQRA:DCF:allocation failure:createConnection:" + re.getMessage(), re.getErrorCode(), re);
        }
    }

    ManagedConnectionFactory getMCF() {
        return this.mcf;
    }

    void setMCF(ManagedConnectionFactory mcf) {
        this.mcf = mcf;
    }
}

