/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.manager.ha;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.TakingoverTracker;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterReason;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.HAClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.persist.api.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;

public class HAClusteredBrokerImpl
implements HAClusteredBroker {
    protected Logger logger = Globals.getLogger();
    boolean local = false;
    Integer status = 0;
    BrokerState state = BrokerState.INITIALIZING;
    String brokerid = null;
    MQAddress address = null;
    String instanceName = null;
    Integer version = 0;
    protected UID session = null;
    long heartbeat = 0L;
    String takeoverBroker = null;
    UID brokerSessionUID;
    protected HAClusterManagerImpl parent = null;

    protected HAClusteredBrokerImpl() {
    }

    public HAClusteredBrokerImpl(String brokerid, HABrokerInfo m, HAClusterManagerImpl parent) throws BrokerException {
        this.parent = parent;
        this.brokerid = brokerid;
        this.status = 0;
        String urlstr = m.getUrl();
        try {
            this.address = BrokerMQAddress.createAddress(urlstr);
        }
        catch (Exception ex) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "invalid URL stored on disk " + urlstr, ex));
        }
        this.version = m.getVersion();
        this.state = BrokerState.getState(m.getState());
        this.session = new UID(m.getSessionID());
        this.takeoverBroker = m.getTakeoverBrokerID();
        this.heartbeat = m.getHeartbeat();
    }

    public HAClusteredBrokerImpl(String brokerid, MQAddress url, int version, BrokerState state, UID session, HAClusterManagerImpl parent) throws BrokerException {
        this.parent = parent;
        this.brokerid = brokerid;
        this.status = 0;
        this.address = url;
        this.version = version;
        this.state = state;
        this.session = session;
        this.takeoverBroker = "";
        this.brokerSessionUID = new UID();
        Store store = Globals.getStore();
        store.addBrokerInfo(brokerid, this.address.toString(), state, this.version, session.longValue(), this.heartbeat);
        this.heartbeat = store.getBrokerHeartbeat(brokerid);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ClusteredBroker)) {
            return false;
        }
        return this.getBrokerName().equals(((ClusteredBroker)o).getBrokerName());
    }

    @Override
    public int hashCode() {
        return this.getBrokerName().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(HABrokerInfo m) {
        MQAddress oldaddr = this.address;
        HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
        synchronized (hAClusteredBrokerImpl) {
            this.brokerid = m.getId();
            String urlstr = m.getUrl();
            try {
                this.address = BrokerMQAddress.createAddress(urlstr);
            }
            catch (Exception ex) {
                this.logger.logStack(16, ex.getMessage(), (Throwable)ex);
                this.address = oldaddr;
            }
            this.version = m.getVersion();
            this.state = BrokerState.getState(m.getState());
            this.session = new UID(m.getSessionID());
            this.takeoverBroker = m.getTakeoverBrokerID();
            this.heartbeat = m.getHeartbeat();
        }
        if (!oldaddr.equals((Object)this.address)) {
            this.parent.brokerChanged(ClusterReason.ADDRESS_CHANGED, this.getBrokerName(), oldaddr, this.address, null, null);
        }
    }

    void setIsLocal(boolean local) {
        this.local = local;
    }

    public String toString() {
        if (!this.local) {
            return "-" + this.brokerid + "@" + this.address + ":" + this.state + "[StoreSession:" + this.session + ", BrokerSession:" + this.brokerSessionUID + "]:" + BrokerStatus.toString(this.status);
        }
        return "*" + this.brokerid + "@" + this.address + ":" + this.state + "[StoreSession:" + this.session + ", BrokerSession:" + this.brokerSessionUID + "]:" + BrokerStatus.toString(this.status);
    }

    @Override
    public String getBrokerName() {
        return this.brokerid;
    }

    @Override
    public MQAddress getBrokerURL() {
        return this.address;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public void setInstanceName(String instName) {
        this.instanceName = instName;
    }

    @Override
    public void setBrokerURL(MQAddress address) throws Exception {
        if (!this.local) {
            throw new UnsupportedOperationException("Only the local broker can have its url changed");
        }
        MQAddress oldaddress = this.address;
        try {
            this.updateEntry(1, null, address.toString());
            this.address = address;
        }
        catch (Exception ex) {
            this.logger.logStack(32, ex.getMessage() + "[" + oldaddress + ", " + address + "]" + this.brokerid, (Throwable)ex);
            throw ex;
        }
        this.parent.brokerChanged(ClusterReason.ADDRESS_CHANGED, this.getBrokerName(), oldaddress, this.address, null, null);
    }

    @Override
    public void resetTakeoverBrokerReadyOperating() throws Exception {
        if (!this.local) {
            throw new UnsupportedOperationException("Only the local broker can have its takeover broker reset");
        }
        this.getState();
        if (this.state == BrokerState.FAILOVER_PENDING || this.state == BrokerState.FAILOVER_STARTED) {
            String otherb = this.getTakeoverBroker();
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4310", otherb == null ? "" : otherb, this.toString()));
        }
        try {
            UID curssid = this.updateEntry(2, this.state, this.getBrokerSessionUID());
            if (curssid != null) {
                this.session = curssid;
                this.parent.localSessionUID = curssid;
            }
        }
        catch (Exception ex) {
            this.logger.logStack(32, ex.getMessage() + "[" + this.brokerid + "]", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public boolean isLocalBroker() {
        return this.local;
    }

    @Override
    public synchronized int getStatus() {
        return this.status;
    }

    @Override
    public synchronized int getVersion() {
        return this.version == null ? 0 : this.version;
    }

    @Override
    public synchronized void setVersion(int version) throws Exception {
        Integer oldversion = this.version;
        Integer newVersion = version;
        if (this.local) {
            try {
                this.updateEntry(0, this.version, newVersion);
                this.version = newVersion;
            }
            catch (Exception ex) {
                this.logger.logStack(16, ex.getMessage() + "[" + oldversion + ", " + version + "]" + this.brokerid, (Throwable)ex);
                throw ex;
            }
        }
        this.parent.brokerChanged(ClusterReason.VERSION_CHANGED, this.getBrokerName(), oldversion, this.version, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(int newstatus, Object userData) {
        UID uid = null;
        Integer oldstatus = null;
        HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
        synchronized (hAClusteredBrokerImpl) {
            if (this.status == newstatus) {
                return;
            }
            uid = this.getBrokerSessionUID();
            oldstatus = this.status;
            this.status = newstatus;
        }
        if (!oldstatus.equals(this.status)) {
            this.parent.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), oldstatus, this.status, uid, userData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBrokerIsUp(boolean up, UID brokerSession, Object userData) {
        UID uid = brokerSession;
        Integer oldstatus = null;
        Integer newstatus = null;
        HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
        synchronized (hAClusteredBrokerImpl) {
            if (!up && !uid.equals((Object)this.getBrokerSessionUID())) {
                this.logger.log(8, Globals.getBrokerResources().getKString("B1337", "[BrokerSession:" + uid + "]", this.toString()));
                oldstatus = 16;
                newstatus = BrokerStatus.setBrokerIsDown(oldstatus);
            } else {
                oldstatus = this.status;
                int newStatus = 0;
                if (up) {
                    newStatus = BrokerStatus.setBrokerIsUp(this.status);
                } else {
                    newStatus = BrokerStatus.setBrokerIsDown(this.status);
                    newStatus = BrokerStatus.setBrokerNotInDoubt(newStatus);
                }
                uid = this.getBrokerSessionUID();
                newstatus = this.status = Integer.valueOf(newStatus);
            }
        }
        if (!oldstatus.equals(this.status)) {
            this.parent.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), oldstatus, newstatus, uid, userData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBrokerLinkUp(boolean up, Object userData) {
        UID uid = null;
        Integer oldstatus = null;
        HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
        synchronized (hAClusteredBrokerImpl) {
            oldstatus = this.status;
            int newStatus = 0;
            uid = this.getBrokerSessionUID();
            newStatus = up ? BrokerStatus.setBrokerLinkIsUp(this.status) : BrokerStatus.setBrokerLinkIsDown(this.status);
            this.status = newStatus;
        }
        if (!oldstatus.equals(this.status)) {
            this.parent.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), oldstatus, this.status, uid, userData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBrokerInDoubt(boolean up, Object userData) {
        UID uid = (UID)userData;
        Integer oldstatus = null;
        Integer newstatus = null;
        HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
        synchronized (hAClusteredBrokerImpl) {
            if (up && !uid.equals((Object)this.getBrokerSessionUID())) {
                this.logger.log(8, Globals.getBrokerResources().getKString("B1336", "[BrokerSession:" + uid + "]", this.toString()));
                oldstatus = 257;
                newstatus = BrokerStatus.setBrokerInDoubt(oldstatus);
            } else {
                oldstatus = this.status;
                int newStatus = 0;
                newStatus = up ? BrokerStatus.setBrokerInDoubt(this.status) : BrokerStatus.setBrokerNotInDoubt(this.status);
                uid = this.getBrokerSessionUID();
                newstatus = this.status = Integer.valueOf(newStatus);
            }
        }
        if (!oldstatus.equals(this.status)) {
            this.parent.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), oldstatus, newstatus, uid, userData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
        synchronized (hAClusteredBrokerImpl) {
            this.status = BrokerStatus.setBrokerIsDown(this.status);
        }
    }

    @Override
    public synchronized UID getStoreSessionUID() {
        return this.session;
    }

    @Override
    public synchronized UID getBrokerSessionUID() {
        return this.brokerSessionUID;
    }

    @Override
    public synchronized void setBrokerSessionUID(UID uid) {
        this.brokerSessionUID = uid;
    }

    @Override
    public boolean isBrokerIDGenerated() {
        return false;
    }

    @Override
    public synchronized String getTakeoverBroker() throws BrokerException {
        HABrokerInfo bkrInfo = Globals.getStore().getBrokerInfo(this.brokerid);
        if (bkrInfo == null) {
            this.logger.log(32, "B3169", (Object)this.brokerid);
            return null;
        }
        this.takeoverBroker = bkrInfo.getTakeoverBrokerID();
        return this.takeoverBroker;
    }

    @Override
    public long getHeartbeat() throws BrokerException {
        this.heartbeat = Globals.getStore().getBrokerHeartbeat(this.brokerid);
        return this.heartbeat;
    }

    @Override
    public synchronized long updateHeartbeat() throws BrokerException {
        return this.updateHeartbeat(false);
    }

    @Override
    public synchronized long updateHeartbeat(boolean reset) throws BrokerException {
        Store store = Globals.getStore();
        Long newheartbeat = null;
        if (reset) {
            newheartbeat = store.updateBrokerHeartbeat(this.brokerid);
            if (newheartbeat == null) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4223", this.brokerid, "Failed to reset heartbeat timestamp."));
            }
        } else {
            newheartbeat = store.updateBrokerHeartbeat(this.brokerid, this.heartbeat);
            if (newheartbeat == null) {
                this.logger.log(16, Globals.getBrokerResources().getKString("B4223", this.brokerid, "Reset heartbeat timestamp due to synchronization problem."));
                newheartbeat = store.updateBrokerHeartbeat(this.brokerid);
                if (newheartbeat == null) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4223", this.brokerid, "Failed to reset heartbeat timestamp."));
                }
            }
        }
        this.heartbeat = newheartbeat;
        return this.heartbeat;
    }

    protected synchronized UID updateEntry(int updateType, Object oldValue, Object newValue) throws Exception {
        if (!this.local) {
            throw new IllegalAccessException("Can not update entry  for broker " + this.brokerid);
        }
        Store store = Globals.getStore();
        UID ssid = store.updateBrokerInfo(this.brokerid, updateType, oldValue, newValue);
        try {
            this.heartbeat = store.getBrokerHeartbeat(this.brokerid);
        }
        catch (Exception ex) {
            this.logger.logStack(16, ex.getMessage() + "[" + this.brokerid + "]", (Throwable)ex);
        }
        return ssid;
    }

    @Override
    public BrokerState getState() throws BrokerException {
        BrokerState oldState = this.state;
        this.state = Globals.getStore().getBrokerState(this.brokerid);
        if (oldState != this.state && this.state != BrokerState.FAILOVER_PENDING) {
            this.parent.brokerChanged(ClusterReason.STATE_CHANGED, this.getBrokerName(), oldState, this.state, null, null);
        }
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStateFailoverProcessed(UID storeSession) throws Exception {
        if (this.local) {
            throw new IllegalAccessException("Cannot update self state to " + BrokerState.FAILOVER_PROCESSED);
        }
        BrokerState newstate = BrokerState.FAILOVER_PROCESSED;
        try {
            BrokerState oldState = this.getState();
            HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
            synchronized (hAClusteredBrokerImpl) {
                if (storeSession.equals((Object)this.session)) {
                    this.state = newstate;
                } else {
                    oldState = BrokerState.FAILOVER_COMPLETE;
                }
            }
            this.parent.brokerChanged(ClusterReason.STATE_CHANGED, this.getBrokerName(), oldState, newstate, storeSession, null);
        }
        catch (Exception ex) {
            IllegalStateException e = new IllegalStateException("Failed to update state " + BrokerState.FAILOVER_COMPLETE + " for " + this.brokerid);
            e.initCause(ex);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStateFailoverFailed(UID brokerSession) throws Exception {
        if (this.local) {
            throw new IllegalAccessException("Cannot update self state to " + BrokerState.FAILOVER_FAILED);
        }
        BrokerState newstate = BrokerState.FAILOVER_FAILED;
        try {
            BrokerState oldState = this.getState();
            HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
            synchronized (hAClusteredBrokerImpl) {
                if (this.brokerSessionUID.equals((Object)brokerSession)) {
                    this.state = newstate;
                } else {
                    oldState = BrokerState.OPERATING;
                }
            }
            this.parent.brokerChanged(ClusterReason.STATE_CHANGED, this.getBrokerName(), oldState, newstate, brokerSession, null);
        }
        catch (Exception ex) {
            IllegalStateException e = new IllegalStateException("Failed to update state to " + BrokerState.FAILOVER_FAILED + " for " + this.brokerid);
            e.initCause(ex);
            throw e;
        }
    }

    @Override
    public void setState(BrokerState newstate) throws IllegalAccessException {
        if (!this.local && newstate != BrokerState.FAILOVER_PROCESSED && newstate != BrokerState.FAILOVER_STARTED && newstate != BrokerState.FAILOVER_COMPLETE && newstate != BrokerState.FAILOVER_FAILED) {
            throw new IllegalAccessException("Cannot update state  for broker " + this.brokerid);
        }
        try {
            BrokerState oldState = this.getState();
            if (newstate != BrokerState.FAILOVER_PENDING && newstate != BrokerState.FAILOVER_PROCESSED && newstate != BrokerState.FAILOVER_FAILED && !Globals.getStore().updateBrokerState(this.brokerid, newstate, this.state, this.local)) {
                throw new IllegalStateException("Could not update broker state from " + oldState + " to state " + newstate + " for " + this.brokerid);
            }
            this.state = newstate;
            this.parent.brokerChanged(ClusterReason.STATE_CHANGED, this.getBrokerName(), oldState, this.state, null, null);
        }
        catch (BrokerException ex) {
            IllegalStateException e = new IllegalStateException(Globals.getBrokerResources().getKString("B3100", "Failed to update state for " + this.brokerid));
            e.initCause(ex);
            throw e;
        }
    }

    public static void checkCanTakeoverState(BrokerState stateToCheck, String brokerID) throws BrokerException {
        if (stateToCheck == BrokerState.INITIALIZING || stateToCheck == BrokerState.SHUTDOWN_STARTED || stateToCheck == BrokerState.SHUTDOWN_COMPLETE) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4376", brokerID, stateToCheck), 405);
        }
        if (stateToCheck == BrokerState.FAILOVER_PENDING || stateToCheck == BrokerState.FAILOVER_STARTED || stateToCheck == BrokerState.FAILOVER_COMPLETE || stateToCheck == BrokerState.FAILOVER_PROCESSED) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B1191", brokerID), 409);
        }
    }

    @Override
    public TakeoverStoreInfo takeover(boolean force, Object extraInfo, TakingoverTracker tracker) throws BrokerException {
        int delay = Globals.getConfig().getIntProperty("imq.cluster.takeover.delay.interval", 0);
        if (delay > 0) {
            try {
                Thread.sleep((long)delay * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        boolean gotLock = false;
        boolean sucessful = false;
        BrokerState curstate = this.getState();
        if (!force) {
            HAClusteredBrokerImpl.checkCanTakeoverState(curstate, this.brokerid);
        }
        long newtime = System.currentTimeMillis();
        BrokerState newstate = BrokerState.FAILOVER_PENDING;
        Globals.getStore().getTakeOverLock(this.parent.getLocalBrokerName(), this.brokerid, tracker.getLastHeartbeat(), curstate, newtime, newstate, force, tracker);
        gotLock = true;
        this.state = newstate;
        this.logger.log(4, "state = FAILOVER_PENDING " + this.brokerid);
        this.parent.brokerChanged(ClusterReason.STATE_CHANGED, this.brokerid, curstate, newstate, null, null);
        TakeoverStoreInfo o = null;
        try {
            this.logger.log(4, "state = FAILOVER_STARTED " + this.brokerid);
            this.setState(BrokerState.FAILOVER_STARTED);
            o = Globals.getStore().takeOverBrokerStore(this.parent.getLocalBrokerName(), this.brokerid, tracker);
            this.logger.log(4, "state = FAILOVER_COMPLETE " + this.brokerid);
            sucessful = true;
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Internal error, shouldnt happen", ex);
        }
        finally {
            if (gotLock && !sucessful) {
                try {
                    this.setStateFailoverFailed(tracker.getBrokerSessionUID());
                }
                catch (Exception ex) {
                    this.logger.log(8, "Unable to set state to failed for broker " + this + ": " + ex.getMessage(), (Throwable)ex);
                }
                this.logger.log(16, "Failed to takeover :" + this.brokerid + " state expected is " + curstate);
            }
        }
        this.heartbeat = newtime;
        this.parent.addSupportedStoreSessionUID(this.session);
        this.takeoverBroker = this.parent.getLocalBrokerName();
        return o;
    }

    @Override
    public boolean isConfigBroker() {
        return true;
    }

    @Override
    public String getNodeName() throws BrokerException {
        throw new UnsupportedOperationException("Unexpected call" + this.getClass().getName() + ".getNodeName()");
    }
}

