/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class UpdateBrokerPropsHandler
extends AdminCmdHandler {
    private static boolean DEBUG = UpdateBrokerPropsHandler.getDEBUG();

    public UpdateBrokerPropsHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        HAMonitorService hamonitor;
        int status = 200;
        String msg = null;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + cmd_props);
        }
        if ((hamonitor = Globals.getHAMonitorService()) != null && hamonitor.inTakeover()) {
            status = 500;
            msg = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + msg);
        } else {
            Properties p = (Properties)this.getBodyObject(cmd_msg);
            this.logger.log(8, "B1521", (Object)("[" + p + "]"));
            BrokerConfig bcfg = Globals.getConfig();
            try {
                bcfg.updateProperties(p, true);
            }
            catch (PropertyUpdateException e) {
                status = 400;
                msg = e.getMessage();
                this.logger.log(16, msg);
            }
            catch (IOException e) {
                status = 500;
                msg = e.toString();
                this.logger.log(16, msg);
            }
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        UpdateBrokerPropsHandler.setProperties(reply, 57, status, msg);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

