/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.impl;

import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.impl.AnnotationConstants;
import com.sun.jdo.api.persistence.enhancer.util.Support;

class InsnNote
extends Support
implements AnnotationConstants {
    final Insn insn;
    int insnFlags;
    final int argWord;
    final String stackSig;
    final String targetClassName;
    final String targetFieldName;
    final int targetFieldIndex;
    final String targetPCRootClass;

    InsnNote next() {
        return null;
    }

    final String sig() {
        return this.stackSig;
    }

    final int arg() {
        return this.argWord;
    }

    final boolean fetchThis() {
        return (this.insnFlags & 1) != 0;
    }

    final boolean dirtyThis() {
        return (this.insnFlags & 2) != 0;
    }

    final boolean fetchPersistent() {
        return (this.insnFlags & 0x10) != 0;
    }

    final boolean dirtyPersistent() {
        return (this.insnFlags & 0x20) != 0;
    }

    final boolean dfgFieldAccess() {
        return (this.insnFlags & 0x800) != 0;
    }

    final boolean pkFieldAccess() {
        return (this.insnFlags & 0x1000) != 0;
    }

    InsnNote(Insn i, int flags, int argWord, String stackSig, String targetClassName, String targetFieldName, int targetFieldIndex, String targetPCRootClass) {
        this.insn = i;
        this.insnFlags = flags;
        this.stackSig = stackSig;
        this.argWord = argWord;
        this.targetClassName = targetClassName;
        this.targetFieldName = targetFieldName;
        this.targetFieldIndex = targetFieldIndex;
        this.targetPCRootClass = targetPCRootClass;
        InsnNote.affirm(this.insn != null && argWord >= 0 && targetClassName != null && targetFieldName != null && targetFieldIndex >= 0 && targetPCRootClass != null, "Inconsistent instruction annotation note.");
    }
}

