/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.connectors.jms.JMSLoggerInfo;
import com.sun.enterprise.connectors.jms.config.JmsHost;
import com.sun.enterprise.connectors.jms.config.JmsService;
import com.sun.enterprise.connectors.jms.system.ActiveJmsResourceAdapter;
import com.sun.enterprise.connectors.jms.system.MQAddressList;
import com.sun.enterprise.connectors.jms.util.JmsRaUtil;
import com.sun.enterprise.v3.services.impl.DummyNetworkListener;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
public class JMSConfigListener
implements ConfigListener {
    private JmsService jmsService;
    @Inject
    @Named(value="default-instance-name")
    private Config serverConfig;
    @Inject
    private Servers servers;
    private ActiveJmsResourceAdapter aresourceAdapter;
    private static final Logger LOG = JMSLoggerInfo.getLogger();

    public void setActiveResourceAdapter(ActiveJmsResourceAdapter aresourceAdapter) {
        this.aresourceAdapter = aresourceAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        LOG.log(Level.CONFIG, "changed(events={0})", events);
        this.jmsService = (JmsService)this.serverConfig.getExtensionByType(JmsService.class);
        ArrayList<UnprocessedChangeEvent> unprocessedEvents = new ArrayList<UnprocessedChangeEvent>();
        LOG.log(Level.FINE, "In JMSConfigListener - received config event");
        Domain domain = (Domain)Globals.get(Domain.class);
        String jmsProviderPort = null;
        ServerContext serverContext = (ServerContext)Globals.get(ServerContext.class);
        Server thisServer = domain.getServerNamed(serverContext.getInstanceName());
        for (int i = 0; i < events.length; ++i) {
            PropertyChangeEvent event = events[i];
            String eventName = event.getPropertyName();
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            LOG.log(Level.FINE, "In JMSConfigListener. Event name={0}, oldValue={1}, newValue={2}", new Object[]{eventName, oldValue, newValue});
            if (oldValue != null && oldValue.equals(newValue)) continue;
            if (event.getSource().toString().indexOf("connectors.jms.config.JmsService") != -1) {
                boolean notifyFlag = true;
                if (oldValue != null && newValue == null && "jms-host".equals(event.getPropertyName())) {
                    JmsHost jmsHost = (JmsHost)oldValue;
                    String name = "JMS_PROXY_" + jmsHost.getName();
                    ActiveJmsResourceAdapter adapter = (ActiveJmsResourceAdapter)((Object)Globals.get(ActiveJmsResourceAdapter.class));
                    if (adapter.getGrizzlyListeners().contains(name)) {
                        GrizzlyService grizzlyService = (GrizzlyService)Globals.get(GrizzlyService.class);
                        Set<String> set = adapter.getGrizzlyListeners();
                        synchronized (set) {
                            LOG.log(Level.FINE, "Stopping Grizzly proxy {0}", name);
                            grizzlyService.removeNetworkProxy(name);
                            adapter.getGrizzlyListeners().remove(name);
                        }
                        notifyFlag = false;
                    }
                }
                if (notifyFlag) {
                    UnprocessedChangeEvent uchangeEvent = new UnprocessedChangeEvent(event, "restart required");
                    unprocessedEvents.add(uchangeEvent);
                }
            } else if (event.getSource().toString().indexOf("connectors.jms.config.JmsHost") != -1 && oldValue == null && newValue != null && "name".equals(event.getPropertyName())) {
                ActiveJmsResourceAdapter adapter;
                JmsHost jmsHost = (JmsHost)event.getSource();
                if ("EMBEDDED".equalsIgnoreCase(this.jmsService.getType()) && !(adapter = (ActiveJmsResourceAdapter)((Object)Globals.get(ActiveJmsResourceAdapter.class))).getDoBind() && Boolean.valueOf(jmsHost.getLazyInit()).booleanValue()) {
                    String host = null;
                    host = jmsHost.getHost() != null && "localhost".equals(jmsHost.getHost()) ? "0.0.0.0" : jmsHost.getHost();
                    try {
                        GrizzlyService grizzlyService = (GrizzlyService)Globals.get(GrizzlyService.class);
                        DummyNetworkListener dummy = new DummyNetworkListener();
                        dummy.setPort(jmsHost.getPort());
                        dummy.setAddress(host);
                        dummy.setType("proxy");
                        dummy.setProtocol("mq-service");
                        dummy.setTransport("tcp");
                        String name = "JMS_PROXY_" + jmsHost.getName();
                        dummy.setName(name);
                        Set<String> set = adapter.getGrizzlyListeners();
                        synchronized (set) {
                            LOG.log(Level.FINE, "Starting Grizzly proxy {0} on port {1}", new Object[]{name, jmsHost.getPort()});
                            grizzlyService.createNetworkProxy((NetworkListener)dummy);
                            adapter.getGrizzlyListeners().add(name);
                        }
                        return unprocessedEvents.size() > 0 ? new UnprocessedChangeEvents(unprocessedEvents) : null;
                    }
                    catch (Exception e) {
                        LogHelper.log((Logger)LOG, (Level)Level.WARNING, (String)"AS-JMS-CORE-00016", (Throwable)e, (Object[])new Object[0]);
                    }
                }
            }
            if ("JMS_PROVIDER_PORT".equals(newValue)) {
                PropertyChangeEvent nextevent = events[i + 1];
                jmsProviderPort = (String)nextevent.getNewValue();
            }
            if (event.getSource() instanceof JmsService && eventName.equals("master-broker")) {
                Server newMBServer;
                String oldMB = oldValue == null ? null : oldValue.toString();
                String newMB = newValue == null ? null : newValue.toString();
                LOG.log(Level.FINE, "Got JmsService Master Broker change event. Source={0}, eventName={1}, oldMB={2}, newMB={3}", new Object[]{event.getSource(), eventName, oldMB, newMB});
                if (newMB != null && (newMBServer = domain.getServerNamed(newMB)) != null) {
                    Node node = domain.getNodeNamed(newMBServer.getNodeRef());
                    String newMasterBrokerPort = JmsRaUtil.getJMSPropertyValue(newMBServer);
                    if (newMasterBrokerPort == null) {
                        newMasterBrokerPort = this.getDefaultJmsHost(this.jmsService).getPort();
                    }
                    String newMasterBrokerHost = node.getNodeHost();
                    this.aresourceAdapter.setMasterBroker(newMasterBrokerHost + ":" + newMasterBrokerPort);
                }
            }
            if (eventName.equals("server-ref")) {
                String newServerRef;
                String oldServerRef = oldValue != null ? oldValue.toString() : null;
                String string = newServerRef = newValue != null ? newValue.toString() : null;
                if (oldServerRef != null && newServerRef == null && !thisServer.isDas()) {
                    LOG.log(Level.FINE, "Got Cluster change event for server_ref. Server={0}, eventName={1}, oldServerRef={2}", new Object[]{event.getSource(), eventName, oldServerRef});
                    String url = this.getBrokerList();
                    this.aresourceAdapter.setClusterBrokerList(url);
                    break;
                }
            }
            if (!(event.getSource() instanceof Server)) continue;
            LOG.log(Level.FINE, "In JMSConfigListener - recieved cluster event. Event source={0}", event.getSource());
            Server changedServer = (Server)event.getSource();
            if (thisServer.isDas()) {
                return null;
            }
            if (jmsProviderPort == null) continue;
            String nodeName = changedServer.getNodeRef();
            String nodeHost = null;
            if (nodeName != null) {
                nodeHost = domain.getNodeNamed(nodeName).getNodeHost();
            }
            Object url = this.getBrokerList();
            url = (String)url + ",mq://" + nodeHost + ":" + jmsProviderPort;
            this.aresourceAdapter.setClusterBrokerList((String)url);
            break;
        }
        return unprocessedEvents.isEmpty() ? null : new UnprocessedChangeEvents(unprocessedEvents);
    }

    private String getBrokerList() {
        MQAddressList addressList = new MQAddressList();
        try {
            addressList.setup(true);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "AS-JMS-CORE-00017", ex.getMessage());
            LOG.log(Level.SEVERE, "The addressList.setup(true) failed.", ex);
        }
        return addressList.toString();
    }

    private JmsHost getDefaultJmsHost(JmsService jmsService) {
        JmsHost jmsHost = null;
        String defaultJmsHostName = jmsService.getDefaultJmsHost();
        List<JmsHost> jmsHostsList = jmsService.getJmsHost();
        for (JmsHost tmpJmsHost : jmsHostsList) {
            if (tmpJmsHost == null || !tmpJmsHost.getName().equals(defaultJmsHostName)) continue;
            jmsHost = tmpJmsHost;
        }
        if (jmsHost == null && !jmsHostsList.isEmpty()) {
            jmsHost = jmsHostsList.get(0);
        }
        return jmsHost;
    }
}

