/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.CDI11Bootstrap;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.bootstrap.api.TypeDiscoveryConfiguration;
import org.jboss.weld.bootstrap.api.helpers.RegistrySingletonProvider;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.Scanning;
import org.jboss.weld.bootstrap.spi.helpers.MetadataImpl;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.configuration.spi.ExternalConfiguration;
import org.jboss.weld.configuration.spi.helpers.ExternalConfigurationBuilder;
import org.jboss.weld.environment.ContainerInstanceFactory;
import org.jboss.weld.environment.deployment.WeldBeanDeploymentArchive;
import org.jboss.weld.environment.deployment.WeldDeployment;
import org.jboss.weld.environment.deployment.WeldResourceLoader;
import org.jboss.weld.environment.deployment.discovery.ClassPathBeanArchiveScanner;
import org.jboss.weld.environment.deployment.discovery.DiscoveryStrategy;
import org.jboss.weld.environment.deployment.discovery.DiscoveryStrategyFactory;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.environment.se.ContainerLifecycleObserver;
import org.jboss.weld.environment.se.SecurityActions;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.WeldSEBeanRegistrant;
import org.jboss.weld.environment.se.contexts.ThreadScoped;
import org.jboss.weld.environment.se.logging.WeldSELogger;
import org.jboss.weld.environment.util.BeanArchives;
import org.jboss.weld.environment.util.Files;
import org.jboss.weld.environment.util.Reflections;
import org.jboss.weld.executor.ExecutorServicesFactory;
import org.jboss.weld.lite.extension.translator.BuildCompatibleExtensionLoader;
import org.jboss.weld.lite.extension.translator.LiteExtensionTranslator;
import org.jboss.weld.metadata.BeansXmlImpl;
import org.jboss.weld.resources.ClassLoaderResourceLoader;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.security.GetClassLoaderAction;
import org.jboss.weld.security.GetSystemPropertyAction;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.ServiceLoader;
import org.jboss.weld.util.Services;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.collections.Iterables;
import org.jboss.weld.util.collections.Multimap;
import org.jboss.weld.util.collections.WeldCollections;

@Vetoed
public class Weld
extends SeContainerInitializer
implements ContainerInstanceFactory {
    public static final String ADDITIONAL_BEAN_DEFINING_ANNOTATIONS_PROPERTY = "org.jboss.weld.se.additionalBeanDefiningAnnotations";
    public static final String ARCHIVE_ISOLATION_SYSTEM_PROPERTY = "org.jboss.weld.se.archive.isolation";
    @Deprecated(since="5.1.0.Final")
    public static final String DEV_MODE_SYSTEM_PROPERTY = "org.jboss.weld.development";
    public static final String EMPTY_BEANS_XML_DISCOVERY_MODE_ALL = "org.jboss.weld.se.discovery.emptyBeansXmlModeAll";
    public static final String SHUTDOWN_HOOK_SYSTEM_PROPERTY = "org.jboss.weld.se.shutdownHook";
    public static final String SCAN_CLASSPATH_ENTRIES_SYSTEM_PROPERTY = "org.jboss.weld.se.scan.classpath.entries";
    public static final String JAVAX_ENTERPRISE_INJECT_SCAN_IMPLICIT = "jakarta.enterprise.inject.scan.implicit";
    public static final String ALLOW_OPTIMIZED_CLEANUP = "org.jboss.weld.bootstrap.allowOptimizedCleanup";
    private static final String SYNTHETIC_LOCATION_PREFIX = "synthetic:";
    private final Map<String, WeldContainer> initializedContainers;
    private String containerId;
    private boolean discoveryEnabled = true;
    protected final Set<Class<?>> beanClasses;
    protected final Set<Class<? extends Annotation>> extendedBeanDefiningAnnotations;
    protected BeanDiscoveryMode beanDiscoveryMode = BeanDiscoveryMode.ANNOTATED;
    private final List<Metadata<String>> selectedAlternatives;
    private final List<Metadata<String>> selectedAlternativeStereotypes;
    private final List<Metadata<String>> enabledInterceptors;
    private final List<Metadata<String>> enabledDecorators;
    private final Set<Metadata<Extension>> extensions;
    private final Map<String, Object> properties;
    private final Set<PackInfo> packages;
    private final List<ContainerLifecycleObserver<?>> containerLifecycleObservers;
    private ResourceLoader resourceLoader;
    protected final Map<Class<? extends Service>, Service> additionalServices;

    public Weld() {
        this(null);
    }

    public Weld(String containerId) {
        this.containerId = containerId;
        this.initializedContainers = new HashMap<String, WeldContainer>();
        this.beanClasses = new HashSet();
        this.selectedAlternatives = new ArrayList<Metadata<String>>();
        this.selectedAlternativeStereotypes = new ArrayList<Metadata<String>>();
        this.enabledInterceptors = new ArrayList<Metadata<String>>();
        this.enabledDecorators = new ArrayList<Metadata<String>>();
        this.extensions = new HashSet<Metadata<Extension>>();
        this.properties = new HashMap<String, Object>();
        this.packages = new HashSet<PackInfo>();
        this.containerLifecycleObservers = new LinkedList();
        this.resourceLoader = new WeldResourceLoader();
        this.additionalServices = new HashMap<Class<? extends Service>, Service>();
        this.extendedBeanDefiningAnnotations = new HashSet<Class<? extends Annotation>>();
    }

    public Weld containerId(String containerId) {
        this.containerId = containerId;
        return this;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public Weld beanClasses(Class<?> ... classes) {
        this.beanClasses.clear();
        this.addBeanClasses((Class[])classes);
        return this;
    }

    public Weld addBeanClass(Class<?> beanClass) {
        this.beanClasses.add(beanClass);
        return this;
    }

    @Override
    public Weld addBeanClasses(Class<?> ... classes) {
        for (Class<?> aClass : classes) {
            this.addBeanClass(aClass);
        }
        return this;
    }

    public Weld packages(Class<?> ... packageClasses) {
        this.packages.clear();
        this.addPackages(false, (Class[])packageClasses);
        return this;
    }

    @Override
    public Weld addPackages(boolean scanRecursively, Class<?> ... packageClasses) {
        for (Class<?> packageClass : packageClasses) {
            this.addPackage(scanRecursively, packageClass);
        }
        return this;
    }

    @Override
    public Weld addPackages(Class<?> ... packageClasses) {
        this.addPackages(false, (Class[])packageClasses);
        return this;
    }

    @Override
    public Weld addPackages(Package ... packages) {
        this.addPackages(false, packages);
        return this;
    }

    @Override
    public Weld addPackages(boolean scanRecursively, Package ... packages) {
        for (Package pack : packages) {
            this.packages.add(new PackInfo(pack, scanRecursively));
        }
        return this;
    }

    public Weld addPackage(boolean scanRecursively, Class<?> packageClass) {
        this.packages.add(new PackInfo(packageClass, scanRecursively));
        return this;
    }

    public Weld extensions(Extension ... extensions) {
        this.extensions.clear();
        for (Extension extension : extensions) {
            this.addExtension(extension);
        }
        return this;
    }

    public Weld addExtension(Extension extension) {
        this.extensions.add(new MetadataImpl<Extension>(extension, SYNTHETIC_LOCATION_PREFIX + extension.getClass().getName()));
        return this;
    }

    @Override
    public Weld addExtensions(Extension ... extensions) {
        for (Extension extension : extensions) {
            this.addExtension(extension);
        }
        return this;
    }

    @Override
    public Weld addExtensions(Class<? extends Extension> ... extensionClasses) {
        for (Class<? extends Extension> extensionClass : extensionClasses) {
            try {
                Extension extension = SecurityActions.newInstance(extensionClass);
                this.addExtension(extension);
            }
            catch (Exception ex) {
                CommonLogger.LOG.unableToInstantiate(extensionClass, new Object[0], ex);
            }
        }
        return this;
    }

    public Weld addContainerLifecycleObserver(ContainerLifecycleObserver<?> observer) {
        this.containerLifecycleObservers.add(observer);
        return this;
    }

    public Weld interceptors(Class<?> ... interceptorClasses) {
        this.enabledInterceptors.clear();
        this.enableInterceptors((Class[])interceptorClasses);
        return this;
    }

    public Weld addInterceptor(Class<?> interceptorClass) {
        this.enabledInterceptors.add(this.syntheticMetadata(interceptorClass));
        return this;
    }

    @Override
    public Weld enableInterceptors(Class<?> ... interceptorClasses) {
        for (Class<?> interceptorClass : interceptorClasses) {
            this.addInterceptor(interceptorClass);
        }
        return this;
    }

    public Weld decorators(Class<?> ... decoratorClasses) {
        this.enabledDecorators.clear();
        this.enableDecorators((Class[])decoratorClasses);
        return this;
    }

    public Weld addDecorator(Class<?> decoratorClass) {
        this.enabledDecorators.add(this.syntheticMetadata(decoratorClass));
        return this;
    }

    @Override
    public Weld enableDecorators(Class<?> ... decoratorClasses) {
        for (Class<?> decoratorClass : decoratorClasses) {
            this.addDecorator(decoratorClass);
        }
        return this;
    }

    public Weld alternatives(Class<?> ... alternativeClasses) {
        this.selectedAlternatives.clear();
        this.selectAlternatives((Class[])alternativeClasses);
        return this;
    }

    public Weld addAlternative(Class<?> alternativeClass) {
        this.selectedAlternatives.add(this.syntheticMetadata(alternativeClass));
        return this;
    }

    @Override
    public Weld selectAlternatives(Class<?> ... alternativeClasses) {
        for (Class<?> alternativeClass : alternativeClasses) {
            this.addAlternative(alternativeClass);
        }
        return this;
    }

    @SafeVarargs
    public final Weld alternativeStereotypes(Class<? extends Annotation> ... alternativeStereotypeClasses) {
        this.selectedAlternativeStereotypes.clear();
        this.selectAlternativeStereotypes((Class[])alternativeStereotypeClasses);
        return this;
    }

    @Override
    public Weld selectAlternativeStereotypes(Class<? extends Annotation> ... alternativeStereotypeClasses) {
        for (Class<? extends Annotation> alternativeStereotypeClass : alternativeStereotypeClasses) {
            this.addAlternativeStereotype(alternativeStereotypeClass);
        }
        return this;
    }

    public Weld addAlternativeStereotype(Class<? extends Annotation> alternativeStereotypeClass) {
        this.selectedAlternativeStereotypes.add(this.syntheticMetadata(alternativeStereotypeClass));
        return this;
    }

    public Weld property(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public Weld properties(Map<String, Object> properties) {
        this.properties.putAll(properties);
        return this;
    }

    @Override
    public Weld addProperty(String key, Object value) {
        this.property(key, value);
        return this;
    }

    @Override
    public Weld setProperties(Map<String, Object> propertiesMap) {
        this.properties.clear();
        this.properties.putAll(propertiesMap);
        return this;
    }

    public Weld addServices(Service ... services) {
        for (Service service : services) {
            for (Class<? extends Service> serviceInterface : Services.identifyServiceInterfaces(service.getClass(), new HashSet<Class<? extends Service>>())) {
                this.additionalServices.put(serviceInterface, service);
            }
        }
        return this;
    }

    public Weld setBeanDiscoveryMode(BeanDiscoveryMode mode) {
        if (mode.equals((Object)BeanDiscoveryMode.NONE)) {
            throw WeldSELogger.LOG.beanArchiveWithModeNone(this.containerId);
        }
        this.beanDiscoveryMode = mode;
        return this;
    }

    public Weld reset() {
        this.beanClasses.clear();
        this.packages.clear();
        this.selectedAlternatives.clear();
        this.selectedAlternativeStereotypes.clear();
        this.enabledInterceptors.clear();
        this.enabledDecorators.clear();
        this.extensions.clear();
        this.containerLifecycleObservers.clear();
        this.additionalServices.clear();
        return this;
    }

    public Weld resetAll() {
        this.reset();
        this.properties.clear();
        this.enableDiscovery();
        this.containerId(null);
        return this;
    }

    public Weld enableDiscovery() {
        this.discoveryEnabled = true;
        return this;
    }

    @Override
    public Weld disableDiscovery() {
        this.discoveryEnabled = false;
        return this;
    }

    public boolean isDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    @Override
    public WeldContainer initialize() {
        if (!this.isSyntheticBeanArchiveRequired() && !this.isImplicitScanEnabled() && this.resourceLoader.getResource("META-INF/beans.xml") == null) {
            throw CommonLogger.LOG.missingBeansXml();
        }
        WeldBootstrap bootstrap = new WeldBootstrap();
        this.parseAdditionalBeanDefiningAnnotations();
        Deployment deployment = this.createDeployment(this.resourceLoader, bootstrap);
        ExternalConfigurationBuilder configurationBuilder = new ExternalConfigurationBuilder().add(ConfigurationKey.EXECUTOR_THREAD_POOL_TYPE.get(), ExecutorServicesFactory.ThreadPoolType.COMMON.toString()).add(ConfigurationKey.RELAXED_CONSTRUCTION.get(), true).add(ConfigurationKey.ALLOW_OPTIMIZED_CLEANUP.get(), this.isEnabled(ALLOW_OPTIMIZED_CLEANUP, true));
        for (Map.Entry<String, Object> property : this.properties.entrySet()) {
            String key = property.getKey();
            if (SHUTDOWN_HOOK_SYSTEM_PROPERTY.equals(key) || ARCHIVE_ISOLATION_SYSTEM_PROPERTY.equals(key) || SCAN_CLASSPATH_ENTRIES_SYSTEM_PROPERTY.equals(key) || JAVAX_ENTERPRISE_INJECT_SCAN_IMPLICIT.equals(key) || ADDITIONAL_BEAN_DEFINING_ANNOTATIONS_PROPERTY.equals(key)) continue;
            configurationBuilder.add(key, property.getValue());
        }
        deployment.getServices().add(ExternalConfiguration.class, configurationBuilder.build());
        String containerId = this.containerId != null ? this.containerId : UUID.randomUUID().toString();
        bootstrap.startContainer(containerId, Environments.SE, deployment);
        WeldContainer weldContainer = WeldContainer.startInitialization(containerId, deployment, bootstrap);
        try {
            bootstrap.startInitialization();
            bootstrap.deployBeans();
            bootstrap.validateBeans();
            bootstrap.endInitialization();
            WeldContainer.endInitialization(weldContainer, this.isEnabled(SHUTDOWN_HOOK_SYSTEM_PROPERTY, true));
            this.initializedContainers.put(containerId, weldContainer);
        }
        catch (Throwable e) {
            WeldContainer.discard(weldContainer.getId());
            throw e;
        }
        return weldContainer;
    }

    public void shutdown() {
        if (!this.initializedContainers.isEmpty()) {
            for (WeldContainer container : this.initializedContainers.values()) {
                container.shutdown();
            }
        }
    }

    @Override
    public Weld setClassLoader(ClassLoader classLoader) {
        Preconditions.checkNotNull(classLoader);
        this.resourceLoader = new ClassLoaderResourceLoader(classLoader);
        return this;
    }

    public Weld setResourceLoader(ResourceLoader resourceLoader) {
        Preconditions.checkNotNull(resourceLoader);
        this.resourceLoader = resourceLoader;
        return this;
    }

    public Weld disableIsolation() {
        return this.property(ARCHIVE_ISOLATION_SYSTEM_PROPERTY, false);
    }

    public Weld skipShutdownHook() {
        return this.property(SHUTDOWN_HOOK_SYSTEM_PROPERTY, false);
    }

    public Weld scanClasspathEntries() {
        return this.property(SCAN_CLASSPATH_ENTRIES_SYSTEM_PROPERTY, true);
    }

    @Deprecated(since="5.1.0.Final")
    public Weld enableDevMode() {
        return this.property(DEV_MODE_SYSTEM_PROPERTY, true);
    }

    public Weld addBeanDefiningAnnotations(Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            this.extendedBeanDefiningAnnotations.add(annotation);
        }
        return this;
    }

    protected Deployment createDeployment(ResourceLoader resourceLoader, CDI11Bootstrap bootstrap) {
        WeldDeployment deployment;
        BeanDiscoveryMode emptyBeansXmlDiscoveryMode = this.isEnabled(EMPTY_BEANS_XML_DISCOVERY_MODE_ALL, false) ? BeanDiscoveryMode.ALL : BeanDiscoveryMode.ANNOTATED;
        Iterable<Metadata<Extension>> extensions = this.getExtensions();
        TypeDiscoveryConfiguration typeDiscoveryConfiguration = bootstrap.startExtensions(extensions);
        HashSet<WeldBeanDeploymentArchive> beanDeploymentArchives = new HashSet<WeldBeanDeploymentArchive>();
        HashMap<Class<? extends Service>, Service> additionalServices = new HashMap<Class<? extends Service>, Service>(this.additionalServices);
        Set<Class<? extends Annotation>> beanDefiningAnnotations = ImmutableSet.builder().addAll((Iterable<Class<? extends Annotation>>)typeDiscoveryConfiguration.getKnownBeanDefiningAnnotations()).add(ThreadScoped.class).addAll((Iterable<Class<ThreadScoped>>)this.extendedBeanDefiningAnnotations).build();
        if (this.discoveryEnabled) {
            DiscoveryStrategy strategy = DiscoveryStrategyFactory.create(resourceLoader, bootstrap, beanDefiningAnnotations, this.isEnabled("org.jboss.weld.discovery.disableJandexDiscovery", false), emptyBeansXmlDiscoveryMode);
            if (this.isImplicitScanEnabled()) {
                strategy.setScanner(new ClassPathBeanArchiveScanner(bootstrap, emptyBeansXmlDiscoveryMode));
            }
            beanDeploymentArchives.addAll(strategy.performDiscovery());
            ClassFileServices classFileServices = strategy.getClassFileServices();
            if (classFileServices != null) {
                additionalServices.put(ClassFileServices.class, classFileServices);
            }
        }
        if (this.isSyntheticBeanArchiveRequired()) {
            ImmutableSet.Builder<String> beanClassesBuilder = ImmutableSet.builder();
            beanClassesBuilder.addAll((Iterable<String>)this.scanPackages());
            Set<String> setOfAllBeanClasses = beanClassesBuilder.build();
            if (BeanDiscoveryMode.ANNOTATED.equals((Object)this.beanDiscoveryMode)) {
                ImmutableSet.Builder<String> builder = ImmutableSet.builder();
                for (String className : setOfAllBeanClasses) {
                    Class clazz = Reflections.loadClass(resourceLoader, className);
                    if (clazz == null || !Reflections.hasBeanDefiningAnnotation(clazz, beanDefiningAnnotations)) continue;
                    builder.add(className);
                }
                setOfAllBeanClasses = builder.build();
            }
            WeldBeanDeploymentArchive weldBeanDeploymentArchive = new WeldBeanDeploymentArchive(WeldDeployment.SYNTHETIC_BDA_ID, setOfAllBeanClasses, null, this.buildSyntheticBeansXml(), Collections.emptySet(), ImmutableSet.copyOf(this.beanClasses));
            beanDeploymentArchives.add(weldBeanDeploymentArchive);
        }
        if (beanDeploymentArchives.isEmpty() && this.containerLifecycleObservers.isEmpty() && this.extensions.isEmpty()) {
            throw WeldSELogger.LOG.weldContainerCannotBeInitializedNoBeanArchivesFound();
        }
        Multimap<String, BeanDeploymentArchive> problems = BeanArchives.findBeanClassesDeployedInMultipleBeanArchives(beanDeploymentArchives);
        if (!problems.isEmpty()) {
            for (Map.Entry entry : problems.entrySet()) {
                WeldSELogger.LOG.beanClassDeployedInMultipleBeanArchives(entry.getKey(), WeldCollections.toMultiRowString((Collection)entry.getValue()));
            }
        }
        if (this.isEnabled(ARCHIVE_ISOLATION_SYSTEM_PROPERTY, true)) {
            deployment = new WeldDeployment(resourceLoader, bootstrap, beanDeploymentArchives, extensions);
            CommonLogger.LOG.archiveIsolationEnabled();
        } else {
            HashSet<WeldBeanDeploymentArchive> flatDeployment = new HashSet<WeldBeanDeploymentArchive>();
            flatDeployment.add(WeldBeanDeploymentArchive.merge(bootstrap, beanDeploymentArchives));
            deployment = new WeldDeployment(resourceLoader, bootstrap, flatDeployment, extensions);
            CommonLogger.LOG.archiveIsolationDisabled();
        }
        for (Map.Entry entry : additionalServices.entrySet()) {
            Services.put(deployment.getServices(), (Class)entry.getKey(), (Service)entry.getValue());
        }
        return deployment;
    }

    protected <T> T getInstanceByType(BeanManager manager, Class<T> type, Annotation ... bindings) {
        Bean bean = manager.resolve(manager.getBeans(type, bindings));
        if (bean == null) {
            throw CommonLogger.LOG.unableToResolveBean(type, Arrays.asList(bindings));
        }
        CreationalContext cc = manager.createCreationalContext(bean);
        return type.cast(manager.getReference(bean, type, cc));
    }

    protected boolean isImplicitScanEnabled() {
        return this.isEnabled(SCAN_CLASSPATH_ENTRIES_SYSTEM_PROPERTY, false) || this.isEnabled(JAVAX_ENTERPRISE_INJECT_SCAN_IMPLICIT, false);
    }

    protected boolean isSyntheticBeanArchiveRequired() {
        return !this.beanClasses.isEmpty() || !this.packages.isEmpty();
    }

    protected Iterable<Metadata<Extension>> getExtensions() {
        HashSet<Metadata<Extension>> result = new HashSet<Metadata<Extension>>();
        if (this.discoveryEnabled) {
            Iterables.addAll(result, this.loadExtensions(this.resourceLoader));
        }
        if (!this.extensions.isEmpty()) {
            result.addAll(this.extensions);
        }
        WeldSEBeanRegistrant weldSEBeanRegistrant = null;
        for (Metadata metadata : result) {
            if (!((Extension)metadata.getValue()).getClass().getName().equals(WeldSEBeanRegistrant.class.getName())) continue;
            weldSEBeanRegistrant = (WeldSEBeanRegistrant)metadata.getValue();
            break;
        }
        if (weldSEBeanRegistrant == null) {
            try {
                weldSEBeanRegistrant = SecurityActions.newInstance(WeldSEBeanRegistrant.class);
                result.add(new MetadataImpl<WeldSEBeanRegistrant>(weldSEBeanRegistrant, SYNTHETIC_LOCATION_PREFIX + WeldSEBeanRegistrant.class.getName()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!BuildCompatibleExtensionLoader.getBuildCompatibleExtensions().isEmpty()) {
            try {
                result.add(new MetadataImpl<Extension>(SecurityActions.newInstance(LiteExtensionTranslator.class), SYNTHETIC_LOCATION_PREFIX + LiteExtensionTranslator.class.getName()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.containerLifecycleObservers.isEmpty()) {
            result.add(new MetadataImpl<ContainerLifecycleObserver.ContainerLifecycleObserverExtension>(new ContainerLifecycleObserver.ContainerLifecycleObserverExtension(this.containerLifecycleObservers), SYNTHETIC_LOCATION_PREFIX + ContainerLifecycleObserver.class.getName()));
        }
        return result;
    }

    private Iterable<Metadata<Extension>> loadExtensions(ResourceLoader resourceLoader) {
        return ServiceLoader.load(Extension.class, resourceLoader);
    }

    protected BeansXml buildSyntheticBeansXml() {
        return new BeansXmlImpl(ImmutableList.copyOf(this.selectedAlternatives), ImmutableList.copyOf(this.selectedAlternativeStereotypes), ImmutableList.copyOf(this.enabledDecorators), ImmutableList.copyOf(this.enabledInterceptors), Scanning.EMPTY_SCANNING, null, this.beanDiscoveryMode, null, false);
    }

    private MetadataImpl<String> syntheticMetadata(Class<?> clazz) {
        return new MetadataImpl<String>(clazz.getName(), SYNTHETIC_LOCATION_PREFIX + clazz.getName());
    }

    protected Set<String> scanPackages() {
        if (this.packages.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> foundClasses = new HashSet<String>();
        for (PackInfo packInfo : this.packages) {
            String packName = packInfo.getPackName();
            URL resourceUrl = packInfo.getResourceUrl(this.resourceLoader);
            if (resourceUrl != null) {
                WeldSELogger.LOG.scanningPackage(packName, resourceUrl);
                try {
                    URI resourceUri = resourceUrl.toURI();
                    if ("file".equals(resourceUrl.getProtocol())) {
                        File file = new File(resourceUri);
                        this.handleDir(file.isDirectory() ? file : file.getParentFile(), packInfo.isScanRecursively(), packName, foundClasses);
                        continue;
                    }
                    if ("jar".equals(resourceUrl.getProtocol())) {
                        this.handleJar(resourceUri, packInfo.isScanRecursively(), packName, foundClasses);
                        continue;
                    }
                    WeldSELogger.LOG.resourceUrlProtocolNotSupported(resourceUrl);
                }
                catch (URISyntaxException e) {
                    CommonLogger.LOG.couldNotReadResource(resourceUrl, e);
                }
                continue;
            }
            WeldSELogger.LOG.packageNotFound(packName);
        }
        return foundClasses;
    }

    private void handleDir(File packDir, boolean scanRecursively, String packName, Set<String> foundClasses) {
        if (packDir != null && packDir.exists() && packDir.canRead()) {
            for (File file : packDir.listFiles()) {
                if (file.isFile() && file.canRead() && Files.isClass(file.getName())) {
                    foundClasses.add(Files.filenameToClassname(packName + "." + file.getName()));
                }
                if (!file.isDirectory() || !scanRecursively) continue;
                this.handleDir(file, scanRecursively, packName + "." + file.getName(), foundClasses);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJar(URI resourceUri, boolean scanRecursively, String packName, Set<String> foundClasses) {
        if (resourceUri.getSchemeSpecificPart().startsWith("file")) {
            String path = resourceUri.getSchemeSpecificPart().substring("file:".length());
            if (path.lastIndexOf("!/") > 0) {
                path = path.substring(0, path.lastIndexOf("!/"));
            }
            ZipFile jar = null;
            String packNamePath = packName.replace('.', '/');
            int expectedPartsLength = this.splitBySlash(packNamePath).length + 1;
            try {
                jar = new JarFile(new File(path));
                Enumeration<JarEntry> entries = ((JarFile)jar).entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith(".class") || !entry.getName().startsWith(packNamePath + "/")) continue;
                    if (scanRecursively) {
                        foundClasses.add(Files.filenameToClassname(entry.getName()));
                        continue;
                    }
                    String[] parts = this.splitBySlash(entry.getName());
                    if (parts.length != expectedPartsLength) continue;
                    foundClasses.add(Files.filenameToClassname(entry.getName()));
                }
            }
            catch (IOException e) {
                CommonLogger.LOG.couldNotReadResource(resourceUri, e);
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private String[] splitBySlash(String value) {
        return value.split("/");
    }

    protected boolean isEnabled(String key, boolean defaultValue) {
        Object value = this.properties.get(key);
        if (value != null) {
            return Boolean.TRUE.equals(value);
        }
        String system = AccessController.doPrivileged(new GetSystemPropertyAction(key));
        if (system != null) {
            return Boolean.valueOf(system);
        }
        return defaultValue;
    }

    protected Object getPropertyValue(String key, Object defaultValue) {
        Object value = this.properties.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private void parseAdditionalBeanDefiningAnnotations() {
        String stringValue;
        if (this.properties.containsKey(ADDITIONAL_BEAN_DEFINING_ANNOTATIONS_PROPERTY)) {
            Object valueObj = this.properties.get(ADDITIONAL_BEAN_DEFINING_ANNOTATIONS_PROPERTY);
            if (valueObj instanceof Collection) {
                for (Object element : (Collection)valueObj) {
                    if (element instanceof Class && Annotation.class.isAssignableFrom((Class)element)) {
                        this.extendedBeanDefiningAnnotations.add((Class)element);
                        continue;
                    }
                    WeldSELogger.LOG.unexpectedItemsInValueCollection(element.getClass());
                }
            } else {
                throw WeldSELogger.LOG.unexpectedValueForAdditionalBeanDefiningAnnotations(valueObj.getClass());
            }
        }
        if ((stringValue = AccessController.doPrivileged(new GetSystemPropertyAction(ADDITIONAL_BEAN_DEFINING_ANNOTATIONS_PROPERTY))) != null) {
            for (String className : stringValue.split(",")) {
                if (className.isEmpty()) continue;
                try {
                    Class<?> loadedClass = Class.forName(className);
                    if (loadedClass.isAnnotation()) {
                        this.extendedBeanDefiningAnnotations.add(loadedClass);
                        continue;
                    }
                    WeldSELogger.LOG.unexpectedItemsInValueCollection(loadedClass);
                }
                catch (ClassNotFoundException | LinkageError e) {
                    throw WeldSELogger.LOG.failedToLoadClass(className, e.toString());
                }
            }
        }
    }

    static {
        if (!(SingletonProvider.instance() instanceof RegistrySingletonProvider)) {
            SingletonProvider.reset();
            SingletonProvider.initialize(new RegistrySingletonProvider());
        }
    }

    private static class PackInfo {
        private final String packName;
        private final String packClassName;
        private final boolean scanRecursively;
        private final WeakReference<ClassLoader> classLoaderRef;

        PackInfo(Class<?> packClass, boolean recursiveScan) {
            this.packName = packClass.getPackage().getName();
            this.packClassName = packClass.getName();
            this.scanRecursively = recursiveScan;
            this.classLoaderRef = new WeakReference<ClassLoader>(AccessController.doPrivileged(new GetClassLoaderAction(packClass)));
        }

        PackInfo(Package pack, boolean recursiveScan) {
            this.packName = pack.getName();
            this.scanRecursively = recursiveScan;
            this.packClassName = null;
            this.classLoaderRef = null;
        }

        public URL getResourceUrl(ResourceLoader resourceLoader) {
            if (this.classLoaderRef != null) {
                return ((ClassLoader)this.classLoaderRef.get()).getResource(this.getPackClassName().replace('.', '/') + ".class");
            }
            return resourceLoader.getResource(this.getPackName().replace('.', '/'));
        }

        public String getPackName() {
            return this.packName;
        }

        public String getPackClassName() {
            return this.packClassName;
        }

        public boolean isScanRecursively() {
            return this.scanRecursively;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.packClassName == null ? 0 : this.packClassName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PackInfo other = (PackInfo)obj;
            return !(this.packName == null ? other.packName != null : !this.packName.equals(other.packName));
        }
    }
}

