/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.services.ParallelTaskResult;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JSEResultAdapter
implements ParallelTaskResult {
    private static final String sourceClass = JSEResultAdapter.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private Future result;

    public JSEResultAdapter(Future result) {
        this.result = result;
    }

    @Override
    public void waitForResult() {
        try {
            this.result.get();
        }
        catch (InterruptedException e) {
            throw new BatchContainerServiceException("Parallel thread was interrupted while waiting for result.", e);
        }
        catch (ExecutionException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(sourceClass + ": caught exception/error: " + e.getMessage() + " : Stack trace: " + e.getCause().toString());
            }
        }
        catch (CancellationException e) {
            throw new BatchContainerServiceException("Parallel thread was canceled before completion.", e);
        }
    }
}

