/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.timer;

import com.sun.messaging.jmq.resources.SharedResources;
import com.sun.messaging.jmq.util.LoggerWrapper;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class MQTimer
extends Timer {
    private static boolean DEBUG = false;
    private static SharedResources myrb = SharedResources.getResources();
    private static LoggerWrapper logger = null;

    public static void setLogger(LoggerWrapper l) {
        logger = l;
    }

    public MQTimer() {
        this(false);
    }

    public MQTimer(boolean isDaemon) {
        super("MQTimer-Thread", isDaemon);
    }

    public void initUncaughtExceptionHandler() {
        block2: {
            TimerTask uehtask = new TimerTask(){

                @Override
                public void run() {
                    block2: {
                        Thread thr = Thread.currentThread();
                        Thread.UncaughtExceptionHandler ueh = thr.getUncaughtExceptionHandler();
                        try {
                            thr.setUncaughtExceptionHandler(new MQTimerUncaughtExceptionHandler(ueh));
                        }
                        catch (Exception e) {
                            if (logger == null) break block2;
                            logger.logWarn(myrb.getKString("S2005", this.getClass().getName()), null);
                        }
                    }
                    this.cancel();
                }
            };
            try {
                this.schedule(uehtask, new Date());
            }
            catch (Exception ex) {
                if (logger == null) break block2;
                logger.logWarn(myrb.getKString("S2006", ex.getMessage()), null);
            }
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        if (logger != null && DEBUG) {
            RuntimeException ex = new RuntimeException("MQTimer: cancel");
            ex.fillInStackTrace();
            logger.logInfo("Internal Error: timer canceled ", ex);
        }
    }

    static class MQTimerUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        Thread.UncaughtExceptionHandler parent = null;

        MQTimerUncaughtExceptionHandler(Thread.UncaughtExceptionHandler parent) {
            this.parent = parent;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (logger != null) {
                logger.logSevere(myrb.getKString("S3019", e.getMessage(), t.getName()), e);
            }
            this.parent.uncaughtException(t, e);
        }
    }
}

