/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.BigPacketException;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.memory.MemoryCallback;
import com.sun.messaging.jmq.jmsserver.net.ProtocolStreams;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.MetricManager;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.ConvertPacket;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.NotificationInfo;
import com.sun.messaging.jmq.jmsserver.service.imq.Operation;
import com.sun.messaging.jmq.jmsserver.service.imq.OperationRunnable;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.BrokerShutdownRuntimeException;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.NFLPriorityFifoSet;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.net.IPAddress;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TimerTask;
import java.util.Vector;

public class IMQIPConnection
extends IMQBasicConnection
implements Operation,
MemoryCallback {
    public static final boolean expectPingReply = false;
    public static final int closeInterval = Globals.getConfig().getIntProperty("imq.ping.close.interval", 5);
    public static final boolean enablePingReply = Globals.getConfig().getBooleanProperty("imq.ping.reply.enable", true);
    protected int ctrlPktsToConsumer = 0;
    boolean STREAMS = true;
    boolean BLOCKING = false;
    protected Set tmpDestinations = Collections.synchronizedSet(new HashSet());
    protected Object timerLock = new Object();
    public int packetVersion = 0;
    ConvertPacket convertPkt = null;
    public static final int DEFAULT_INTERVAL = 180;
    private static boolean OVERRIDE_CTRL_PACKET = false;
    private static boolean OVERRIDE_READ_PACKET = false;
    private static boolean OVERRIDE_FILL_PACKET = false;
    private static boolean O_CTRL_USE_DIRECT = false;
    private static boolean O_READ_USE_DIRECT = false;
    private static boolean O_FILL_USE_DIRECT = false;
    byte[] empty = new byte[]{0};
    Object ctrlEL = null;
    private StateWatcher stateWatcher = null;
    private long interval = 180L;
    protected ProtocolStreams ps = null;
    protected SocketChannel channel;
    protected InputStream is = null;
    protected OutputStream os = null;
    protected boolean critical = false;
    private boolean flush = false;
    private boolean flushCtrl = false;
    private Object flushLock = new Object();
    private Object flushCtrlLock = new Object();
    private boolean flushCritical = false;
    private boolean lockCritical = false;
    private OperationRunnable read_assigned = null;
    private OperationRunnable write_assigned = null;
    NotificationInfo ninfo = null;
    Object releaseWaitLock = new Object();
    String localsvcstring = null;
    int destroyRecurse = 0;
    private NFLPriorityFifoSet control = null;
    boolean hasCtrl = true;
    protected Packet readpkt = null;
    private boolean inReadProcess = false;
    private int lastPacketType = 0;
    private int lastPacketSize = 0;
    private Packet ctrlpkt = null;
    private Packet waitingWritePkt = null;
    private boolean inCtrlWrite = false;
    private boolean inJMSWrite = false;
    boolean inWriteProcess = false;

    public IMQIPConnection(Service svc, ProtocolStreams ps, PacketRouter router) throws IOException, BrokerException {
        super(svc, router);
        this.ps = ps;
        InetAddress ia = this.getRemoteAddress();
        if (ia != null) {
            this.setRemoteIP(ia.getAddress());
        }
        if (ps != null) {
            this.STREAMS = ps.getChannel() == null;
            this.BLOCKING = ps.getBlocking();
            this.channel = (SocketChannel)ps.getChannel();
            this.is = ps.getInputStream();
            this.os = ps.getOutputStream();
        }
        this.accessController = AccessController.getInstance(svc.getName(), svc.getServiceType());
        if (ia != null) {
            this.accessController.setClientIP(ia.getHostAddress());
        }
        this.control = new NFLPriorityFifoSet();
        this.ctrlEL = this.control.addEventListener((EventListener)this, EventType.EMPTY, null);
        this.setConnectionState(0);
        this.waitingWritePkt = new Packet(OVERRIDE_FILL_PACKET ? O_FILL_USE_DIRECT : !this.STREAMS);
        if (!this.isAdminConnection() && Globals.getMemManager() != null) {
            Globals.getMemManager().registerMemoryCallback(this);
        }
    }

    protected InetAddress getRemoteAddress() {
        if (this.ps != null) {
            return this.ps.getRemoteAddress();
        }
        return null;
    }

    @Override
    public void dumpState() {
        super.dumpState();
        this.logger.log(8, "\tcontrol = " + this.control.size());
        this.logger.log(8, "\tread_assigned = " + this.read_assigned);
        this.logger.log(8, "\twrite_assigned = " + this.write_assigned);
        if (this.ninfo != null) {
            this.ninfo.dumpState();
        }
    }

    @Override
    public int getLocalPort() {
        if (this.ps == null) {
            return 0;
        }
        return this.ps.getLocalPort();
    }

    @Override
    public synchronized Hashtable getDebugState() {
        Hashtable ht = super.getDebugState();
        ht.put("pkts[TOTAL](in,out) ", "(" + this.msgsIn + "," + (this.ctrlPktsToConsumer + this.msgsToConsumer) + ")");
        for (int i = 0; i < this.pktsIn.length; ++i) {
            if (this.pktsIn[i] == 0 && this.pktsOut[i] == 0) continue;
            ht.put("pkts[" + PacketType.getString((int)i) + "] (in,out)", "(" + this.pktsIn[i] + "," + this.pktsOut[i] + ")");
        }
        ht.put("ctrlPktsToConsumer", String.valueOf(this.ctrlPktsToConsumer));
        ht.put("critical", String.valueOf(this.critical));
        ht.put("controlSize", String.valueOf(this.control.size()));
        if (this.control.size() > 0) {
            Vector<String> v = new Vector<String>();
            for (Packet p : this.control) {
                v.add(p.toString());
            }
            ht.put("control", v);
        }
        if (this.ps != null) {
            ht.put("transport", this.ps.getDebugState());
        }
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getDebugMessages(boolean full) {
        Vector<String> ht = new Vector<String>();
        NFLPriorityFifoSet nFLPriorityFifoSet = this.control;
        synchronized (nFLPriorityFifoSet) {
            for (PacketReference pr : this.control) {
                ht.add(full ? pr.getPacket().dumpPacketString() : pr.getPacket().toString());
            }
        }
        return ht;
    }

    @Override
    public ConnectionInfo getConnectionInfo() {
        this.coninfo = super.getConnectionInfo();
        this.coninfo.remPort = this.getRemotePort();
        return this.coninfo;
    }

    @Override
    public boolean useDirectBuffers() {
        return OVERRIDE_CTRL_PACKET ? O_CTRL_USE_DIRECT : !this.STREAMS;
    }

    public synchronized AbstractSelectableChannel getChannel() {
        if (this.ps == null) {
            return null;
        }
        return this.ps.getChannel();
    }

    @Override
    public boolean canKill() {
        return !this.critical;
    }

    @Override
    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    @Override
    public boolean waitUntilDestroyed(long time) {
        long targettime = System.currentTimeMillis() + time;
        while (this.isValid() && System.currentTimeMillis() < targettime) {
            this.waitForWork(time);
        }
        return this.isValid();
    }

    @Override
    public synchronized void notifyRelease(OperationRunnable runner, int events) {
        int release_events = 0;
        if ((events & 4) != 0 && runner == this.write_assigned) {
            release_events |= 4;
            this.write_assigned = null;
        }
        if ((events & 1) != 0 && runner == this.read_assigned) {
            release_events |= 1;
            this.read_assigned = null;
        }
        if (this.ninfo != null && release_events != 0) {
            this.ninfo.released(this, release_events);
        }
        this.notifyAll();
    }

    @Override
    public synchronized void waitForRelease(long timeout) {
        long waitt = 5000L;
        while (this.read_assigned != null || this.write_assigned != null) {
            if (timeout <= 0L) {
                Globals.getLogger().log(16, "Timeout in waiting for runnable threads release in " + this);
                return;
            }
            Globals.getLogger().log(8, "Waiting for runnable threads release in " + this);
            if (timeout < waitt) {
                waitt = timeout;
            }
            try {
                this.wait(waitt);
            }
            catch (InterruptedException e) {
                Globals.getLogger().log(16, "Interrupted in waiting for runnable threads release in " + this);
                return;
            }
            timeout -= waitt;
        }
    }

    public synchronized void clearAssigned() {
        this.read_assigned = null;
        this.write_assigned = null;
    }

    public synchronized OperationRunnable getReadRunnable() {
        return this.read_assigned;
    }

    public synchronized OperationRunnable getWriteRunnable() {
        return this.write_assigned;
    }

    @Override
    public synchronized void threadAssigned(OperationRunnable runner, int events) throws IllegalAccessException {
        int release_events = 0;
        if ((events & 4) != 0) {
            if (this.write_assigned != null) {
                release_events |= 4;
            }
            this.write_assigned = runner;
        }
        if ((events & 1) != 0) {
            if (this.read_assigned != null) {
                release_events |= 1;
            }
            this.read_assigned = runner;
        }
        if (this.ninfo != null) {
            if (release_events != 0) {
                this.ninfo.released(this, release_events);
            }
            this.ninfo.assigned(this, events);
        }
    }

    @Override
    public void attach(NotificationInfo obj) {
        this.ninfo = obj;
    }

    @Override
    public NotificationInfo attachment() {
        return this.ninfo;
    }

    @Override
    public boolean process(int events, boolean wait) throws IOException {
        boolean didSomething = false;
        boolean processedLastIteration = true;
        try {
            while (processedLastIteration) {
                processedLastIteration = false;
                if ((events & 4) != 0) {
                    while (this.writeData(wait) == 0) {
                        processedLastIteration = true;
                    }
                }
                if ((events & 1) != 0) {
                    int returnval = this.readData();
                    switch (returnval) {
                        case 0: {
                            processedLastIteration = true;
                        }
                    }
                }
                didSomething |= processedLastIteration;
            }
        }
        catch (Throwable t) {
            this.handleWriteException(t);
        }
        return !didSomething;
    }

    @Override
    public String getRemoteConnectionString() {
        String userString;
        boolean userset;
        block6: {
            if (this.remoteConString != null) {
                return this.remoteConString;
            }
            userset = false;
            userString = "???";
            if (this.state >= 4) {
                try {
                    Principal principal = this.getAuthenticatedName();
                    if (principal != null) {
                        userString = principal.getName();
                        userset = true;
                    }
                }
                catch (BrokerException e) {
                    if (!IMQBasicConnection.DEBUG) break block6;
                    this.logger.log(4, "Exception getting authentication name " + this.conId, (Throwable)e);
                }
            }
        }
        String remotePortString = Integer.toString(this.getRemotePort());
        String retstr = userString + "@" + IPAddress.rawIPToString((byte[])this.getRemoteIP(), (boolean)true, (boolean)true) + ":" + remotePortString;
        if (userset) {
            this.remoteConString = retstr;
        }
        return retstr;
    }

    protected int getRemotePort() {
        return this.ps == null ? 0 : this.ps.getRemotePort();
    }

    @Override
    protected String localServiceString() {
        if (this.localsvcstring != null) {
            return this.localsvcstring;
        }
        String localPortString = Integer.toString(this.getLocalPort());
        this.localsvcstring = this.service.getName() + ":" + localPortString;
        return this.localsvcstring;
    }

    @Override
    public synchronized void closeConnection(boolean force, int reason, String reasonStr) {
        if (this.state >= 6) {
            this.logger.log(4, "Requested close of already closed connection:" + this);
            return;
        }
        this.stopConnection();
        if (Globals.getMemManager() != null) {
            Globals.getMemManager().removeMemoryCallback(this);
        }
        if (force) {
            this.sayGoodbye(false, reason, reasonStr);
            this.flushControl(1000L);
        }
        this.state = 6;
        this.notifyConnectionClosed();
        this.control.removeEventListener(this.ctrlEL);
        this.cleanup(reason == 1);
        if (this.ninfo != null) {
            this.ninfo.destroy(reasonStr);
        }
        try {
            this.closeProtocolStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (reason == 1) {
            this.cleanupConnection();
        } else {
            this.cleanup(false);
        }
    }

    protected void closeProtocolStream() throws IOException {
        if (this.ps != null) {
            this.ps.close();
        }
        this.ps = null;
    }

    @Override
    protected void cleanupControlPackets(boolean shutdown) {
        while (!this.control.isEmpty()) {
            Packet p = (Packet)this.control.removeNext();
            if (p == null) continue;
            p.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyConnection(boolean force, int reason, String reasonstr) {
        int oldstate = 0;
        boolean destroyOK = false;
        try {
            MetricManager mm;
            IMQIPConnection iMQIPConnection = this;
            synchronized (iMQIPConnection) {
                block21: {
                    oldstate = this.state;
                    if (this.state < 7) break block21;
                    return;
                }
                if (this.state < 6) {
                    this.closeConnection(force, reason, reasonstr);
                }
                this.setConnectionState(7);
            }
            Globals.getConnectionManager().removeConnection(this.getConnectionUID(), force, reason, reasonstr);
            if (this.accessController.isAuthenticated()) {
                this.accessController.logout();
            }
            if ((mm = Globals.getMetricManager()) != null) {
                mm.depositTotals(this.service.getName(), this.counters);
            }
            this.counters.reset();
            Object object = this.timerLock;
            synchronized (object) {
                if (this.stateWatcher != null) {
                    try {
                        this.stateWatcher.cancel();
                    }
                    catch (IllegalStateException ex) {
                        this.logger.log(4, "Error destroying  connection " + this + " to state " + this.state, (Throwable)ex);
                    }
                    this.stateWatcher = null;
                }
            }
            if (this.getDestroyReason() != null) {
                this.logConnectionInfo(true, this.getDestroyReason());
            } else {
                this.logConnectionInfo(true, reasonstr);
            }
            this.setConnectionState(8);
            destroyOK = true;
            this.wakeup();
        }
        finally {
            if (!(destroyOK || reason == 1 || Globals.getMemManager() != null && Globals.getMemManager().getCurrentLevel() <= 0)) {
                this.state = oldstate;
                if (this.destroyRecurse < 2) {
                    ++this.destroyRecurse;
                    this.destroyConnection(force, reason, reasonstr);
                }
            }
            Globals.getClusterBroadcast().connectionClosed(this.getConnectionUID(), this.isAdminConnection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setConnectionState(int state) {
        Object object = this.timerLock;
        synchronized (object) {
            this.state = state;
            if (this.state >= 6) {
                if (this.stateWatcher != null) {
                    try {
                        this.stateWatcher.cancel();
                    }
                    catch (IllegalStateException ex) {
                        this.logger.log(4, "Error setting state on  connection " + this + " to state " + state, (Throwable)ex);
                    }
                    this.stateWatcher = null;
                }
                this.wakeup();
                return false;
            }
            if (state == 0) {
                this.interval = Globals.getConfig().getLongProperty("imq.authentication.client.response.timeout", 180L);
                MQTimer timer = Globals.getTimer(true);
                this.stateWatcher = new StateWatcher(1, this);
                try {
                    timer.schedule((TimerTask)this.stateWatcher, this.interval * 1000L);
                }
                catch (IllegalStateException ex) {
                    this.logger.log(4, "InternalError: timer canceled ", (Throwable)ex);
                }
            } else if (state == 1 || state == 2 || state == 3) {
                if (this.stateWatcher != null) {
                    try {
                        this.stateWatcher.cancel();
                    }
                    catch (IllegalStateException ex) {
                        this.logger.log(4, "Error setting state on  connection " + this + " to state " + state, (Throwable)ex);
                    }
                    this.stateWatcher = null;
                }
                if (state == 1) {
                    return true;
                }
                if (state == 3) {
                    return true;
                }
                MQTimer timer = Globals.getTimer(true);
                this.stateWatcher = new StateWatcher(3, this);
                try {
                    timer.schedule((TimerTask)this.stateWatcher, this.interval * 1000L);
                }
                catch (IllegalStateException ex) {
                    this.logger.log(4, "InternalError: timer canceled ", (Throwable)ex);
                }
            } else if (state >= 4 || state == -1) {
                if (this.stateWatcher != null) {
                    try {
                        this.stateWatcher.cancel();
                    }
                    catch (IllegalStateException ex) {
                        this.logger.log(4, "Error setting state on  connection " + this + " to state " + state, (Throwable)ex);
                    }
                    this.stateWatcher = null;
                }
                if (state == 4) {
                    this.logConnectionInfo(false);
                }
            }
        }
        return true;
    }

    @Override
    public void logConnectionInfo(boolean closing) {
        this.logConnectionInfo(closing, "Unknown");
    }

    public void logConnectionInfo(boolean closing, String reason) {
        Object[] args = new String[]{this.getRemoteConnectionString(), this.localServiceString(), Integer.toString(Globals.getConnectionManager().size()), reason, String.valueOf(this.control.size()), Integer.toString(this.service.size())};
        if (!closing) {
            this.logger.log(8, "B1065", args);
        } else {
            this.logger.log(8, "B1066", args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendControlMessage(Packet msg) {
        if (!this.isValid() && msg.getPacketType() != 28) {
            this.logger.log(8, "Internal Warning: message " + msg + "queued on destroyed connection " + this);
        }
        this.control.add((Object)msg);
        NFLPriorityFifoSet nFLPriorityFifoSet = this.control;
        synchronized (nFLPriorityFifoSet) {
            this.hasCtrl = !this.control.isEmpty();
        }
    }

    protected void sendControlMessage(Packet msg, boolean priority) {
        if (IMQBasicConnection.DEBUG) {
            this.logger.log(1, "IMQIPConnection[ {0} ] queueing Admin packet {1}", (Object)this.toString(), (Object)msg.toString());
        }
        if (!this.isValid()) {
            return;
        }
        assert (!priority);
        this.sendControlMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushControl(long timeout) {
        if (this.read_assigned == this.write_assigned && this.read_assigned != null) {
            this.localFlushCtrl();
            return;
        }
        Object object = this.flushCtrlLock;
        synchronized (object) {
            if (IMQBasicConnection.DEBUG) {
                this.logger.log(4, "Flushing Control Messages with timeout of " + timeout);
            }
            if (this.ctrlpkt == null && this.control.isEmpty() && !this.flushCritical) {
                return;
            }
            if (!this.isValid()) {
                return;
            }
            long time = System.currentTimeMillis();
            this.flushCtrl = true;
            if (timeout < 0L) {
                return;
            }
            while (this.flushCtrl && this.isValid()) {
                try {
                    if (timeout != 0L) {
                        this.flushCtrlLock.wait(timeout);
                    } else {
                        this.flushCtrlLock.wait(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.flushCtrl || timeout <= 0L || System.currentTimeMillis() < time + timeout) continue;
            }
            this.flushCtrl = false;
            if (IMQBasicConnection.DEBUG) {
                if (this.flush) {
                    this.logger.log(4, "Control Flush did not complete in timeout of " + timeout);
                } else {
                    this.logger.log(4, "Contrl Flush completed");
                }
            }
        }
    }

    protected void localFlushCtrl() {
        this.flushCtrl = true;
        this.writeDataUntilComplete();
        this.flushCtrl = false;
    }

    protected void localFlush() {
        this.flush = true;
        this.writeDataUntilComplete();
        this.flush = false;
    }

    private void writeDataUntilComplete() {
        try {
            while (this.writeData(false) != 1) {
            }
        }
        catch (Exception ex) {
            this.logger.log(4, "error in flush " + this, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(long timeout) {
        if (this.read_assigned == this.write_assigned && this.read_assigned != null) {
            this.localFlush();
            return;
        }
        if (!this.inCtrlWrite && this.control.isEmpty() && !this.inJMSWrite && this.hasBusySessions() && !this.flushCritical && !this.lockCritical) {
            return;
        }
        Object object = this.flushLock;
        synchronized (object) {
            if (IMQBasicConnection.DEBUG) {
                this.logger.log(4, "Flushing Messages with timeout of " + timeout);
            }
            if (!this.isValid()) {
                return;
            }
            if (!this.inCtrlWrite && this.control.isEmpty() && !this.inJMSWrite && this.hasBusySessions() && !this.flushCritical && !this.lockCritical) {
                return;
            }
            long time = System.currentTimeMillis();
            this.flush = true;
            while (this.flush && this.isValid()) {
                try {
                    if (timeout != 0L) {
                        this.flushLock.wait(timeout);
                    } else {
                        this.flushLock.wait(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.flush || timeout <= 0L || System.currentTimeMillis() < time + timeout) continue;
            }
            if (IMQBasicConnection.DEBUG) {
                if (this.flush) {
                    this.logger.log(4, "Flush did not complete in timeout of " + timeout);
                } else {
                    this.logger.log(4, "Flush completed");
                }
            }
        }
    }

    void dumpConnectionInfo() {
        if (this.ninfo != null) {
            this.logger.log(8, "Connection Information [" + this + "]" + this.ninfo.getStateInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkConnection(int state) {
        Object object = this.timerLock;
        synchronized (object) {
            try {
                this.stateWatcher.cancel();
            }
            catch (IllegalStateException ex) {
                this.logger.log(4, "Error destroying  connection " + this + " to state " + state, (Throwable)ex);
            }
            this.stateWatcher = null;
        }
        Object[] args = new String[]{this.toString(), IMQIPConnection.getConnectionStateString(this.state), IMQIPConnection.getConnectionStateString(state), String.valueOf(this.interval)};
        IMQIPConnection iMQIPConnection = this;
        synchronized (iMQIPConnection) {
            if (this.state >= state) {
                return;
            }
            if (this.state >= 6 || this.state == -1) {
                return;
            }
            this.logger.log(16, Globals.getBrokerResources().getKString("B2051", args));
        }
        if (IMQBasicConnection.DEBUG) {
            this.dumpConnectionInfo();
        }
        this.destroyConnection(false, 4, Globals.getBrokerResources().getKString("B2051", args));
    }

    protected boolean readInPacket(Packet p) throws StreamCorruptedException, BigPacketException, IOException {
        boolean OK = true;
        if (this.STREAMS) {
            assert (this.is != null);
            this.readpkt.readPacket(this.is);
        } else {
            assert (this.channel != null);
            OK = this.readpkt.readPacket((ScatteringByteChannel)this.channel, this.BLOCKING);
        }
        return OK;
    }

    protected Packet clearReadPacket(Packet p) {
        return null;
    }

    /*
     * Exception decompiling
     */
    public int readData() throws IOException, BrokerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean writeOutPacket(Packet p) throws IOException {
        boolean donewriting = true;
        if (this.STREAMS) {
            p.writePacket(this.os);
        } else {
            donewriting = p.writePacket((GatheringByteChannel)this.channel, this.BLOCKING);
        }
        return donewriting;
    }

    protected Packet clearWritePacket(Packet p) {
        if (p != null) {
            p.destroy();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeData(boolean wait) throws IOException {
        Object object;
        assert (!this.inWriteProcess);
        if (this.hasCtrl) {
            object = this.control;
            synchronized (object) {
                this.hasCtrl = !this.control.isEmpty();
            }
        }
        try {
            this.inWriteProcess = true;
            if (IMQBasicConnection.DEBUG) {
                this.logger.log(4, "Writing IMQIPConnection {0} ", (Object)this.toString());
            }
            while (wait && !this.isBusy() && this.isValid()) {
                this.waitForWork(0L);
            }
            if (!this.isValid()) {
                throw new IOException(Globals.getBrokerResources().getKString("B4117", "destroyed Connection"));
            }
            if (!this.isBusy()) {
                int n = 1;
                return n;
            }
            this.flushCritical = true;
            if (!this.inCtrlWrite && !this.inJMSWrite) {
                if (!this.control.isEmpty()) {
                    this.ctrlpkt = (Packet)this.control.removeNext();
                    if (this.ctrlpkt != null) {
                        this.inCtrlWrite = true;
                    }
                } else {
                    object = this.control;
                    synchronized (object) {
                        this.hasCtrl = !this.control.isEmpty();
                    }
                }
            }
            if (this.ctrlpkt != null) {
                if (this.ctrlpkt.getPacketType() > 6) {
                    this.ctrlpkt.setIP(ipAddress);
                    this.ctrlpkt.setPort(this.getLocalPort());
                }
                if (this.convertPkt != null) {
                    this.convertPkt.handleWritePacket(this.ctrlpkt);
                }
                if (IMQBasicConnection.DEBUG || DUMP_PACKET || OUT_DUMP_PACKET) {
                    this.dumpControlPacket(this.ctrlpkt);
                }
                boolean bl = this.inCtrlWrite = !this.writeOutPacket(this.ctrlpkt);
                if (!this.inCtrlWrite) {
                    if (this.ctrlpkt.getPacketType() < 80) {
                        int n = this.ctrlpkt.getPacketType();
                        this.pktsOut[n] = this.pktsOut[n] + 1;
                    }
                    ++this.ctrlPktsToConsumer;
                    if (IMQBasicConnection.DEBUG || DUMP_PACKET || OUT_DUMP_PACKET) {
                        this.logger.log(8, "Finished writing packet [" + this.ctrlpkt + "]");
                    }
                    if (Globals.getConnectionManager().PING_ENABLED) {
                        this.updateAccessTime(false);
                    }
                    if (this.METRICS_ON) {
                        this.countOutPacket(this.ctrlpkt);
                    }
                    assert (this.ctrlpkt != null);
                    this.ctrlpkt = this.clearWritePacket(this.ctrlpkt);
                }
                this.flushCritical = false;
                object = this.stateLock;
                synchronized (object) {
                    this.checkState();
                }
                if (this.inCtrlWrite) {
                    int n = 2;
                    return n;
                }
                if (this.isBusy()) {
                    int n = 0;
                    return n;
                }
                int n = 1;
                return n;
            }
            this.flushCritical = false;
            if (IMQBasicConnection.DEBUG) {
                this.logger.log(1, "IMQIPConnection[ {0} ] - processing  normal msg queue", (Object)this.toString());
            }
            if (!this.inJMSWrite && !this.hasCtrl) {
                boolean aboutToWaitForRF;
                this.lockCritical = true;
                boolean validJMSPkt = false;
                assert (this.waitingWritePkt != null);
                if (this.hasCtrl || !this.runningMsgs || this.paused || this.waitingForResumeFlow || !(validJMSPkt = this.fillNextPacket(this.waitingWritePkt))) {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.checkState();
                    }
                    if (this.isBusy()) {
                        int n = 0;
                        return n;
                    }
                    int n = 1;
                    return n;
                }
                if (!validJMSPkt) {
                    int n = 0;
                    return n;
                }
                this.inJMSWrite = true;
                if (this.convertPkt != null) {
                    this.convertPkt.handleWritePacket(this.waitingWritePkt);
                }
                ++this.sent_count;
                boolean bl = aboutToWaitForRF = this.flowCount != 0 && this.sent_count >= this.flowCount;
                if (aboutToWaitForRF) {
                    this.sent_count = 0;
                    this.waitingWritePkt.setFlowPaused(aboutToWaitForRF);
                    this.haltFlow();
                }
                if (IMQBasicConnection.DEBUG || DUMP_PACKET || OUT_DUMP_PACKET) {
                    int flag = DUMP_PACKET || OUT_DUMP_PACKET ? 8 : 1;
                    this.logger.log(flag, "\n------------------------------\nSending JMS Packet -[block = " + this.BLOCKING + ",nio = " + !this.STREAMS + "] " + this + "  Dumping\n" + this.waitingWritePkt.dumpPacketString("<<<<****") + "\n------------------------------");
                }
            }
            if (this.inJMSWrite) {
                this.inJMSWrite = !this.writeOutPacket(this.waitingWritePkt);
            }
            this.lockCritical = false;
            if (this.inJMSWrite) {
                int validJMSPkt = 2;
                return validJMSPkt;
            }
            ++this.msgsToConsumer;
            if (this.waitingWritePkt.getPacketType() < 80) {
                int n = this.waitingWritePkt.getPacketType();
                this.pktsOut[n] = this.pktsOut[n] + 1;
            }
            if (Globals.getConnectionManager().PING_ENABLED) {
                this.updateAccessTime(false);
            }
            if (this.METRICS_ON) {
                this.countOutPacket(this.waitingWritePkt);
            }
            if (this.isBusy()) {
                int validJMSPkt = 0;
                return validJMSPkt;
            }
            int validJMSPkt = 1;
            return validJMSPkt;
        }
        catch (OutOfMemoryError err) {
            Globals.handleGlobalError(err, Globals.getBrokerResources().getKString("B0013"));
        }
        catch (IOException ex) {
            this.logger.log(2, "closed connection " + this, (Throwable)ex);
            this.inJMSWrite = false;
            this.destroyConnection(false, 5, Globals.getBrokerResources().getKString("B0061"));
            throw ex;
        }
        finally {
            this.inWriteProcess = false;
            Object err = this.flushCtrlLock;
            synchronized (err) {
                if (this.flushCtrl && (this.ctrlpkt == null && this.control.isEmpty() || !this.isValid())) {
                    if (IMQBasicConnection.DEBUG) {
                        this.logger.log(4, "Done flushing control messages on " + this);
                    }
                    this.flushCtrl = false;
                    this.flushCtrlLock.notifyAll();
                    if (this.os != null) {
                        this.os.flush();
                    }
                }
            }
            if (this.flush) {
                err = this.flushLock;
                synchronized (err) {
                    if (!this.isBusy() || !this.isValid()) {
                        if (IMQBasicConnection.DEBUG) {
                            this.logger.log(4, "Done flushing control messages on " + this);
                        }
                        this.flush = false;
                        this.flushLock.notifyAll();
                        this.os.flush();
                    }
                }
            }
            if (!this.isValid()) {
                err = this;
                synchronized (err) {
                    this.waitingWritePkt = this.clearWritePacket(this.waitingWritePkt);
                }
            }
        }
        assert (false) : " should never happen";
        if (this.isBusy()) {
            return 0;
        }
        return 1;
    }

    protected void dumpControlPacket(Packet pkt) {
        int loglevel = DUMP_PACKET || OUT_DUMP_PACKET ? 8 : 1;
        this.logger.log(loglevel, "\n------------------------------\nSending Control Packet -[block = " + this.BLOCKING + ",nio = " + !this.STREAMS + "]   Dumping\n------------------------------\n" + pkt.dumpPacketString("<<<<****") + "\n------------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkState() {
        assert (Thread.holdsLock(this.stateLock));
        NFLPriorityFifoSet nFLPriorityFifoSet = this.control;
        synchronized (nFLPriorityFifoSet) {
            Set set = this.busySessions;
            synchronized (set) {
                boolean is_running;
                boolean bl = is_running = this.isValid() && (this.inCtrlWrite || !this.paused && !this.control.isEmpty() || this.inJMSWrite || this.runningMsgs && !this.waitingForResumeFlow && !this.busySessions.isEmpty());
                if (!this.isValid() || this.busy != is_running) {
                    this.busy = is_running;
                    this.stateLock.notifyAll();
                    if (this.ninfo != null) {
                        this.ninfo.setReadyToWrite(this, this.busy);
                    } else if (this.service instanceof NotificationInfo) {
                        ((NotificationInfo)((Object)this.service)).setReadyToWrite(this, this.busy);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForWork(long time) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isValid() && !this.busy) {
                try {
                    if (time == 0L) {
                        this.stateLock.wait();
                    } else {
                        this.stateLock.wait(time);
                    }
                }
                catch (InterruptedException ex) {
                    assert (false);
                    this.logger.logStack(8, "Internal error, got interrupted exception", (Throwable)ex);
                }
            }
            return this.busy;
        }
    }

    protected void handleWriteException(Throwable ex) throws IOException, OutOfMemoryError {
        block7: {
            if (ex instanceof OutOfMemoryError) {
                this.logger.log(32, "B3143", (Object)this, ex);
                int count = 0;
                boolean firstpass = true;
                while (true) {
                    try {
                        this.logger.log(32, Globals.getBrokerResources().getKString("B3274", this.toString()));
                        this.closeConnection(firstpass, 4, ex.toString());
                        firstpass = false;
                        break block7;
                    }
                    catch (OutOfMemoryError err1) {
                        this.logger.log(4, "Connection could not be cleanly closed, trying again on " + this, ex);
                        if (++count < 2) continue;
                        throw err1;
                    }
                    break;
                }
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof BrokerShutdownRuntimeException) {
                this.logger.log(8, ex.getMessage());
                this.closeConnection(true, 1, ex.toString());
            } else {
                this.logger.logStack(32, "Internal Error: Received unexpected exception processing connection  closing connection", ex);
                this.closeConnection(true, 4, ex.toString());
            }
        }
    }

    protected void handleBigPacketException(Packet pkt, BigPacketException e) {
        Object[] objectArray = new String[3];
        objectArray[0] = String.valueOf(pkt.getPacketSize());
        objectArray[1] = pkt.toString();
        objectArray[2] = String.valueOf(pkt.getMaxPacketSize());
        Object[] params = objectArray;
        this.logger.log(32, "B4188", params, (Throwable)e);
        this.sendReply(pkt, 423);
    }

    protected void handleIllegalArgumentExceptionPacket(Packet pkt, IllegalArgumentException e) {
        this.logger.log(32, "Bad version packet received: " + e.getMessage() + ", reject connection [" + this + "]");
        Packet reply = new Packet(this.useDirectBuffers());
        reply.setIP(ipAddress);
        reply.setPort(this.getLocalPort());
        reply.setPacketType(11);
        Hashtable<String, Integer> hash = new Hashtable<String, Integer>();
        hash.put("JMQStatus", 505);
        reply.setProperties(hash);
        this.sendControlMessage(reply);
        this.flushControl(1000L);
        this.destroyConnection(true, 4, this.getDestroyReason() == null ? e.toString() : this.getDestroyReason());
    }

    private void sendReply(Packet pkt, int status) {
        if (pkt.getSendAcknowledge()) {
            Packet reply = new Packet(this.useDirectBuffers());
            reply.setPacketType(9);
            reply.setConsumerID(pkt.getConsumerID());
            Hashtable<String, Integer> hash = new Hashtable<String, Integer>();
            hash.put("JMQStatus", status);
            reply.setProperties(hash);
            this.sendControlMessage(reply);
        }
    }

    @Override
    public void cleanupMemory(boolean persist) {
    }

    @Override
    protected void sayGoodbye(int reason, String reasonstr) {
        this.sayGoodbye(false, reason, reasonstr);
    }

    @Override
    protected void sayGoodbye(boolean force, int reason, String reasonStr) {
        Packet goodbye_pkt = new Packet(this.useDirectBuffers());
        goodbye_pkt.setPacketType(28);
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        hash.put("JMQExit", force);
        hash.put("JMQGoodbyeReason", reason);
        hash.put("JMQGoodbyeReasonString", reasonStr);
        goodbye_pkt.setProperties(hash);
        this.sendControlMessage(goodbye_pkt);
    }

    @Override
    protected void checkConnection() {
        boolean sendAck = false;
        if (enablePingReply && closeInterval > 0 && this.getClientProtocolVersion() >= 364) {
            long interval;
            sendAck = true;
            long access = this.getLastResponseTime();
            long delta = System.currentTimeMillis() - access;
            if (delta >= (interval = (long)(ConnectionManager.pingTimeout * (closeInterval + 1)))) {
                this.logger.log(8, "B2173", (Object)String.valueOf(this.getConnectionUID().longValue()), (Object)String.valueOf(delta / 1000L));
                this.destroyConnection(false, 3, "Connection unresponsive");
            }
        }
        Packet flush_pkt = new Packet(this.useDirectBuffers());
        flush_pkt.setPacketType(54);
        if (sendAck) {
            flush_pkt.setSendAcknowledge(true);
        }
        this.sendControlMessage(flush_pkt);
    }

    @Override
    protected void flushConnection(long timeout) {
        this.flushControl(timeout);
    }

    @Override
    public void flowPaused(long size) {
        if (Globals.getMemManager() != null) {
            Globals.getMemManager().notifyWhenAvailable(this, size);
        }
    }

    @Override
    public void resumeMemory(int cnt, long memory, long max) {
        this.sendResume(cnt, memory, max, false);
    }

    @Override
    public void updateMemory(int cnt, long memory, long max) {
        this.sendResume(cnt, memory, max, true);
    }

    protected void sendResume(int cnt, long memory, long max, boolean priority) {
        if (this.packetVersion < 103) {
            return;
        }
        Packet resume_pkt = new Packet(this.useDirectBuffers());
        resume_pkt.setPacketType(52);
        Hashtable<String, Number> hash = new Hashtable<String, Number>();
        if (Globals.getMemManager() != null) {
            hash.put("JMQSize", Globals.getMemManager().getJMQSize());
            hash.put("JMQBytes", Globals.getMemManager().getJMQBytes());
            hash.put("JMQMaxMsgBytes", Globals.getMemManager().getJMQMaxMsgBytes());
        }
        resume_pkt.setProperties(hash);
        this.sendControlMessage(resume_pkt, priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventOccured(EventType type, Reason r, Object target, Object oldval, Object newval, Object userdata) {
        Object object = this.stateLock;
        synchronized (object) {
            if (type == EventType.EMPTY) {
                assert (target == this.control);
                assert (newval instanceof Boolean);
            } else if (type == EventType.BUSY_STATE_CHANGED) {
                assert (target instanceof Session);
                assert (newval instanceof Boolean);
                Session s = (Session)target;
                Set set = this.busySessions;
                synchronized (set) {
                    Object object2 = s.getBusyLock();
                    synchronized (object2) {
                        if (s.isBusy()) {
                            this.busySessions.add(s);
                        }
                    }
                }
            }
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fillNextPacket(Packet p) {
        Session s = null;
        Set set = this.busySessions;
        synchronized (set) {
            Iterator itr = this.busySessions.iterator();
            while (itr.hasNext()) {
                s = (Session)itr.next();
                itr.remove();
                if (s == null) continue;
                Object object = s.getBusyLock();
                synchronized (object) {
                    if (s.isBusy()) {
                        this.busySessions.add(s);
                        break;
                    }
                }
            }
        }
        if (s == null) {
            return false;
        }
        return s.fillNextPacket(p) != null;
    }

    static {
        try {
            String fillover;
            String readover;
            String ctrlover = Globals.getConfig().getProperty("imq.packet.ctrl.override");
            if (ctrlover != null && ctrlover.trim().length() > 0) {
                if ((ctrlover = ctrlover.trim()).equalsIgnoreCase("direct")) {
                    OVERRIDE_CTRL_PACKET = true;
                    O_CTRL_USE_DIRECT = true;
                    Globals.getLogger().log(4, "DEBUG: Overriding ctrl message  packet behavior to DIRECT BUFFERS");
                } else if (ctrlover.equalsIgnoreCase("heap")) {
                    OVERRIDE_CTRL_PACKET = true;
                    O_CTRL_USE_DIRECT = false;
                    Globals.getLogger().log(4, "DEBUG: Overriding ctrl message  packet behavior to HEAP BUFFERS");
                } else {
                    Globals.getLogger().log(32, "DEBUG: Can not determine behavior from  imq.packet.ctrl.override = " + ctrlover + "  not one of the valid setting [heap,direct]");
                }
            }
            if ((readover = Globals.getConfig().getProperty("imq.packet.read.override")) != null && readover.trim().length() > 0) {
                if ((readover = readover.trim()).equalsIgnoreCase("direct")) {
                    OVERRIDE_READ_PACKET = true;
                    O_READ_USE_DIRECT = true;
                    Globals.getLogger().log(4, "DEBUG: Overriding read packet behavior to DIRECT BUFFERS");
                } else if (readover.equalsIgnoreCase("heap")) {
                    OVERRIDE_READ_PACKET = true;
                    O_READ_USE_DIRECT = false;
                    Globals.getLogger().log(4, "DEBUG: Overriding read packet  behavior to HEAP BUFFERS");
                } else {
                    Globals.getLogger().log(32, "DEBUG: Can not determine behavior from  imq.packet.read.override = " + readover + "  not one of the valid setting [heap,direct]");
                }
            }
            if ((fillover = Globals.getConfig().getProperty("imq.packet.fill.override")) != null && fillover.trim().length() > 0) {
                if ((fillover = fillover.trim()).equalsIgnoreCase("direct")) {
                    OVERRIDE_FILL_PACKET = true;
                    O_FILL_USE_DIRECT = true;
                    Globals.getLogger().log(4, "DEBUG: Overriding fill packet  behavior to DIRECT BUFFERS");
                } else if (fillover.equalsIgnoreCase("heap")) {
                    OVERRIDE_FILL_PACKET = true;
                    O_FILL_USE_DIRECT = false;
                    Globals.getLogger().log(4, "DEBUG: Overriding fill packet  behavior to HEAP BUFFERS");
                } else {
                    Globals.getLogger().log(32, "DEBUG: Can not determine  behavior from jmq.packet.fill.override = " + fillover + "  not one of the valid setting [heap,direct]");
                }
            }
        }
        catch (Exception ex) {
            Globals.getLogger().logStack(4, "DEBUG: error setting overrides", (Throwable)ex);
        }
    }

    static class StateWatcher
    extends TimerTask {
        private int state;
        IMQIPConnection con = null;

        StateWatcher(int state, IMQIPConnection con) {
            this.state = state;
            this.con = con;
        }

        @Override
        public boolean cancel() {
            this.con = null;
            return super.cancel();
        }

        @Override
        public void run() {
            this.con.checkConnection(this.state);
        }
    }
}

