/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.Traceable;
import jakarta.jms.CompletionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.io.PrintStream;
import java.util.logging.Level;

public class AsyncSendCallback
implements Traceable {
    protected MessageProducerImpl producer = null;
    private jakarta.jms.Destination destination = null;
    private long transactionID = -1L;
    private Message message;
    private CompletionListener completionListener;
    private Message foreignMessage;
    private boolean onAckWait = false;
    private boolean sendSuccessReturn = false;
    private boolean sendReturned = false;
    private boolean completed = false;
    private Exception exception = null;
    private boolean callbackCalled = false;
    private long timeoutTime = 0L;
    private static final Exception timedoutEx = AsyncSendCallback.getTimedoutException();

    private static Exception getTimedoutException() {
        String emsg = AdministeredObject.cr.getKString("C4314");
        return new JMSException(emsg, "C4314");
    }

    public AsyncSendCallback(MessageProducerImpl p, jakarta.jms.Destination d, Message m, CompletionListener l, Message fm) {
        this.producer = p;
        this.destination = d;
        this.message = m;
        this.completionListener = l;
        this.foreignMessage = fm;
    }

    protected void startTimeoutTimer() {
        if (this.timeoutTime != 0L) {
            return;
        }
        this.timeoutTime = System.currentTimeMillis() + this.producer.session.connection.getAsyncSendCompletionWaitTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTimedout() {
        AsyncSendCallback asyncSendCallback = this;
        synchronized (asyncSendCallback) {
            if (this.completed || this.exception != null) {
                return false;
            }
        }
        if (this.timeoutTime == 0L) {
            return false;
        }
        return System.currentTimeMillis() >= this.timeoutTime;
    }

    protected synchronized void setTransactionID(long tid) {
        this.transactionID = tid;
    }

    protected synchronized void asyncSendStart() throws JMSException {
        this.onAckWait = true;
    }

    protected synchronized void sendSuccessReturn() {
        this.sendSuccessReturn = true;
    }

    protected synchronized boolean hasSendReturned() {
        return this.sendReturned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendReturn() {
        boolean remove = false;
        AsyncSendCallback asyncSendCallback = this;
        synchronized (asyncSendCallback) {
            if (!this.sendSuccessReturn) {
                remove = true;
            }
        }
        if (remove) {
            this.producer.session.removeAsyncSendCallback(this);
        }
        asyncSendCallback = this;
        synchronized (asyncSendCallback) {
            this.sendReturned = true;
        }
        this.producer.session.asyncSendCBProcessor.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processCompletion(ReadOnlyPacket ack, boolean checkstatus) {
        Exception ex = null;
        if (checkstatus) {
            ProtocolHandler ph = this.producer.session.protocolHandler;
            try {
                ProtocolHandler.checkWriteJMSMessageStatus(ProtocolHandler.getReplyStatus(ack), (Destination)this.destination, ack, ph);
            }
            catch (Exception e) {
                ex = e;
            }
        }
        boolean notify = true;
        AsyncSendCallback e = this;
        synchronized (e) {
            if (this.exception != null && ex == null) {
                MessageProducerImpl.sessionLogger.log(Level.INFO, "Async send completed: " + this.toString(true));
            }
            if (this.completed || this.exception != null) {
                notify = false;
            } else if (ex == null) {
                this.completed = true;
            } else {
                this.exception = ex;
                MessageProducerImpl.sessionLogger.log(Level.INFO, "Async send exceptioned: " + this.toString(true), ex);
            }
        }
        if (notify) {
            if (this.completed && this.foreignMessage != null) {
                try {
                    this.producer.resetForeignMessageHeader(this.message, this.foreignMessage);
                }
                catch (Exception e2) {
                    this.exception = e2;
                    MessageProducerImpl.sessionLogger.log(Level.INFO, "Async send exceptioned: " + this.toString(true), e2);
                    this.completed = false;
                }
            }
            this.producer.session.asyncSendCBProcessor.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processException(Exception ex) {
        AsyncSendCallback asyncSendCallback = this;
        synchronized (asyncSendCallback) {
            if (this.completed || this.exception != null) {
                return;
            }
            this.exception = ex;
        }
        MessageProducerImpl.sessionLogger.log(Level.INFO, "Async send exceptioned: " + this.toString(false), ex);
        this.producer.session.asyncSendCBProcessor.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callCompletionListener() {
        AsyncSendCallback asyncSendCallback = this;
        synchronized (asyncSendCallback) {
            if (this.callbackCalled) {
                return;
            }
            if (this.completed || this.exception != null) {
                this.callbackCalled = true;
            } else if (this.isTimedout()) {
                this.exception = timedoutEx;
                this.exception.fillInStackTrace();
                this.callbackCalled = true;
            }
        }
        try {
            if (this.completed) {
                try {
                    this.completionListener.onCompletion(this.message);
                }
                catch (Exception ee) {
                    MessageProducerImpl.sessionLogger.log(Level.WARNING, ee.getMessage() + this.toString(), ee);
                }
            } else if (this.exception != null) {
                try {
                    this.completionListener.onException(this.message, this.exception);
                }
                catch (Exception ee) {
                    MessageProducerImpl.sessionLogger.log(Level.WARNING, ee.getMessage() + this.toString(), ee);
                }
            }
        }
        finally {
            this.producer.session.removeAsyncSendCallback(this);
        }
    }

    protected synchronized boolean isOnAckWait() {
        return this.onAckWait;
    }

    protected synchronized boolean isCompleted() {
        return this.completed;
    }

    protected synchronized boolean isExceptioned() {
        return this.exception != null;
    }

    protected synchronized boolean isInTransaction() {
        return this.transactionID != -1L;
    }

    private String toString(boolean getmid) {
        String str = "AsyncSendCallback[producer@" + this.producer.hashCode() + ", " + this.destination;
        if (getmid) {
            try {
                str = str + ", " + this.message.getJMSMessageID();
            }
            catch (Exception e) {
                str = str + ", [message@" + this.message.hashCode() + ":" + e.toString() + "]";
            }
        } else {
            str = str + ", [message@" + this.message.hashCode() + "]";
        }
        str = str + ", completed=" + this.completed + ", exception=" + this.exception + ", sendSuccessReturn=" + this.sendSuccessReturn + "]";
        return str;
    }

    @Override
    public synchronized void dump(PrintStream ps) {
        ps.println("------ AsyncSendCallback@" + this.hashCode() + " dump ------");
        ps.println("producer: @" + this.producer.hashCode());
        ps.println("destination: " + this.destination);
        if (this.completed) {
            try {
                ps.println("message: " + this.message.getJMSMessageID());
            }
            catch (Exception e) {
                ps.println("message: @" + this.message.hashCode() + ":  " + e.toString());
            }
        } else {
            ps.println("message: @" + this.message.hashCode());
        }
        ps.println("completionListener: @" + this.completionListener.hashCode());
        if (this.foreignMessage == null) {
            ps.println("foreignMessage: null");
        } else {
            try {
                ps.println("foreignMessage: @" + this.foreignMessage.getJMSMessageID());
            }
            catch (Exception e) {
                ps.println("foreignMessage: @" + this.foreignMessage.hashCode() + ": " + e.toString());
            }
        }
        ps.println("inTransaction: " + (this.transactionID != -1L));
        ps.println("completed: " + this.completed);
        ps.println("exception: " + this.exception);
        ps.println("sendSuccessReturn: " + this.sendSuccessReturn);
        ps.println("sendReturned: " + this.sendReturned);
    }
}

