/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.verifier;

import com.sun.xml.ws.security.spi.AlternativeSelector;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.impl.PolicyViolationException;
import com.sun.xml.wss.impl.policy.PolicyAlternatives;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.spi.PolicyVerifier;
import com.sun.xml.wss.impl.policy.verifier.PolicyVerifierFactory;
import com.sun.xml.wss.impl.policy.verifier.TargetResolver;
import com.sun.xml.wss.impl.policy.verifier.UsernameOrSAMLAlternativeSelector;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Logger;

public class PolicyAlternativesVerifier
implements PolicyVerifier {
    private ProcessingContext ctx = null;
    private static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public PolicyAlternativesVerifier(ProcessingContext ctx, TargetResolver targetResolver) {
        this.ctx = ctx;
    }

    @Override
    public void verifyPolicy(SecurityPolicy recvdPolicy, SecurityPolicy configPolicy) throws PolicyViolationException {
        PolicyAlternatives confPolicies = (PolicyAlternatives)configPolicy;
        List<MessagePolicy> mps = confPolicies.getSecurityPolicy();
        if (mps.size() == 1) {
            PolicyVerifier verifier = PolicyVerifierFactory.createVerifier(mps.get(0), this.ctx);
            verifier.verifyPolicy(recvdPolicy, mps.get(0));
            if (mps.get(0).getPolicyAlternativeId() != null) {
                this.ctx.getExtraneousProperties().put("policy-alternative-id", mps.get(0).getPolicyAlternativeId());
            }
        } else {
            AlternativeSelector selector = this.findAlternativesSelector(mps);
            MessagePolicy toVerify = selector.selectAlternative(this.ctx, mps, recvdPolicy);
            if (toVerify != null) {
                PolicyVerifier verifier = PolicyVerifierFactory.createVerifier(toVerify, this.ctx);
                verifier.verifyPolicy(recvdPolicy, toVerify);
                if (toVerify.getPolicyAlternativeId() != null) {
                    this.ctx.getExtraneousProperties().put("policy-alternative-id", toVerify.getPolicyAlternativeId());
                }
            } else {
                throw new UnsupportedOperationException("Cannot verify the request against the configured PolicyAlternatives in the WebService");
            }
        }
    }

    private AlternativeSelector findAlternativesSelector(List<MessagePolicy> alternatives) {
        ServiceLoader<AlternativeSelector> alternativeSelectorLoader = ServiceLoader.load(AlternativeSelector.class);
        if (alternativeSelectorLoader == null) {
            if (alternatives.size() == 2) {
                return new UsernameOrSAMLAlternativeSelector();
            }
            throw new UnsupportedOperationException("No AlternativeSelector accepts the policy alternatives combination.");
        }
        for (AlternativeSelector selector : alternativeSelectorLoader) {
            if (!selector.supportsAlternatives(alternatives)) continue;
            return selector;
        }
        throw new UnsupportedOperationException("No AlternativeSelector accepts the policy alternatives combination.");
    }
}

