/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi.base;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ManagedConnectionImpl;
import com.sun.gjc.util.MethodExecutor;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.LazyAssociatableConnectionManager;
import jakarta.resource.spi.LazyEnlistableConnectionManager;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ConnectionHolder
implements Connection {
    protected static final Logger _logger = LogDomains.getLogger(ManagedConnectionImpl.class, (String)"jakarta.enterprise.resource.resourceadapter");
    protected static final StringManager sm = StringManager.getManager(DataSourceObjectBuilder.class);
    protected Connection connection;
    protected ManagedConnectionImpl managedConnectionImpl;
    protected boolean wrappedAlready;
    protected boolean isClosed;
    protected boolean valid = true;
    protected boolean active;
    private LazyAssociatableConnectionManager lazyAssocCm_;
    private LazyEnlistableConnectionManager lazyEnlistCm_;
    private ConnectionRequestInfo connectionRequestInfo;
    private ManagedConnectionFactory managedConnectionFactory;
    protected int statementTimeout;
    protected boolean statementTimeoutEnabled;
    private MethodExecutor executor;
    private ConnectionType myType_ = ConnectionType.STANDARD;

    public ConnectionHolder(Connection con, ManagedConnectionImpl mc, ConnectionRequestInfo cxRequestInfo) {
        this.connection = con;
        this.managedConnectionImpl = mc;
        this.managedConnectionFactory = mc.getMcf();
        this.connectionRequestInfo = cxRequestInfo;
        this.statementTimeout = mc.getStatementTimeout();
        this.executor = new MethodExecutor();
        if (this.statementTimeout > 0) {
            this.statementTimeoutEnabled = true;
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void wrapped(boolean wrapFlag) {
        this.wrappedAlready = wrapFlag;
    }

    public boolean isWrapped() {
        return this.wrappedAlready;
    }

    public ManagedConnectionImpl getManagedConnection() {
        return this.managedConnectionImpl;
    }

    public void associateConnection(Connection con, ManagedConnectionImpl mc) {
        this.managedConnectionImpl = mc;
        this.connection = con;
    }

    public void dissociateConnection() {
        this.managedConnectionImpl = null;
        this.connection = null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkValidity();
        this.connection.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ConnectionHolder.close() START managedConnectionImpl=" + String.valueOf(this.managedConnectionImpl));
        }
        if (this.isClosed) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "jdbc.duplicate_close_connection", this);
            }
            return;
        }
        this.isClosed = true;
        if (this.managedConnectionImpl != null) {
            this.managedConnectionImpl.connectionClosed(null, this);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ConnectionHolder.close() END managedConnectionImpl=" + String.valueOf(this.managedConnectionImpl));
        }
    }

    public void invalidate() {
        this.valid = false;
    }

    void actualClose() throws SQLException {
        this.connection.close();
    }

    @Override
    public void commit() throws SQLException {
        this.checkValidity();
        this.connection.commit();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        Statement statement = this.connection.createStatement();
        if (this.statementTimeoutEnabled) {
            try {
                statement.setQueryTimeout(this.statementTimeout);
            }
            catch (SQLException ex) {
                statement.close();
            }
        }
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        Statement statement = this.connection.createStatement(resultSetType, resultSetConcurrency);
        if (this.statementTimeoutEnabled) {
            try {
                statement.setQueryTimeout(this.statementTimeout);
            }
            catch (SQLException ex) {
                statement.close();
            }
        }
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        Statement statement = this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        if (this.statementTimeoutEnabled) {
            try {
                statement.setQueryTimeout(this.statementTimeout);
            }
            catch (SQLException ex) {
                statement.close();
            }
        }
        return statement;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkValidity();
        return this.connection.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkValidity();
        return this.connection.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkValidity();
        return this.connection.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkValidity();
        return this.connection.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkValidity();
        return this.connection.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkValidity();
        return this.connection.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkValidity();
        return this.connection.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public void setClosed(boolean flag) {
        this.isClosed = flag;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkValidity();
        return this.connection.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkValidity();
        return this.connection.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        CallableStatement stmt = this.connection.prepareCall(sql);
        if (this.statementTimeoutEnabled) {
            stmt.setQueryTimeout(this.statementTimeout);
        }
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        CallableStatement callableStatement = this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
        if (this.statementTimeoutEnabled) {
            callableStatement.setQueryTimeout(this.statementTimeout);
        }
        return callableStatement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        CallableStatement callableStatement = this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (this.statementTimeoutEnabled) {
            callableStatement.setQueryTimeout(this.statementTimeout);
        }
        return callableStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
        if (this.statementTimeoutEnabled) {
            try {
                preparedStatement.setQueryTimeout(this.statementTimeout);
            }
            catch (SQLException ex) {
                preparedStatement.close();
            }
        }
        return preparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        PreparedStatement preparedStatement = this.connection.prepareStatement(sql, autoGeneratedKeys);
        if (this.statementTimeoutEnabled) {
            try {
                preparedStatement.setQueryTimeout(this.statementTimeout);
            }
            catch (SQLException ex) {
                preparedStatement.close();
            }
        }
        return preparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        PreparedStatement preparedStatement = this.connection.prepareStatement(sql, columnIndexes);
        if (this.statementTimeoutEnabled) {
            try {
                preparedStatement.setQueryTimeout(this.statementTimeout);
            }
            catch (SQLException ex) {
                preparedStatement.close();
            }
        }
        return preparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        PreparedStatement preparedStatement = this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        if (this.statementTimeoutEnabled) {
            try {
                preparedStatement.setQueryTimeout(this.statementTimeout);
            }
            catch (SQLException ex) {
                preparedStatement.close();
            }
        }
        return preparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        PreparedStatement preparedStatement = this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (this.statementTimeoutEnabled) {
            try {
                preparedStatement.setQueryTimeout(this.statementTimeout);
            }
            catch (SQLException ex) {
                preparedStatement.close();
            }
        }
        return preparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        PreparedStatement preparedStatement = this.connection.prepareStatement(sql, columnNames);
        if (this.statementTimeoutEnabled) {
            try {
                preparedStatement.setQueryTimeout(this.statementTimeout);
            }
            catch (SQLException ex) {
                preparedStatement.close();
            }
        }
        return preparedStatement;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkValidity();
        this.connection.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.checkValidity();
        this.connection.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkValidity();
        this.connection.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkValidity();
        this.connection.setAutoCommit(autoCommit);
        this.managedConnectionImpl.setLastAutoCommitValue(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkValidity();
        this.connection.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkValidity();
        this.connection.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkValidity();
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkValidity();
        return this.connection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkValidity();
        return this.connection.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkValidity();
        this.connection.setTransactionIsolation(level);
        this.managedConnectionImpl.setLastTransactionIsolationLevel(level);
    }

    protected void checkValidity() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection closed");
        }
        if (!this.valid) {
            throw new SQLException("Invalid Connection");
        }
        if (!this.active) {
            this.managedConnectionImpl.checkIfActive(this);
        }
    }

    public void setActive(boolean actv) {
        this.active = actv;
    }

    protected void jdbcPreInvoke() throws SQLException {
        if (this.myType_ == ConnectionType.LAZY_ASSOCIATABLE) {
            this.performLazyAssociation();
        } else if (this.myType_ == ConnectionType.LAZY_ENLISTABLE) {
            this.performLazyEnlistment();
        }
    }

    protected void performLazyEnlistment() throws SQLException {
        try {
            if (this.lazyEnlistCm_ != null) {
                this.lazyEnlistCm_.lazyEnlist((ManagedConnection)this.managedConnectionImpl);
            }
        }
        catch (ResourceException re) {
            String msg = sm.getString("jdbc.cannot_enlist", (Object)(re.getMessage() + " Cannnot Enlist ManagedConnection"));
            SQLException sqle = new SQLException(msg);
            sqle.initCause(re);
            throw sqle;
        }
    }

    protected void performLazyAssociation() throws SQLException {
        if (this.managedConnectionImpl == null) {
            try {
                if (this.lazyAssocCm_ != null) {
                    this.lazyAssocCm_.associateConnection((Object)this, this.managedConnectionFactory, this.connectionRequestInfo);
                }
            }
            catch (ResourceException re) {
                String msg = sm.getString("jdbc.cannot_assoc", (Object)(re.getMessage() + " Cannnot Associate ManagedConnection"));
                SQLException sqle = new SQLException(msg);
                sqle.initCause(re);
                throw sqle;
            }
        }
    }

    public void setConnectionType(ConnectionType type) {
        this.myType_ = type;
    }

    public ConnectionType getConnectionType() {
        return this.myType_;
    }

    public void setLazyAssociatableConnectionManager(LazyAssociatableConnectionManager cm) {
        this.lazyAssocCm_ = cm;
    }

    public void setLazyEnlistableConnectionManager(LazyEnlistableConnectionManager cm) {
        this.lazyEnlistCm_ = cm;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkValidity();
        this.connection.setTypeMap(map);
    }

    protected MethodExecutor getMethodExecutor() {
        return this.executor;
    }

    public static enum ConnectionType {
        LAZY_ENLISTABLE,
        LAZY_ASSOCIATABLE,
        STANDARD;

    }
}

