/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.ejb.api.EjbEndpointFacade;
import org.glassfish.ejb.spi.WSEjbEndpointRegistry;
import org.glassfish.internal.api.Globals;
import org.glassfish.webservices.EjbMessageDispatcher;
import org.glassfish.webservices.EjbRuntimeEndpointInfo;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.SecurityService;
import org.glassfish.webservices.WebServiceContextImpl;
import org.glassfish.webservices.WebServiceEjbEndpointRegistry;
import org.glassfish.webservices.WsUtil;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;
import org.glassfish.webservices.monitoring.WebServiceTesterServlet;

public class EjbWebServiceServlet
extends HttpServlet {
    private static final Logger logger = LogUtils.getLogger();
    private SecurityService securityService;

    public EjbWebServiceServlet() {
        if (Globals.getDefaultHabitat() != null) {
            this.securityService = (SecurityService)Globals.get(SecurityService.class);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestUriRaw = request.getRequestURI();
        String requestUri = requestUriRaw.charAt(0) == '/' ? requestUriRaw.substring(1) : requestUriRaw;
        String query = request.getQueryString();
        WebServiceEjbEndpointRegistry wsejbEndpointRegistry = (WebServiceEjbEndpointRegistry)Globals.getDefaultHabitat().getService(WSEjbEndpointRegistry.class, new Annotation[0]);
        EjbRuntimeEndpointInfo ejbEndpoint = wsejbEndpointRegistry.getEjbWebServiceEndpoint(requestUri, request.getMethod(), query);
        if (requestUri.contains("__container$publishing$subctx") && ejbEndpoint == null) {
            requestUri = requestUri.substring(0, requestUri.indexOf("__container$publishing$subctx") - 1);
            ejbEndpoint = wsejbEndpointRegistry.getEjbWebServiceEndpoint(requestUri, request.getMethod(), query);
        }
        if (ejbEndpoint != null) {
            String scheme = request.getScheme();
            WebServiceEndpoint endPoint = ejbEndpoint.getEndpoint();
            if ("http".equals(scheme) && endPoint.isSecure()) {
                logger.log(Level.WARNING, "AS-WSJSR109IMPL-00076", new Object[]{endPoint.getEndpointName(), "https", scheme});
                URL url = endPoint.composeEndpointAddress(new WsUtil().getWebServerInfoForDAS().getWebServerRootURL(true));
                StringBuilder sb = new StringBuilder(url.toExternalForm());
                if (query != null && query.trim().length() > 0) {
                    sb.append("?");
                    sb.append(query);
                }
                response.sendRedirect(URLEncoder.encode(sb.toString(), "UTF-8"));
            } else {
                boolean dispatch = true;
                if ("Tester".equalsIgnoreCase(query) && !"http://www.w3.org/2004/08/wsdl/http".equals(endPoint.getProtocolBinding())) {
                    Endpoint endpoint = WebServiceEngineImpl.getInstance().getEndpoint(request.getRequestURI());
                    if (endpoint.getDescriptor().isSecure() || endpoint.getDescriptor().getMessageSecurityBinding() != null) {
                        new WsUtil().writeInvalidMethodType(response, endpoint.getDescriptor().getWebService().getName() + "is a secured web service; Tester feature is not supported for secured services");
                        return;
                    }
                    if (Boolean.parseBoolean(endpoint.getDescriptor().getDebugging())) {
                        dispatch = false;
                        WebServiceTesterServlet.invoke(request, response, endpoint.getDescriptor());
                    }
                }
                if ("wsdl".equalsIgnoreCase(query) && !"http://www.w3.org/2004/08/wsdl/http".equals(endPoint.getProtocolBinding()) && endPoint.getWsdlExposed() != null && !Boolean.parseBoolean(endPoint.getWsdlExposed())) {
                    response.sendError(404);
                }
                if (dispatch) {
                    this.dispatchToEjbEndpoint(request, response, ejbEndpoint);
                }
            }
        } else {
            response.sendError(404);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchToEjbEndpoint(HttpServletRequest hreq, HttpServletResponse hresp, EjbRuntimeEndpointInfo ejbEndpoint) {
        EjbEndpointFacade container = ejbEndpoint.getContainer();
        ClassLoader savedClassLoader = null;
        boolean authenticated = false;
        try {
            savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(container.getEndpointClassLoader());
            Object realmName = null;
            Application app = ejbEndpoint.getEndpoint().getBundleDescriptor().getApplication();
            if (app != null) {
                realmName = app.getRealm();
            }
            if (realmName == null) {
                realmName = ejbEndpoint.getEndpoint().getRealm();
            }
            if (realmName == null) {
                realmName = hreq.getServerName() + ":" + hreq.getServerPort();
            }
            try {
                if (this.securityService != null) {
                    WebServiceContextImpl context = (WebServiceContextImpl)ejbEndpoint.getWebServiceContext();
                    authenticated = this.securityService.doSecurity(hreq, ejbEndpoint, (String)realmName, context);
                }
            }
            catch (Exception e) {
                LogHelper.log((Logger)logger, (Level)Level.WARNING, (String)"AS-WSJSR109IMPL-00077", (Throwable)e, (Object[])new Object[]{ejbEndpoint.getEndpoint().getEndpointName()});
            }
            if (!authenticated) {
                hresp.setHeader("WWW-Authenticate", "Basic realm=\"" + (String)realmName + "\"");
                hresp.sendError(401);
                return;
            }
            EjbMessageDispatcher msgDispatcher = ejbEndpoint.getMessageDispatcher();
            msgDispatcher.invoke(hreq, hresp, this.getServletContext(), ejbEndpoint);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "AS-WSJSR109IMPL-00050", t);
        }
        finally {
            if (this.securityService != null) {
                this.securityService.resetSecurityContext();
                this.securityService.resetPolicyContext();
            }
            Thread.currentThread().setContextClassLoader(savedClassLoader);
        }
    }
}

