/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.bridge.api.BridgeServiceManager;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.common.handlers.InfoRequestHandler;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ExclusiveRequest;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.OperationNotAllowedException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.DiagManager;
import com.sun.messaging.jmq.util.MQThread;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Date;
import java.util.List;

public class BrokerStateHandler {
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private static final Object exclusiveRequestLock = new Object();
    private static ExclusiveRequest exclusiveRequestInProgress = null;
    private static boolean shuttingDown = false;
    private static boolean shutdownStarted = false;
    private static Thread shutdownThread = null;
    private static boolean storeShutdownStage0 = false;
    private static boolean storeShutdownStage1 = false;
    private static boolean storeShutdownStage2 = false;
    QuiesceRunnable qrun = null;
    long targetShutdownTime = 0L;
    private static int restartCode = Globals.getConfig().getIntProperty("imq.restart.code", 255);
    ClusterListener cl = new StateMonitorListener();
    private FaultInjection fi = null;

    public BrokerStateHandler() {
        Globals.getClusterManager().addEventListener(this.cl);
        this.fi = FaultInjection.getInjection();
    }

    public static boolean isShuttingDown() {
        return shuttingDown;
    }

    public static void setShuttingDown(boolean b) {
        shuttingDown = b;
    }

    public static boolean isShutdownStarted() {
        return shutdownStarted;
    }

    static void setShutdownStarted(boolean b) {
        shutdownStarted = b;
    }

    public static boolean isStoreShutdownStage0() {
        return storeShutdownStage0;
    }

    public static boolean isStoreShutdownStage1() {
        return storeShutdownStage1;
    }

    public static boolean isStoreShutdownStage2() {
        return storeShutdownStage2;
    }

    public static Thread getShutdownThread() {
        return shutdownThread;
    }

    public void destroy() {
        Globals.getClusterManager().addEventListener(this.cl);
    }

    public static int getRestartCode() {
        return restartCode;
    }

    public long getShutdownRemaining() {
        if (this.targetShutdownTime == 0L) {
            return -1L;
        }
        long remaining = this.targetShutdownTime - System.currentTimeMillis();
        if (remaining < 0L) {
            remaining = 0L;
        }
        return remaining;
    }

    public void takeoverBroker(String brokerID, Object extraInfo, boolean force) throws BrokerException {
        ClusterManager cm = Globals.getClusterManager();
        if (!cm.isHA()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4313"));
        }
        Object extraInfo2 = null;
        ClusteredBroker hcb = null;
        if (Globals.getJDBCHAEnabled()) {
            hcb = (HAClusteredBroker)cm.getBroker(brokerID);
        }
        if (hcb == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4312", brokerID));
        }
        if (hcb.isLocalBroker()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4311"));
        }
        Globals.getHAMonitorService().takeoverBroker((HAClusteredBroker)hcb, extraInfo, extraInfo2, force);
    }

    public String takeoverME(String brokerID, Long syncTimeout, Connection conn) throws BrokerException {
        throw new OperationNotAllowedException(Globals.getBrokerResources().getKString("B4313"), MessageType.getString(98));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExclusiveRequestLock(ExclusiveRequest req) throws BrokerException {
        Object object = exclusiveRequestLock;
        synchronized (object) {
            if (req != null) {
                if (exclusiveRequestInProgress != null) {
                    throw new BrokerException(exclusiveRequestInProgress.toString(true), 409);
                }
                exclusiveRequestInProgress = req;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unsetExclusiveRequestLock(ExclusiveRequest req) {
        Object object = exclusiveRequestLock;
        synchronized (object) {
            if (exclusiveRequestInProgress == null) {
                return;
            }
            if (exclusiveRequestInProgress == req) {
                exclusiveRequestInProgress = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce() throws BrokerException {
        if (this.qrun != null) {
            throw new IllegalStateException("Already Quiescing");
        }
        BrokerStateHandler brokerStateHandler = this;
        synchronized (brokerStateHandler) {
            this.qrun = new QuiesceRunnable();
        }
        MQThread thr = new MQThread(this.qrun, "quiesce thread");
        thr.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopQuiesce() throws BrokerException {
        try {
            QuiesceRunnable qr = null;
            BrokerStateHandler brokerStateHandler = this;
            synchronized (brokerStateHandler) {
                qr = this.qrun;
            }
            if (qr != null) {
                qr.breakQuiesce();
            }
            ServiceManager sm = Globals.getServiceManager();
            sm.startNewConnections(0);
            ClusteredBroker cb = Globals.getClusterManager().getLocalBroker();
            cb.setState(BrokerState.OPERATING);
            this.logger.log(8, "B1301");
        }
        catch (Exception ex) {
            Globals.getLogger().logStack(16, "B3100", "exception during unquiesce", (Throwable)ex);
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "unable to unquiesce"), ex);
        }
    }

    public void initiateShutdown(String requestedBy, long time, boolean triggerFailover, int exitCode, boolean threadOff) {
        this.initiateShutdown(requestedBy, time, triggerFailover, exitCode, threadOff, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateShutdown(String requestedBy, long time, boolean triggerFailover, int exitCode, boolean threadOff, boolean exit, boolean cleanupJMX) {
        BrokerStateHandler brokerStateHandler = this;
        synchronized (brokerStateHandler) {
            if (shutdownStarted) {
                if (this.targetShutdownTime > 0L) {
                    this.targetShutdownTime = time > 0L ? System.currentTimeMillis() + time : 0L;
                    this.notifyAll();
                }
                return;
            }
            shutdownStarted = true;
        }
        Agent agent = Globals.getAgent();
        if (agent != null) {
            agent.notifyShutdownStart();
        }
        this.targetShutdownTime = time > 0L ? System.currentTimeMillis() + time : 0L;
        ShutdownRunnable runner = new ShutdownRunnable(requestedBy, triggerFailover, exitCode, cleanupJMX);
        if (threadOff) {
            MQThread thr = new MQThread(runner, "shutdown thread");
            thr.setDaemon(false);
            thr.start();
        } else {
            int shutdown = runner.shutdown();
            if (exit) {
                System.exit(shutdown);
            }
        }
    }

    public void prepareShutdown(boolean failover, boolean force) {
        this.prepareShutdown(failover, force, null);
    }

    private void prepareShutdown(boolean failover, boolean force, BrokerAddress excludedBroker) {
        BridgeServiceManager bridgeManager = Globals.getBridgeServiceManager();
        if (bridgeManager != null) {
            try {
                Logger logger = Globals.getLogger();
                Globals.getBrokerResources();
                logger.log(8, "B1321");
                bridgeManager.stop();
                Globals.setBridgeServiceManager(null);
                Logger logger2 = Globals.getLogger();
                Globals.getBrokerResources();
                logger2.log(8, "B1322");
            }
            catch (Throwable t) {
                Globals.getBrokerResources();
                this.logger.logStack(16, "B2218", t);
            }
        }
        if (Globals.getMemManager() != null) {
            Globals.getMemManager().stopManagement();
        }
        if (excludedBroker == null) {
            Globals.getDestinationList();
            DestinationList.shutdown();
        }
        Globals.getClusterBroadcast().stopClusterIO(failover, force, excludedBroker);
    }

    private void shutdownServices(String requestedBy, int exitCode, Connection excludedConn) throws BrokerException {
        ServiceManager sm = Globals.getServiceManager();
        ConnectionManager cmgr = Globals.getConnectionManager();
        Globals.getLogger().logToAll(8, "B1077");
        int id = 1;
        String msg = Globals.getBrokerResources().getKString("B0076", requestedBy);
        if (exitCode == BrokerStateHandler.getRestartCode()) {
            id = 2;
            msg = Globals.getBrokerResources().getKString("B0077", requestedBy);
        }
        cmgr.broadcastGoodbye(id, msg, excludedConn);
        Globals.getLogger().logToAll(8, "B1078");
        cmgr.flushControlMessages(1000L);
        sm.stopAllActiveServices(true, excludedConn == null ? null : excludedConn.getService().getName());
    }

    public class QuiesceRunnable
    implements Runnable {
        boolean breakQuiesce = false;

        public QuiesceRunnable() throws BrokerException {
            BrokerStateHandler.this.logger.log(8, "B1197");
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.notifyQuiesceStart();
            }
            try {
                ClusteredBroker cb = Globals.getClusterManager().getLocalBroker();
                cb.setState(BrokerState.QUIESCE_STARTED);
                ServiceManager sm = Globals.getServiceManager();
                sm.stopNewConnections(0);
            }
            catch (Exception ex) {
                throw new BrokerException("B4252", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object cb;
                QuiesceRunnable quiesceRunnable = this;
                synchronized (quiesceRunnable) {
                    while (!this.breakQuiesce) {
                        ServiceManager smgr = Globals.getServiceManager();
                        int ccnt = smgr.getConnectionCount(0);
                        Globals.getDestinationList();
                        int msgcnt = DestinationList.totalCountNonPersist();
                        if (ccnt == 0 && msgcnt == 0) break;
                        Logger cfr_ignored_0 = BrokerStateHandler.this.logger;
                        BrokerStateHandler.this.logger.log(8, BrokerStateHandler.this.br.getKString("B1300", ccnt, msgcnt));
                        this.wait(10000L);
                    }
                }
                if (!this.breakQuiesce) {
                    cb = Globals.getClusterManager().getLocalBroker();
                    cb.setState(BrokerState.QUIESCE_COMPLETED);
                }
                BrokerStateHandler.this.logger.log(8, "B1198");
                cb = this;
                synchronized (cb) {
                    BrokerStateHandler.this.qrun = null;
                }
                Agent agent = Globals.getAgent();
                if (agent != null) {
                    agent.notifyQuiesceComplete();
                }
            }
            catch (Exception ex) {
                Globals.getLogger().logStack(16, "B3100", "quiescing broker ", (Throwable)ex);
            }
        }

        public synchronized void breakQuiesce() {
            this.breakQuiesce = true;
            this.notifyAll();
        }
    }

    static class StateMonitorListener
    implements ClusterListener {
        StateMonitorListener() {
        }

        void notifyClients() {
            List<Connection> l = Globals.getConnectionManager().getConnectionList(null);
            for (IMQConnection iMQConnection : l) {
                if (iMQConnection.isAdminConnection() || iMQConnection.getClientProtocolVersion() < 400) continue;
                InfoRequestHandler.sendInfoPacket(2, iMQConnection, 0L);
            }
        }

        @Override
        public void clusterPropertyChanged(String name, String value) {
        }

        @Override
        public void brokerAdded(ClusteredBroker broker, UID brokerSession) {
            this.notifyClients();
        }

        @Override
        public void brokerRemoved(ClusteredBroker broker, UID brokerSession) {
            this.notifyClients();
        }

        @Override
        public void masterBrokerChanged(ClusteredBroker oldMaster, ClusteredBroker newMaster) {
        }

        @Override
        public void brokerStatusChanged(String brokerid, int oldStatus, int newStatus, UID brokerSession, Object userData) {
            Globals.getDestinationList();
            if (!DestinationList.isPartitionMigratable()) {
                return;
            }
            ClusteredBroker cb = Globals.getClusterManager().getBroker(brokerid);
            if (cb.isLocalBroker()) {
                return;
            }
            if (BrokerStatus.getBrokerLinkIsUp(oldStatus) && BrokerStatus.getBrokerLinkIsDown(newStatus)) {
                Globals.getDestinationList();
                DestinationList.registerPartitionArrivalCheckEvent();
            }
        }

        @Override
        public void brokerStateChanged(String brokerid, BrokerState oldState, BrokerState newState) {
        }

        @Override
        public void brokerVersionChanged(String brokerid, int oldVersion, int newVersion) {
        }

        @Override
        public void brokerURLChanged(String brokerid, MQAddress oldAddress, MQAddress newAddress) {
            this.notifyClients();
        }
    }

    public class ShutdownRunnable
    implements Runnable {
        String requestedBy = "unknown";
        int exitCode = 0;
        boolean failover = false;
        boolean cleanupJMX = false;

        public ShutdownRunnable(String who, boolean trigger, int exitCode, boolean cleanupJMX) {
            BrokerStateHandler.this.logger.log(4, "Shutdown requested by " + who);
            this.requestedBy = who;
            this.failover = trigger;
            this.exitCode = exitCode;
            this.cleanupJMX = cleanupJMX;
        }

        @Override
        public void run() {
            int exit = this.shutdown();
            Broker.getBroker().exit(exit, Globals.getBrokerResources().getKString("B1199", this.requestedBy), this.exitCode == BrokerStateHandler.getRestartCode() ? BrokerEvent.Type.RESTART : BrokerEvent.Type.SHUTDOWN);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int shutdown() {
            ClusteredBroker cb = null;
            BrokerState state = null;
            try {
                shutdownThread = Thread.currentThread();
                storeShutdownStage0 = true;
                cb = Globals.getClusterManager().getLocalBroker();
                try {
                    state = cb.getState();
                    if (state != BrokerState.FAILOVER_STARTED && state != BrokerState.FAILOVER_PENDING && state != BrokerState.FAILOVER_COMPLETE) {
                        cb.setState(BrokerState.SHUTDOWN_STARTED);
                    }
                }
                catch (Throwable t) {
                    Globals.getLogger().logStack(16, "B3063", t);
                }
                storeShutdownStage1 = true;
                storeShutdownStage0 = false;
                if (BrokerStateHandler.this.getShutdownRemaining() > 0L) {
                    BrokerStateHandler.this.logger.log(8, "B1200", (Object)String.valueOf(BrokerStateHandler.this.getShutdownRemaining() / 1000L), String.valueOf(BrokerStateHandler.this.getShutdownRemaining()));
                    List<Connection> l = Globals.getConnectionManager().getConnectionList(null);
                    for (IMQConnection iMQConnection : l) {
                        if (iMQConnection.isAdminConnection() || iMQConnection.getClientProtocolVersion() < 400) continue;
                        InfoRequestHandler.sendInfoPacket(1, iMQConnection, 0L);
                    }
                    BrokerStateHandler brokerStateHandler = BrokerStateHandler.this;
                    synchronized (brokerStateHandler) {
                        try {
                            BrokerStateHandler.this.logger.log(8, "B1201", new Date(BrokerStateHandler.this.targetShutdownTime).toString());
                            BrokerStateHandler.this.wait(BrokerStateHandler.this.getShutdownRemaining());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                Globals.getLogger().logToAll(8, Globals.getBrokerResources().getKString("B1047") + "[" + this.requestedBy + ":" + Thread.currentThread() + "]");
                if (Broker.getBroker().getDiagInterval() == 0) {
                    Globals.getLogger().log(8, DiagManager.allToString());
                }
                shuttingDown = true;
                shutdownStarted = true;
                BrokerStateHandler.this.prepareShutdown(this.failover, false);
                ServiceManager sm = Globals.getServiceManager();
                sm.stopNewConnections(1);
                BrokerStateHandler.this.shutdownServices(this.requestedBy, this.exitCode, null);
                if (this.cleanupJMX) {
                    Agent agent = Globals.getAgent();
                    if (agent != null) {
                        agent.stop();
                        agent.unloadMBeans();
                    }
                } else {
                    Globals.getLogger().log(8, "B1246");
                }
            }
            catch (Exception ex) {
                Globals.getLogger().logStack(16, "B3063", ex);
                int n = 1;
                return n;
            }
            finally {
                storeShutdownStage2 = true;
                storeShutdownStage1 = false;
                try {
                    if (cb != null && state != BrokerState.FAILOVER_STARTED && state != BrokerState.FAILOVER_PENDING && state != BrokerState.FAILOVER_COMPLETE) {
                        try {
                            if (this.failover) {
                                cb.setState(BrokerState.SHUTDOWN_FAILOVER);
                            } else {
                                cb.setState(BrokerState.SHUTDOWN_COMPLETE);
                            }
                        }
                        catch (Throwable throwable) {
                            Globals.getLogger().logStack(16, "B3063", throwable);
                        }
                    }
                    storeShutdownStage2 = false;
                    storeShutdownStage1 = true;
                    Globals.releaseStore();
                }
                catch (Exception exception) {
                    Globals.getLogger().logStack(16, "B3063", exception);
                    return 1;
                }
            }
            Globals.getPortMapper().destroy();
            Globals.getLogger().logToAll(8, "B1048");
            if (this.exitCode == BrokerStateHandler.getRestartCode()) {
                Globals.getLogger().log(8, "B1064");
                if (BrokerStateHandler.this.fi.FAULT_INJECTION) {
                    BrokerStateHandler.this.fi.checkFaultAndSleep("broker.restart.exit.sleep", null, true);
                }
            }
            return this.exitCode;
        }
    }
}

