/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.SecureAdminHelperHolder;
import com.sun.enterprise.config.serverbeans.SecureAdminInternalUser;
import com.sun.enterprise.config.serverbeans.SecureAdminPrincipal;
import java.util.List;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.Create;
import org.glassfish.config.support.Delete;
import org.glassfish.config.support.Listing;
import org.glassfish.config.support.TypeAndNameResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.Transaction;

@Configured
public interface SecureAdmin
extends ConfigBeanProxy {
    public static final String DEFAULT_INSTANCE_ALIAS = "glassfish-instance";
    public static final String DEFAULT_ADMIN_ALIAS = "s1as";
    public static final String ADMIN_INDICATOR_HEADER_NAME = "X-GlassFish-admin";
    public static final String ADMIN_INDICATOR_DEFAULT_VALUE = "true";
    public static final String ADMIN_ONE_TIME_AUTH_TOKEN_HEADER_NAME = "X-GlassFish-authToken";

    @Element
    @Create(value="enable-secure-admin-principal", decorator=SecureAdminPrincipal.CrDecorator.class, i18n=@I18n(value="enable.secure.admin.principal.command"), cluster=@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE}))
    @Delete(value="disable-secure-admin-principal", resolver=SecureAdminPrincipal.Resolver.class, i18n=@I18n(value="disable.secure.admin.principal.command"), cluster=@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE}))
    @Listing(value="list-secure-admin-principals", i18n=@I18n(value="list.secure.admin.principals.command"))
    public List<SecureAdminPrincipal> getSecureAdminPrincipal();

    @Element
    @Create(value="enable-secure-admin-internal-user", decorator=SecureAdminInternalUser.CrDecorator.class, i18n=@I18n(value="enable.secure.admin.internal.user.command"), cluster=@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE}))
    @Delete(value="disable-secure-admin-internal-user", resolver=TypeAndNameResolver.class, i18n=@I18n(value="disable.secure.admin.internal.user.command"), cluster=@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE}))
    @Listing(value="list-secure-admin-internal-users", i18n=@I18n(value="list.secure.admin.internal.user.command"))
    public List<SecureAdminInternalUser> getSecureAdminInternalUser();

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getEnabled();

    public void setEnabled(String var1);

    @Attribute(defaultValue="true")
    public String getSpecialAdminIndicator();

    public void setSpecialAdminIndicator(String var1);

    @Attribute(defaultValue="s1as")
    public String dasAlias();

    public void setDasAlias(String var1);

    @Attribute(defaultValue="glassfish-instance")
    public String instanceAlias();

    public void setInstanceAlias(String var1);

    default public String getInstanceAlias() {
        return this.instanceAlias();
    }

    default public String getDasAlias() {
        return this.dasAlias();
    }

    public static boolean isEnabled(SecureAdmin secureAdmin) {
        return secureAdmin != null && Boolean.parseBoolean(secureAdmin.getEnabled());
    }

    public static String configuredAdminIndicator(SecureAdmin secureAdmin) {
        return secureAdmin == null ? ADMIN_INDICATOR_DEFAULT_VALUE : secureAdmin.getSpecialAdminIndicator();
    }

    public static String DASAlias(SecureAdmin secureAdmin) {
        return secureAdmin == null ? DEFAULT_ADMIN_ALIAS : secureAdmin.getDasAlias();
    }

    public static String instanceAlias(SecureAdmin secureAdmin) {
        return secureAdmin == null ? DEFAULT_INSTANCE_ALIAS : secureAdmin.getInstanceAlias();
    }

    public static SecureAdminInternalUser secureAdminInternalUser(SecureAdmin secureAdmin) {
        List<SecureAdminInternalUser> secureAdminUsers = SecureAdmin.secureAdminInternalUsers(secureAdmin);
        return secureAdminUsers.isEmpty() ? null : secureAdminUsers.get(0);
    }

    private static List<SecureAdminInternalUser> secureAdminInternalUsers(SecureAdmin secureAdmin) {
        return secureAdmin == null ? List.of() : secureAdmin.getSecureAdminInternalUser();
    }

    public static boolean isUsingUsernamePasswordAuth(SecureAdmin secureAdmin) {
        return !SecureAdmin.secureAdminInternalUsers(secureAdmin).isEmpty();
    }

    public static List<SecureAdminPrincipal> secureAdminPrincipals(SecureAdmin secureAdmin, ServiceLocator habitat) {
        List<SecureAdminPrincipal> principals = List.of();
        if (secureAdmin != null && (principals = secureAdmin.getSecureAdminPrincipal()).isEmpty()) {
            try {
                Transaction tx = new Transaction();
                SecureAdmin secureAdmin_w = (SecureAdmin)tx.enroll((ConfigBeanProxy)secureAdmin);
                principals = secureAdmin_w.getSecureAdminPrincipal();
                SecureAdminPrincipal dasPrincipal = (SecureAdminPrincipal)secureAdmin_w.createChild(SecureAdminPrincipal.class);
                dasPrincipal.setDn(SecureAdminHelperHolder.getSecureAdminHelper(habitat).getDN(secureAdmin.dasAlias(), true));
                principals.add(dasPrincipal);
                SecureAdminPrincipal instancePrincipal = (SecureAdminPrincipal)secureAdmin_w.createChild(SecureAdminPrincipal.class);
                instancePrincipal.setDn(SecureAdminHelperHolder.getSecureAdminHelper(habitat).getDN(secureAdmin.instanceAlias(), true));
                principals.add(instancePrincipal);
                tx.commit();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return principals;
    }
}

