/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.jdeparser.AbstractJExpr;
import org.jboss.jdeparser.BasicJBlock;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JLambda;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

class JLambdaImpl
extends AbstractJExpr
implements JLambda {
    private BasicJBlock blockBody;
    private AbstractJExpr exprBody;
    private boolean hasInferred;
    private ArrayList<Param> params;

    JLambdaImpl() {
        super(1);
    }

    @Override
    public JLambda param(JType type, String name) {
        if (name != null) {
            if (type == null) {
                this.hasInferred = true;
            }
            if (this.params == null) {
                this.params = new ArrayList();
            }
            this.params.add(new Param(type, name));
        }
        return this;
    }

    @Override
    public JLambda param(String typeName, String name) {
        return this.param(JTypes.typeNamed(typeName), name);
    }

    @Override
    public JLambda param(Class<?> type, String name) {
        return this.param(JTypes.typeOf(type), name);
    }

    @Override
    public JLambda param(String name) {
        return this.param((JType)null, name);
    }

    @Override
    public JBlock body() {
        this.exprBody = null;
        if (this.blockBody == null) {
            this.blockBody = new BasicJBlock(null, JBlock.Braces.REQUIRED);
        }
        return this.blockBody;
    }

    @Override
    public JLambda body(JExpr expression) {
        this.blockBody = null;
        this.exprBody = AbstractJExpr.of(expression);
        return this;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        if (this.params == null) {
            writer.write(Tokens$.PUNCT.PAREN.OPEN);
            writer.write(FormatPreferences.Space.WITHIN_PAREN_METHOD_CALL_EMPTY);
            writer.write(Tokens$.PUNCT.PAREN.CLOSE);
        } else {
            boolean singleParam;
            boolean bl = singleParam = this.params.size() == 1 && this.hasInferred;
            if (!singleParam) {
                writer.write(Tokens$.PUNCT.PAREN.OPEN);
                writer.write(FormatPreferences.Space.WITHIN_PAREN_METHOD_CALL);
            }
            Iterator<Param> iterator = this.params.iterator();
            while (iterator.hasNext()) {
                Param param = iterator.next();
                if (!this.hasInferred) {
                    writer.write(param.type);
                    writer.sp();
                }
                writer.writeEscaped(param.name);
                if (!iterator.hasNext()) continue;
                writer.write(Tokens$.PUNCT.COMMA);
                writer.write(FormatPreferences.Space.AFTER_COMMA);
            }
            if (!singleParam) {
                writer.write(FormatPreferences.Space.WITHIN_PAREN_METHOD_CALL);
                writer.write(Tokens$.PUNCT.PAREN.CLOSE);
            }
        }
        writer.write(FormatPreferences.Space.AROUND_ARROW);
        writer.write(Tokens$.PUNCT.BINOP.ARROW);
        writer.write(FormatPreferences.Space.AROUND_ARROW);
        if (this.exprBody != null) {
            this.exprBody.write(writer);
        } else if (this.blockBody != null) {
            this.blockBody.write(writer, null);
        } else {
            writer.write(Tokens$.PUNCT.BRACE.OPEN);
            writer.write(FormatPreferences.Space.WITHIN_BRACES_EMPTY);
            writer.write(Tokens$.PUNCT.BRACE.CLOSE);
        }
    }

    static class Param {
        private final JType type;
        private final String name;

        public Param(JType type, String name) {
            this.type = type;
            this.name = name;
        }

        public JType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }
}

