/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.util;

import java.util.concurrent.Callable;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.interceptor.proxy.InterceptorException;
import org.jboss.weld.interceptor.proxy.LifecycleMixin;
import org.jboss.weld.interceptor.spi.model.InterceptionType;

public class InterceptionUtils {
    public static final String POST_CONSTRUCT = "lifecycle_mixin_$$_postConstruct";
    public static final String PRE_DESTROY = "lifecycle_mixin_$$_preDestroy";

    private InterceptionUtils() {
    }

    private static void executePostConstruct(Object proxy, Callable callback) {
        if (proxy instanceof LifecycleMixin) {
            LifecycleMixin lifecycleMixin = (LifecycleMixin)proxy;
            lifecycleMixin.lifecycle_mixin_$$_postConstruct();
        }
        if (callback != null) {
            try {
                callback.call();
            }
            catch (Exception e) {
                throw new InterceptorException(e);
            }
        }
    }

    public static void executePostConstruct(Object proxy) {
        InterceptionUtils.executePostConstruct(proxy, null);
    }

    private static void executePredestroy(Object proxy, Callable callback) {
        if (proxy instanceof LifecycleMixin) {
            LifecycleMixin lifecycleMixin = (LifecycleMixin)proxy;
            lifecycleMixin.lifecycle_mixin_$$_preDestroy();
        }
        if (callback != null) {
            try {
                callback.call();
            }
            catch (Exception e) {
                throw new InterceptorException(e);
            }
        }
    }

    public static void executePredestroy(Object proxy) {
        InterceptionUtils.executePredestroy(proxy, null);
    }

    static boolean isAnnotationClassExpected(InterceptionType interceptionType) {
        Environment environment;
        return !InterceptionType.POST_ACTIVATE.equals((Object)interceptionType) && !InterceptionType.PRE_PASSIVATE.equals((Object)interceptionType) || (environment = Container.getEnvironment()) == null || !Environments.SE.equals(environment) && !Environments.SERVLET.equals(environment);
    }
}

