/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.core.BrokerMetricsMonitor;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.DestListMonitor;
import com.sun.messaging.jmq.jmsserver.core.DestMonitor;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.JVMMonitor;
import com.sun.messaging.jmq.jmsserver.core.Monitor;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TimerTask;

public class BrokerMonitor {
    private static final long DEFAULT_INTERVAL = 60L;
    private static final boolean DEFAULT_PERSIST = false;
    private static final long DEFAULT_TTL = 300L;
    private static final boolean DEFAULT_ENABLED = true;
    private static String METRICS_PROP_PREFIX = "imq.metrics.topic.";
    private static String METRICS_TIME_PROP = METRICS_PROP_PREFIX + "interval";
    private static String PERSIST_PROP = METRICS_PROP_PREFIX + "persist";
    private static String TTL_PROP = METRICS_PROP_PREFIX + "timetolive";
    private static String ENABLED_PROP = METRICS_PROP_PREFIX + "enabled";
    private static long METRICS_TIME = Globals.getConfig().getLongProperty(METRICS_TIME_PROP, 60L) * 1000L;
    static boolean PERSIST = Globals.getConfig().getBooleanProperty(PERSIST_PROP, false);
    static long TTL = Globals.getConfig().getLongProperty(TTL_PROP, 300L) * 1000L;
    private static boolean ENABLED = Globals.getConfig().getBooleanProperty(ENABLED_PROP, true);
    private static MQTimer timer = Globals.getTimer();
    Logger logger = Globals.getLogger();
    Monitor monitor = null;
    private static HashSet active = new HashSet();
    private static TimerTask task = null;
    boolean valid = true;
    boolean started = false;
    private static ConfigListener cl = new ConfigListener(){

        @Override
        public void validate(String name, String value) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean update(String name, String value) {
            if (name.equals(METRICS_TIME_PROP)) {
                METRICS_TIME = Globals.getConfig().getLongProperty(METRICS_TIME_PROP, 60L) * 1000L;
                HashSet hashSet = active;
                synchronized (hashSet) {
                    if (task != null) {
                        task.cancel();
                        task = new NotificationTask();
                        try {
                            timer.schedule(task, METRICS_TIME, METRICS_TIME);
                        }
                        catch (IllegalStateException ex) {
                            Globals.getLogger().log(16, "Update metrics timer schedule: " + ex, (Throwable)ex);
                        }
                    }
                }
            }
            if (name.equals(PERSIST_PROP)) {
                PERSIST = Globals.getConfig().getBooleanProperty(PERSIST_PROP, false);
            } else if (name.equals(TTL_PROP)) {
                TTL = Globals.getConfig().getLongProperty(TTL_PROP, 300L) * 1000L;
            } else if (name.equals(ENABLED_PROP)) {
                ENABLED = Globals.getConfig().getBooleanProperty(ENABLED_PROP, true);
            }
            return true;
        }
    };

    public static void shutdownMonitor() {
        if (task != null) {
            task.cancel();
        }
        active.clear();
        BrokerConfig cfg = Globals.getConfig();
        cfg.removeListener(METRICS_TIME_PROP, cl);
        cfg.removeListener(PERSIST_PROP, cl);
        cfg.removeListener(TTL_PROP, cl);
        cl = null;
    }

    public static boolean isENABLED() {
        return ENABLED;
    }

    public static void init() {
        BrokerConfig cfg = Globals.getConfig();
        cfg.addListener(METRICS_TIME_PROP, cl);
        cfg.addListener(PERSIST_PROP, cl);
        cfg.addListener(TTL_PROP, cl);
        cfg.addListener(ENABLED_PROP, cl);
    }

    public BrokerMonitor(Destination d) throws BrokerException {
        this.monitor = this.createMonitor(d);
    }

    public static boolean isInternal(String dest) {
        return DestType.destNameIsInternal((String)dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this;
        synchronized (object) {
            if (!this.valid) {
                return;
            }
            if (this.started) {
                return;
            }
            this.started = true;
        }
        object = active;
        synchronized (object) {
            active.add(this.monitor);
            if (task == null) {
                task = new NotificationTask();
                try {
                    timer.schedule(task, METRICS_TIME, METRICS_TIME);
                }
                catch (IllegalStateException ex) {
                    this.logger.log(8, "InternalError: Shutting down metrics, timer has been canceled", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this;
        synchronized (object) {
            if (!this.valid) {
                return;
            }
            if (!this.started) {
                return;
            }
            this.started = false;
        }
        object = active;
        synchronized (object) {
            active.remove(this.monitor);
            if (active.size() == 0) {
                task.cancel();
                task = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.stop();
        BrokerMonitor brokerMonitor = this;
        synchronized (brokerMonitor) {
            this.valid = false;
            this.started = false;
            this.monitor = null;
        }
    }

    private Monitor createMonitor(Destination d) throws BrokerException {
        String destination = d.getDestinationName();
        if (!DestType.destNameIsInternal((String)destination)) {
            throw new IllegalArgumentException("Illegal Internal Name" + destination);
        }
        String substring = destination.substring("mq.".length());
        StringTokenizer tk = new StringTokenizer(substring, ".");
        if (!tk.hasMoreElements()) {
            throw new IllegalArgumentException("Missing type  for monitoring " + destination);
        }
        String type = (String)tk.nextElement();
        if (!type.equals("metrics")) {
            throw new IllegalArgumentException("Illegal type " + type + " for monitoring. Only Metrics is valid [" + destination + "]");
        }
        if (!tk.hasMoreElements()) {
            throw new IllegalArgumentException("Missing area  for monitoring " + destination);
        }
        String area = (String)tk.nextElement();
        if (area.equals("broker")) {
            if (tk.hasMoreElements()) {
                throw new IllegalArgumentException("Bad name  for broker monitoring " + destination + " should be mq.broker");
            }
            this.monitor = new BrokerMetricsMonitor(d);
        } else if (area.equals("jvm")) {
            if (tk.hasMoreElements()) {
                throw new IllegalArgumentException("Bad name  for broker monitoring " + destination + " should be mq.jvm");
            }
            this.monitor = new JVMMonitor(d);
        } else if (area.equals("destination")) {
            if (!tk.hasMoreElements()) {
                throw new IllegalArgumentException("Missing destination type or list for broker destination monitoring " + destination);
            }
            String destArea = (String)tk.nextElement();
            if (destArea.equals("queue")) {
                if (!tk.hasMoreElements()) {
                    throw new IllegalArgumentException("Missing name  for broker queue monitoring " + destination);
                }
                String prefix = "metrics.destination.queue.";
                String name = substring.substring(prefix.length());
                DestinationUID duid = DestinationUID.getUID(name, true);
                Globals.getDestinationList();
                Destination[] ds = DestinationList.getDestination(d.getPartitionedStore(), duid);
                Destination dest = ds[0];
                Globals.getDestinationList();
                if (!DestinationList.canAutoCreate(true) && dest == null) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4185", duid.getName(), duid.getDestType()), 403);
                }
                this.monitor = new DestMonitor(d, duid);
            } else if (destArea.equals("topic")) {
                if (!tk.hasMoreElements()) {
                    throw new IllegalArgumentException("Missing name  for broker topic monitoring " + destination);
                }
                String prefix = "metrics.destination.topic.";
                String name = substring.substring(prefix.length());
                DestinationUID duid = DestinationUID.getUID(name, false);
                Globals.getDestinationList();
                Destination[] ds = DestinationList.getDestination(d.getPartitionedStore(), duid);
                Destination dest = ds[0];
                Globals.getDestinationList();
                if (!DestinationList.canAutoCreate(false) && dest == null) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4185", duid.getName(), duid.getDestType()), 403);
                }
                this.monitor = new DestMonitor(d, duid);
            }
        } else if (area.equals("destination_list")) {
            this.monitor = new DestListMonitor(d);
        } else {
            throw new IllegalArgumentException("Illegal area " + area + " for monitoring " + destination);
        }
        return this.monitor;
    }

    public void updateNewConsumer(Consumer c) {
        this.monitor.writeToSpecificMonitorConsumer(c);
    }

    static class NotificationTask
    extends TimerTask {
        NotificationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Iterator itr = null;
            HashSet hashSet = active;
            synchronized (hashSet) {
                itr = new HashSet(active).iterator();
            }
            while (itr.hasNext()) {
                Monitor m = (Monitor)itr.next();
                m.run();
            }
        }
    }
}

