/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.ServiceUtil;
import com.sun.messaging.jmq.jmsserver.service.MetricManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.MetricCounters;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class ServiceManagerConfig
extends MQMBeanReadWrite {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanOperationInfo[] ops;

    public Integer getMaxThreads() {
        MetricManager mm = Globals.getMetricManager();
        MetricCounters mc = mm.getMetricCounters(null);
        return mc.threadsHighWater;
    }

    public Integer getMinThreads() {
        MetricManager mm = Globals.getMetricManager();
        MetricCounters mc = mm.getMetricCounters(null);
        return mc.threadsLowWater;
    }

    public ObjectName[] getServices() throws MBeanException {
        List l = ServiceUtil.getVisibleServiceNames();
        if (l.size() == 0) {
            return null;
        }
        ObjectName[] oNames = new ObjectName[l.size()];
        Iterator iter = l.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String service = (String)iter.next();
            try {
                ObjectName o = MQObjectName.createServiceConfig(service);
                oNames[i++] = o;
            }
            catch (Exception e) {
                this.handleOperationException("getServices", e);
            }
        }
        return oNames;
    }

    public void pause() throws MBeanException {
        try {
            this.logger.log(8, "Pausing all services");
            ServiceUtil.pauseService(null);
        }
        catch (BrokerException e) {
            this.handleOperationException("pause", e);
        }
    }

    public void resume() throws MBeanException {
        try {
            this.logger.log(8, "Resuming all services");
            ServiceUtil.resumeService(null);
        }
        catch (BrokerException e) {
            this.handleOperationException("resume", e);
        }
    }

    @Override
    public String getMBeanName() {
        return "ServiceManagerConfig";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1222");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[2];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("MaxThreads", Integer.class.getName(), mbr.getString("MB1223"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("MinThreads", Integer.class.getName(), mbr.getString("MB1224"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[3];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getServices", mbr.getString("MB1235"), null, ObjectName[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("pause", mbr.getString("MB1236"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("resume", mbr.getString("MB1237"), null, Void.TYPE.getName(), 1);
        ops = mBeanOperationInfoArray;
    }
}

