/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.persist.file.ClusterTransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.LocalTransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgRemovalEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.NonTransactedMsgAckEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.NonTransactedMsgEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.RemoteTransactionEvent;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;

public abstract class TransactionEvent {
    public static TransactionEvent createFromBytes(byte[] data) throws IOException, BrokerException {
        TransactionEvent result = null;
        byte type = data[0];
        byte subType = data[1];
        result = TransactionEvent.create(type, subType);
        result.readFromBytes(data);
        return result;
    }

    static TransactionEvent create(byte type, byte subtype) {
        TransactionEvent result = null;
        switch (type) {
            case 1: {
                result = LocalTransactionEvent.create(subtype);
                break;
            }
            case 3: {
                result = ClusterTransactionEvent.create(subtype);
                break;
            }
            case 2: {
                result = RemoteTransactionEvent.create(subtype);
                break;
            }
            case 4: {
                result = NonTransactedMsgEvent.create(subtype);
                break;
            }
            case 5: {
                result = NonTransactedMsgAckEvent.create(subtype);
                break;
            }
            case 6: {
                result = MsgRemovalEvent.create(subtype);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    abstract int getType();

    abstract void readFromBytes(byte[] var1) throws IOException, BrokerException;

    abstract byte[] writeToBytes() throws IOException, BrokerException;
}

