/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.threadpool.NoSuchWorkQueueException;
import com.sun.corba.ee.spi.threadpool.Work;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.EventHandler;
import java.nio.channels.SelectionKey;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;

@Transport
public abstract class EventHandlerBase
implements EventHandler {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    protected ORB orb;
    protected Work work;
    protected boolean useWorkerThreadForEvent;
    protected boolean useSelectThreadToWait;
    protected SelectionKey selectionKey;

    @Override
    public void setUseSelectThreadToWait(boolean x) {
        this.useSelectThreadToWait = x;
    }

    @Override
    public boolean shouldUseSelectThreadToWait() {
        return this.useSelectThreadToWait;
    }

    @Override
    public void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    @Override
    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    @InfoMethod
    private void display(String msg) {
    }

    @InfoMethod
    private void display(String msg, Object value) {
    }

    @Override
    @Transport
    public void handleEvent() {
        this.getSelectionKey().interestOps(this.getSelectionKey().interestOps() & ~this.getInterestOps());
        if (this.shouldUseWorkerThreadForEvent()) {
            Throwable throwable = null;
            try {
                this.display("add work to pool 0");
                this.orb.getThreadPoolManager().getThreadPool(0).getWorkQueue(0).addWork(this.getWork());
            }
            catch (NoSuchThreadPoolException e) {
                throwable = e;
            }
            catch (NoSuchWorkQueueException e) {
                throwable = e;
            }
            if (throwable != null) {
                this.display("unexpected exception", throwable);
                throw wrapper.noSuchThreadpoolOrQueue(throwable, 0);
            }
        } else {
            this.display("doWork");
            this.getWork().doWork();
        }
    }

    @Override
    public boolean shouldUseWorkerThreadForEvent() {
        return this.useWorkerThreadForEvent;
    }

    @Override
    public void setUseWorkerThreadForEvent(boolean x) {
        this.useWorkerThreadForEvent = x;
    }

    @Override
    public void setWork(Work work) {
        this.work = work;
    }

    @Override
    public Work getWork() {
        return this.work;
    }
}

