/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.profiler.oracle;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.State;
import oracle.dms.spy.ConfigurationError;
import oracle.dms.spy.PublisherError;
import oracle.dms.spy.Spy;
import org.eclipse.persistence.internal.localization.DMSLocalization;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.sessions.server.ServerSession;

public class DMSPerformanceProfiler
implements Serializable,
Cloneable,
SessionProfiler {
    public static final String EclipseLinkRootNoun = "/EclipseLink";
    public static final String SessionNounType = "EclipseLink Session";
    public static final String TransactionNounType = "EclipseLink Transaction";
    public static final String RcmNounType = "EclipseLink RCM";
    public static final String ConnectionNounType = "EclipseLink Connections";
    public static final String CacheNounType = "EclipseLink Cache";
    public static final String MiscellaneousNounType = "EclipseLink Miscellaneous";
    public static final String ConnectionInUse = "ConnectionsInUse";
    public static final String MergeTime = "MergeTime";
    public static final String UnitOfWorkRegister = "UnitOfWorkRegister";
    public static final String DistributedMergeDmsDisplayName = "DistributedMerge";
    public static final String Sequencing = "Sequencing";
    public static final String CONNECT = "connect";
    public static final String CACHE = "cache";
    protected AbstractSession session;
    protected Noun root;
    protected Map<String, Sensor> normalWeightSensors;
    protected Map<String, Sensor> heavyWeightSensors;
    protected Map<String, Sensor> allWeightSensors;
    protected Map<String, Sensor> normalAndHeavyWeightSensors;
    protected Map<String, Sensor> normalHeavyAndAllWeightSensors;
    protected Map<String, Noun> normalWeightNouns;
    protected Map<String, Noun> heavyWeightNouns;
    protected Map<String, Noun> allWeightNouns;
    protected ThreadLocal<Map<String, Long>> operationStartTokenThreadLocal;
    protected static boolean isDMSSpyInitialized;
    protected int weight;

    public DMSPerformanceProfiler() {
        this(null);
    }

    public DMSPerformanceProfiler(Session session) {
        this.session = (AbstractSession)session;
        this.normalWeightNouns = new Hashtable<String, Noun>(1);
        this.heavyWeightNouns = new Hashtable<String, Noun>(5);
        this.allWeightNouns = new Hashtable<String, Noun>(1);
        this.normalWeightSensors = new Hashtable<String, Sensor>(4);
        this.heavyWeightSensors = new Hashtable<String, Sensor>();
        this.allWeightSensors = new Hashtable<String, Sensor>(22);
        this.normalAndHeavyWeightSensors = new Hashtable<String, Sensor>();
        this.normalHeavyAndAllWeightSensors = new Hashtable<String, Sensor>();
        this.operationStartTokenThreadLocal = new ThreadLocal();
        this.weight = DMSConsole.getSensorWeight();
        if (!isDMSSpyInitialized) {
            isDMSSpyInitialized = true;
            this.initSpy();
        }
    }

    protected void initializeNounTree(int newWeight) {
        if (newWeight == 0) {
            this.destroyNounsByWeight(5);
            this.destroyNounsByWeight(10);
            this.destroyNounsByWeight(Integer.MAX_VALUE);
            if (this.root != null) {
                this.root.destroy();
            }
            return;
        }
        if (newWeight == 5) {
            if (this.getProfileWeight() == 0) {
                this.initializeNormalWeightSensors();
            } else if (this.getProfileWeight() == 10) {
                this.destroyNounsByWeight(10);
            } else if (this.getProfileWeight() == Integer.MAX_VALUE) {
                this.destroyNounsByWeight(10);
                this.destroyNounsByWeight(Integer.MAX_VALUE);
            }
        }
        if (newWeight == 10) {
            if (this.getProfileWeight() == 0) {
                this.initializeNormalWeightSensors();
                this.initializeHeavyWeightSensors();
            } else if (this.getProfileWeight() == 5) {
                this.initializeHeavyWeightSensors();
            } else if (this.getProfileWeight() == Integer.MAX_VALUE) {
                this.destroyNounsByWeight(Integer.MAX_VALUE);
            }
        }
        if (newWeight == Integer.MAX_VALUE) {
            if (this.getProfileWeight() == 0) {
                this.initializeNormalWeightSensors();
                this.initializeHeavyWeightSensors();
                this.initializeAllWeightSensors();
            } else if (this.getProfileWeight() == 5) {
                this.initializeHeavyWeightSensors();
                this.initializeAllWeightSensors();
            } else if (this.getProfileWeight() == 10) {
                this.initializeAllWeightSensors();
            }
        }
    }

    public void setProfileWeight(int newWeight) {
        if (newWeight != this.weight) {
            this.getSession().setIsInProfile(newWeight != 0);
            if (this.getNormalWeightNouns().isEmpty()) {
                this.weight = 0;
            }
            this.initializeNounTree(newWeight);
            this.weight = newWeight;
        }
    }

    public void initialize() {
        this.weight = 0;
        this.initializeNounTree(DMSConsole.getSensorWeight());
        this.weight = DMSConsole.getSensorWeight();
    }

    public int getProfileWeight() {
        return this.weight;
    }

    public void startOperationProfile(String operationName) {
        if (this.getProfileWeight() == 5) {
            return;
        }
        Sensor phaseEvent = this.getSensorByName(operationName);
        if (phaseEvent != null) {
            Long startToken = ((PhaseEvent)phaseEvent).start();
            this.getPhaseEventStartToken().put(operationName, startToken);
        }
    }

    public void startOperationProfile(String operationName, DatabaseQuery query, int weight) {
        if (this.getProfileWeight() == 5) {
            return;
        }
        if (this.getProfileWeight() < weight) {
            return;
        }
        Sensor phaseEvent = this.getPhaseEventForQuery(operationName, query, weight);
        if (phaseEvent != null) {
            Long startToken = ((PhaseEvent)phaseEvent).start();
            if (query != null) {
                this.getPhaseEventStartToken().put(query.getSensorName(operationName, this.getSessionName()), startToken);
            } else {
                this.getPhaseEventStartToken().put(operationName, startToken);
            }
        }
    }

    public void endOperationProfile(String operationName) {
        if (this.getProfileWeight() == 5) {
            return;
        }
        Sensor phaseEvent = this.getSensorByName(operationName);
        if (phaseEvent != null) {
            Long startTime = this.getPhaseEventStartToken().get(operationName);
            ((PhaseEvent)phaseEvent).stop(startTime.longValue());
        }
    }

    public void endOperationProfile(String operationName, DatabaseQuery query, int weight) {
        if (this.getProfileWeight() == 5) {
            return;
        }
        if (this.getProfileWeight() < weight) {
            return;
        }
        Sensor phaseEvent = this.getPhaseEventForQuery(operationName, query, weight);
        if (phaseEvent != null) {
            Long startTime = query != null ? this.getPhaseEventStartToken().get(query.getSensorName(operationName, this.getSessionName())) : this.getPhaseEventStartToken().get(operationName);
            ((PhaseEvent)phaseEvent).stop(startTime.longValue());
        }
    }

    public void update(String operationName, Object value) {
        Sensor state = this.getSensorByName(operationName);
        if (state != null) {
            ((State)state).update(value);
        }
    }

    public void occurred(String operationName, AbstractSession session) {
        Sensor event = this.getSensorByName(operationName);
        if (event != null) {
            ((Event)event).occurred();
        }
    }

    public void occurred(String operationName, DatabaseQuery query, AbstractSession session) {
        Sensor event = this.getSensorByName(operationName);
        if (event != null) {
            ((Event)event).occurred();
            this.occurred(query.getMonitorName(), session);
        }
    }

    protected Sensor getPhaseEventForQuery(String operationName, DatabaseQuery query, int weight) {
        String sensorName = query != null ? query.getSensorName(operationName, this.getSessionName()) : operationName;
        Sensor phaseEvent = this.getSensorByName(sensorName);
        if (phaseEvent == null) {
            if (query != null) {
                String queryNounName = query.getQueryNounName(this.getSessionName());
                Noun queryNoun = this.getNounByType(queryNounName, null, 10);
                if (queryNoun == null) {
                    Noun domainClassNoun = this.getNounByType(query.getDomainClassNounName(this.getSessionName()), this.root, 10);
                    queryNoun = this.getNounByType(queryNounName, domainClassNoun, 10);
                }
                phaseEvent = PhaseEvent.create((Noun)queryNoun, (String)sensorName, (String)DMSLocalization.buildMessage((String)"query", (Object[])new Object[]{sensorName}));
            } else {
                Noun queryNoun = this.getAllWeightNouns().get(MiscellaneousNounType);
                phaseEvent = PhaseEvent.create((Noun)queryNoun, (String)sensorName, (String)DMSLocalization.buildMessage((String)"query_misc", (Object[])new Object[]{sensorName}));
            }
            phaseEvent.deriveMetric(511);
            if (weight == 10) {
                this.getHeavyWeightSensors().put(sensorName, phaseEvent);
                this.getNormalAndHeavyWeightSensors().put(sensorName, phaseEvent);
            } else if (weight == Integer.MAX_VALUE) {
                this.getAllWeightSensors().put(sensorName, phaseEvent);
                this.getNormalHeavyAndAllWeightSensors().put(sensorName, phaseEvent);
            }
        }
        return phaseEvent;
    }

    protected Noun getNounByType(String type, Noun parentNoun, int weight) {
        if (this.getProfileWeight() < weight) {
            return null;
        }
        Noun noun = null;
        Map<String, Noun> map = null;
        if (weight == 5) {
            map = this.getNormalWeightNouns();
        } else if (weight == 10) {
            map = this.getHeavyWeightNouns();
        } else if (weight == Integer.MAX_VALUE) {
            map = this.getAllWeightNouns();
        }
        if (map != null && (noun = map.get(type)) == null && parentNoun != null) {
            noun = Noun.create((Noun)parentNoun, (String)type, (String)type);
            map.put(type, noun);
        }
        return noun;
    }

    protected Sensor getSensorByName(String operationName) {
        Sensor sensor = null;
        if (this.getProfileWeight() == 5) {
            sensor = this.getNormalWeightSensors().get(operationName);
        } else if (this.getProfileWeight() == 10) {
            sensor = this.getNormalAndHeavyWeightSensors().get(operationName);
        } else if (this.getProfileWeight() == Integer.MAX_VALUE) {
            sensor = this.getNormalHeavyAndAllWeightSensors().get(operationName);
        }
        return sensor;
    }

    protected void createRootNoun() {
        this.root = Noun.create((String)EclipseLinkRootNoun);
    }

    protected void initializeNormalWeightSensors() {
        this.createRootNoun();
        Noun sessionNoun = Noun.create((Noun)this.root, (String)("Session" + this.getSessionName()), (String)SessionNounType);
        State.create((Noun)sessionNoun, (String)"Info:SessionName", (String)"", (String)DMSLocalization.buildMessage((String)"session_name"), (Object)(this.getSession().getName() == "" ? "session name not specified" : this.getSession().getName()));
        State sessionLoginTime = State.create((Noun)sessionNoun, (String)"Info:LoginTime", (String)"", (String)DMSLocalization.buildMessage((String)"session_login_time"), (Object)"not available");
        this.getNormalWeightSensors().put("Info:LoginTime", (Sensor)sessionLoginTime);
        this.getNormalWeightNouns().put(SessionNounType, sessionNoun);
    }

    protected void initializeHeavyWeightSensors() {
        Noun baseSessionNoun = this.getNormalWeightNouns().get(SessionNounType);
        Event clientSession = Event.create((Noun)baseSessionNoun, (String)"Counter:ClientSessionCreates", (String)DMSLocalization.buildMessage((String)"client_session_count"));
        this.getHeavyWeightSensors().put("Counter:ClientSessionCreates", (Sensor)clientSession);
        Event unitOfWork = Event.create((Noun)baseSessionNoun, (String)"Counter:UnitOfWorkCreates", (String)DMSLocalization.buildMessage((String)"unitofwork_count"));
        this.getHeavyWeightSensors().put("Counter:UnitOfWorkCreates", (Sensor)unitOfWork);
        Noun transactionNoun = Noun.create((Noun)this.root, (String)("Transaction" + this.getSessionName()), (String)TransactionNounType);
        this.getHeavyWeightNouns().put(TransactionNounType, transactionNoun);
        PhaseEvent uowCommit = PhaseEvent.create((Noun)transactionNoun, (String)"Timer:UnitOfWorkCommit", (String)DMSLocalization.buildMessage((String)"unitofwork_commit"));
        uowCommit.deriveMetric(511);
        this.getHeavyWeightSensors().put("Timer:UnitOfWorkCommit", (Sensor)uowCommit);
        Event uowCommits = Event.create((Noun)transactionNoun, (String)"Counter:UnitOfWorkCommits", (String)DMSLocalization.buildMessage((String)"unitofwork_commits"));
        this.getHeavyWeightSensors().put("Counter:UnitOfWorkCommits", (Sensor)uowCommits);
        Event uowRollbacks = Event.create((Noun)transactionNoun, (String)"Counter:UnitOfWorkRollbacks", (String)DMSLocalization.buildMessage((String)"unitofwork_rollback"));
        this.getHeavyWeightSensors().put("Counter:UnitOfWorkRollbacks", (Sensor)uowRollbacks);
        Event optimisticLock = Event.create((Noun)transactionNoun, (String)"Counter:OptimisticLocks", (String)DMSLocalization.buildMessage((String)"optimistic_lock"));
        this.getHeavyWeightSensors().put("Counter:OptimisticLocks", (Sensor)optimisticLock);
        Noun rcmNoun = Noun.create((Noun)this.root, (String)("RCM" + this.getSessionName()), (String)RcmNounType);
        this.getHeavyWeightNouns().put(RcmNounType, rcmNoun);
        State rcmStatus = State.create((Noun)rcmNoun, (String)"Info:CacheCoordinationStatus", (String)"", (String)DMSLocalization.buildMessage((String)"rcm_status"), (Object)"not available");
        this.getHeavyWeightSensors().put("Info:CacheCoordinationStatus", (Sensor)rcmStatus);
        Event messagesReceived = Event.create((Noun)rcmNoun, (String)"Counter:MessagesReceived", (String)DMSLocalization.buildMessage((String)"rcm_message_received"));
        this.getHeavyWeightSensors().put("Counter:MessagesReceived", (Sensor)messagesReceived);
        Event messagesSent = Event.create((Noun)rcmNoun, (String)"Counter:MessagesSent", (String)DMSLocalization.buildMessage((String)"rcm_message_sent"));
        this.getHeavyWeightSensors().put("Counter:MessagesSent", (Sensor)messagesSent);
        Event remoteChangeSets = Event.create((Noun)rcmNoun, (String)"Counter:RemoteChangeSets", (String)DMSLocalization.buildMessage((String)"remote_change_set"));
        this.getHeavyWeightSensors().put("Counter:RemoteChangeSets", (Sensor)remoteChangeSets);
        Noun connectionsNoun = Noun.create((Noun)this.root, (String)("Connection" + this.getSessionName()), (String)ConnectionNounType);
        this.getHeavyWeightNouns().put(ConnectionNounType, connectionsNoun);
        if (this.getSession().isServerSession()) {
            for (String poolName : ((ServerSession)this.getSession()).getConnectionPools().keySet()) {
                State connectionInUse = State.create((Noun)connectionsNoun, (String)("ConnectionsInUse(" + poolName + ")"), (String)"", (String)DMSLocalization.buildMessage((String)"connection_in_used"), (Object)"not available");
                this.getHeavyWeightSensors().put(poolName, (Sensor)connectionInUse);
            }
        }
        PhaseEvent connectionPing = PhaseEvent.create((Noun)connectionsNoun, (String)"Timer:ConnectionPing", (String)DMSLocalization.buildMessage((String)"connection_ping"));
        connectionPing.deriveMetric(511);
        this.getAllWeightSensors().put("Timer:ConnectionPing", (Sensor)connectionPing);
        Event tl_connects = Event.create((Noun)connectionsNoun, (String)"Counter:ConnectCalls", (String)DMSLocalization.buildMessage((String)"connect_call"));
        this.getHeavyWeightSensors().put("Counter:ConnectCalls", (Sensor)tl_connects);
        Event tl_disconnects = Event.create((Noun)connectionsNoun, (String)"Counter:DisconnectCalls", (String)DMSLocalization.buildMessage((String)"disconnect_call"));
        this.getHeavyWeightSensors().put("Counter:DisconnectCalls", (Sensor)tl_disconnects);
        Noun cacheNoun = Noun.create((Noun)this.root, (String)("Cache" + this.getSessionName()), (String)CacheNounType);
        this.getHeavyWeightNouns().put(CacheNounType, cacheNoun);
        Event cacheHits = Event.create((Noun)cacheNoun, (String)"Counter:CacheHits", (String)DMSLocalization.buildMessage((String)"cache_hits"));
        this.getHeavyWeightSensors().put("Counter:CacheHits", (Sensor)cacheHits);
        Event cacheMisses = Event.create((Noun)cacheNoun, (String)"Counter:CacheMisses", (String)DMSLocalization.buildMessage((String)"cache_misses"));
        this.getHeavyWeightSensors().put("Counter:CacheMisses", (Sensor)cacheMisses);
        this.getNormalAndHeavyWeightSensors().putAll(this.getNormalWeightSensors());
        this.getNormalAndHeavyWeightSensors().putAll(this.getHeavyWeightSensors());
    }

    protected void initializeAllWeightSensors() {
        Noun baseTransactionNoun = this.getHeavyWeightNouns().get(TransactionNounType);
        PhaseEvent mergeTime = PhaseEvent.create((Noun)baseTransactionNoun, (String)MergeTime, (String)DMSLocalization.buildMessage((String)"merge_time"));
        mergeTime.deriveMetric(511);
        this.getAllWeightSensors().put("Timer:Merge", (Sensor)mergeTime);
        PhaseEvent jtsAferCompletion = PhaseEvent.create((Noun)baseTransactionNoun, (String)"Timer:TXAfterCompletion", (String)DMSLocalization.buildMessage((String)"jts_aftercompletion"));
        jtsAferCompletion.deriveMetric(511);
        this.getAllWeightSensors().put("Timer:TXAfterCompletion", (Sensor)jtsAferCompletion);
        PhaseEvent jtsBeforeCompletion = PhaseEvent.create((Noun)baseTransactionNoun, (String)"Timer:TXBeforeCompletion", (String)DMSLocalization.buildMessage((String)"jts_beforecompletion"));
        jtsBeforeCompletion.deriveMetric(511);
        this.getAllWeightSensors().put("Timer:TXBeforeCompletion", (Sensor)jtsBeforeCompletion);
        PhaseEvent uowRegister = PhaseEvent.create((Noun)baseTransactionNoun, (String)UnitOfWorkRegister, (String)DMSLocalization.buildMessage((String)"unitofwork_register"));
        uowRegister.deriveMetric(511);
        this.getAllWeightSensors().put("Timer:Register", (Sensor)uowRegister);
        PhaseEvent distributedMerge = PhaseEvent.create((Noun)baseTransactionNoun, (String)DistributedMergeDmsDisplayName, (String)DMSLocalization.buildMessage((String)"distributed_merge"));
        distributedMerge.deriveMetric(511);
        this.getAllWeightSensors().put("Timer:DistributedMerge", (Sensor)distributedMerge);
        PhaseEvent sequence = PhaseEvent.create((Noun)baseTransactionNoun, (String)Sequencing, (String)DMSLocalization.buildMessage((String)"assigning_sequence_numbers"));
        sequence.deriveMetric(511);
        this.getAllWeightSensors().put("Timer:Sequencing", (Sensor)sequence);
        Noun baseCacheNoun = this.getHeavyWeightNouns().get(CacheNounType);
        PhaseEvent cache = PhaseEvent.create((Noun)baseCacheNoun, (String)"Timer:Caching", (String)DMSLocalization.buildMessage((String)"caching"));
        cache.deriveMetric(511);
        this.getAllWeightSensors().put(CACHE, (Sensor)cache);
        Noun baseConnectionNoun = this.getHeavyWeightNouns().get(ConnectionNounType);
        PhaseEvent dbConnect = PhaseEvent.create((Noun)baseConnectionNoun, (String)"Timer:ConnectionManagement", (String)DMSLocalization.buildMessage((String)"connection"));
        dbConnect.deriveMetric(511);
        this.getAllWeightSensors().put(CONNECT, (Sensor)dbConnect);
        Noun baseRcmNoun = this.getHeavyWeightNouns().get(RcmNounType);
        Event changeSetsProcessed = Event.create((Noun)baseRcmNoun, (String)"Counter:ChangesProcessed", (String)DMSLocalization.buildMessage((String)"change_set_processed"));
        this.getAllWeightSensors().put("Counter:ChangesProcessed", (Sensor)changeSetsProcessed);
        Event changeSetsNotProcessed = Event.create((Noun)baseRcmNoun, (String)"Counter:ChangesNotProcessed", (String)DMSLocalization.buildMessage((String)"change_set_not_processed"));
        this.getAllWeightSensors().put("Counter:ChangesNotProcessed", (Sensor)changeSetsNotProcessed);
        Noun miscellaneousNoun = Noun.create((Noun)this.root, (String)("Miscellaneous" + this.getSessionName()), (String)MiscellaneousNounType);
        this.getAllWeightNouns().put(MiscellaneousNounType, miscellaneousNoun);
        PhaseEvent logging = PhaseEvent.create((Noun)miscellaneousNoun, (String)"Timer:Logging", (String)DMSLocalization.buildMessage((String)"logging"));
        logging.deriveMetric(511);
        this.getAllWeightSensors().put("Timer:Logging", (Sensor)logging);
        PhaseEvent descriptorEvent = PhaseEvent.create((Noun)miscellaneousNoun, (String)"Timer:DescriptorEvents", (String)DMSLocalization.buildMessage((String)"descriptor_event"));
        descriptorEvent.deriveMetric(511);
        this.getAllWeightSensors().put("Timer:DescriptorEvents", (Sensor)descriptorEvent);
        PhaseEvent sessionEvent = PhaseEvent.create((Noun)miscellaneousNoun, (String)"Timer:SessionEvents", (String)DMSLocalization.buildMessage((String)"session_event"));
        sessionEvent.deriveMetric(511);
        this.getAllWeightSensors().put("Timer:SessionEvents", (Sensor)sessionEvent);
        this.getNormalHeavyAndAllWeightSensors().putAll(this.getNormalAndHeavyWeightSensors());
        this.getNormalHeavyAndAllWeightSensors().putAll(this.getAllWeightSensors());
    }

    protected void initSpy() {
        try {
            Spy.init((String)"TopLink", null);
        }
        catch (PublisherError p) {
            this.getSession().log(6, "dms", "an_error_occured_initializing_dms_listener");
            this.getSession().logThrowable(6, "dms", (Throwable)p);
            this.setProfileWeight(0);
        }
        catch (ConfigurationError c) {
            this.getSession().log(6, "dms", "an_error_occured_initializing_dms_listener");
            this.getSession().logThrowable(6, "dms", (Throwable)c);
            this.setProfileWeight(0);
        }
    }

    protected void destroySensorsByWeight(int weight) {
        Iterator<Sensor> iterator = null;
        if (weight == 10) {
            iterator = this.getHeavyWeightSensors().values().iterator();
        } else if (weight == Integer.MAX_VALUE) {
            iterator = this.getAllWeightSensors().values().iterator();
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                iterator.next().destroy();
            }
        }
    }

    protected void destroyNounsByWeight(int weight) {
        Iterator<Noun> iterator;
        if (weight == 5) {
            iterator = this.getNormalWeightNouns().values().iterator();
            while (iterator.hasNext()) {
                iterator.next().destroy();
            }
            this.getNormalWeightNouns().clear();
            this.getNormalWeightSensors().clear();
        }
        if (weight == 10) {
            iterator = this.getHeavyWeightNouns().values().iterator();
            while (iterator.hasNext()) {
                iterator.next().destroy();
            }
            this.getHeavyWeightNouns().clear();
            this.destroySensorsByWeight(10);
            this.getNormalAndHeavyWeightSensors().clear();
            this.getHeavyWeightSensors().clear();
        }
        if (weight == Integer.MAX_VALUE) {
            iterator = this.getAllWeightNouns().values().iterator();
            while (iterator.hasNext()) {
                iterator.next().destroy();
            }
            this.getAllWeightNouns().clear();
            this.destroySensorsByWeight(Integer.MAX_VALUE);
            this.getNormalHeavyAndAllWeightSensors().clear();
            this.getAllWeightSensors().clear();
        }
    }

    protected Map<String, Long> getPhaseEventStartToken() {
        if (this.getOperationStartTokenThreadLocal().get() == null) {
            this.getOperationStartTokenThreadLocal().set(new HashMap());
        }
        return this.getOperationStartTokenThreadLocal().get();
    }

    protected Map<String, Sensor> getNormalWeightSensors() {
        return this.normalWeightSensors;
    }

    protected Map<String, Sensor> getHeavyWeightSensors() {
        return this.heavyWeightSensors;
    }

    protected Map<String, Sensor> getAllWeightSensors() {
        return this.allWeightSensors;
    }

    protected Map<String, Sensor> getNormalAndHeavyWeightSensors() {
        return this.normalAndHeavyWeightSensors;
    }

    protected Map<String, Sensor> getNormalHeavyAndAllWeightSensors() {
        return this.normalHeavyAndAllWeightSensors;
    }

    protected Map<String, Noun> getNormalWeightNouns() {
        return this.normalWeightNouns;
    }

    protected Map<String, Noun> getHeavyWeightNouns() {
        return this.heavyWeightNouns;
    }

    protected Map<String, Noun> getAllWeightNouns() {
        return this.allWeightNouns;
    }

    protected ThreadLocal<Map<String, Long>> getOperationStartTokenThreadLocal() {
        return this.operationStartTokenThreadLocal;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public String getSessionName() {
        if (this.getSession().getName() != "") {
            return "_" + this.getSession().getName();
        }
        return this.getSession().getName();
    }

    public void setSession(Session session) {
        this.session = (AbstractSession)session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object profileExecutionOfQuery(DatabaseQuery query, DataRecord row, AbstractSession session) {
        this.startOperationProfile(null, query, 10);
        Object result = null;
        try {
            result = session.internalExecuteQuery(query, (AbstractRecord)row);
        }
        finally {
            this.endOperationProfile(null, query, 10);
        }
        return result;
    }
}

