/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import com.sun.enterprise.glassfish.bootstrap.log.LogFacade;
import com.sun.enterprise.glassfish.bootstrap.osgi.DefaultBundleProvisionerCustomizer;
import com.sun.enterprise.glassfish.bootstrap.osgi.Jar;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

class MinimalBundleProvisionerCustomizer
extends DefaultBundleProvisionerCustomizer {
    private final Logger logger = LogFacade.BOOTSTRAP_LOGGER;

    MinimalBundleProvisionerCustomizer(Properties config) {
        super(config);
    }

    public Jar getLatestJar() {
        File latestFile = null;
        for (URI uri : this.getConfiguredAutoInstallLocations()) {
            File file = null;
            try {
                file = new File(uri);
            }
            catch (Exception e) {
                continue;
            }
            if (latestFile == null) {
                latestFile = file;
            }
            if (file.lastModified() > latestFile.lastModified()) {
                latestFile = file;
            }
            if (!file.isDirectory()) continue;
            for (File child : file.listFiles()) {
                if (child.lastModified() <= latestFile.lastModified()) continue;
                latestFile = child;
            }
        }
        return latestFile != null ? new Jar(latestFile) : null;
    }

    @Override
    public List<URI> getAutoInstallLocations() {
        List<URI> installLocations = this.getAutoStartLocations();
        List<URI> fragments = this.selectFragmentJars(super.getAutoInstallLocations());
        installLocations.addAll(fragments);
        this.logger.log(Level.INFO, "NCLS-BOOTSTRAP-00030", new Object[]{installLocations});
        return installLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URI> selectFragmentJars(List<URI> installLocations) {
        ArrayList<URI> fragments = new ArrayList<URI>();
        for (URI uri : installLocations) {
            InputStream is = null;
            JarInputStream jis = null;
            try {
                is = uri.toURL().openStream();
                jis = new JarInputStream(is);
                Manifest m = jis.getManifest();
                if (m == null || m.getMainAttributes().getValue("Fragment-Host") == null) continue;
                this.logger.logp(Level.FINE, "MinimalBundleProvisioner$MinimalCustomizer", "selectFragmentJars", "{0} is a fragment", new Object[]{uri});
                fragments.add(uri);
            }
            catch (IOException e) {
                LogFacade.log(this.logger, Level.INFO, "NCLS-BOOTSTRAP-00031", e, uri);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (jis == null) continue;
                    jis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return fragments;
    }
}

