/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.glassfish.admin.amx.util.ArrayUtil;
import org.glassfish.admin.amx.util.IteratorUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.stringifier.SmartStringifier;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <T> void addAll(Collection<T> c, T[] items) {
        for (T item : items) {
            c.add(item);
        }
    }

    public static <T> String toString(Collection<T> c, String delim) {
        String[] strings = CollectionUtil.toStringArray(c);
        return StringUtil.toString(delim, (Object[])strings);
    }

    public static <T> String[] toStringArray(Collection<T> c) {
        String[] strings = new String[c.size()];
        int i = 0;
        for (T o : c) {
            strings[i] = SmartStringifier.toString(o);
            ++i;
        }
        return strings;
    }

    public static <T> List<String> toStringList(Collection<T> c) {
        String[] strings = CollectionUtil.toStringArray(c);
        ArrayList<String> list = new ArrayList<String>();
        for (String s : strings) {
            list.add(s);
        }
        return list;
    }

    public static <T> T getSingleton(Collection<T> s) {
        if (s.size() != 1) {
            throw new IllegalArgumentException();
        }
        return s.iterator().next();
    }

    public static <T> void addArray(Collection<T> c, T[] array) {
        for (int i = 0; i < array.length; ++i) {
            c.add(array[i]);
        }
    }

    public static <T> T[] toArray(Collection<? extends T> c, Class<T> elementClass) {
        T[] items = ArrayUtil.newArray(elementClass, c.size());
        c.toArray(items);
        return items;
    }

    public static boolean isAllStrings(Collection<?> c) {
        return IteratorUtil.getUniformClass(c.iterator()) == String.class;
    }
}

