/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.record;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.ErrorManager;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class GlassFishLogRecord
extends LogRecord {
    private static final long serialVersionUID = -4820672332353631291L;
    private static final ZoneId TIME_ZONE = ZoneId.systemDefault();
    private final LogRecord record;
    private final String threadName = Thread.currentThread().getName();
    private String messageKey;

    public GlassFishLogRecord(Level level, String message, boolean autodetectSource) {
        this(new LogRecord(level, message), autodetectSource);
    }

    public GlassFishLogRecord(LogRecord record, boolean autodetectSource) {
        super(record.getLevel(), null);
        this.record = record;
        if (autodetectSource) {
            SourceDetector.detectClassAndMethod(record);
        }
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public Level getLevel() {
        return this.record.getLevel();
    }

    @Override
    public void setLevel(Level level) {
        this.record.setLevel(level);
    }

    @Override
    public long getSequenceNumber() {
        return this.record.getSequenceNumber();
    }

    @Override
    public void setSequenceNumber(long seq) {
        this.record.setSequenceNumber(seq);
    }

    @Override
    public String getLoggerName() {
        return this.record.getLoggerName();
    }

    @Override
    public void setLoggerName(String name) {
        this.record.setLoggerName(name);
    }

    @Override
    public String getSourceClassName() {
        return this.record.getSourceClassName();
    }

    @Override
    public void setSourceClassName(String className) {
        this.record.setSourceClassName(className == null || className.isEmpty() ? null : className);
    }

    @Override
    public String getSourceMethodName() {
        return this.record.getSourceMethodName();
    }

    @Override
    public void setSourceMethodName(String methodName) {
        this.record.setSourceMethodName(methodName == null || methodName.isEmpty() ? null : methodName);
    }

    @Override
    public String getMessage() {
        return this.record.getMessage();
    }

    @Override
    public void setMessage(String message) {
        this.record.setMessage(message == null || message.isEmpty() ? null : message);
    }

    @Override
    public Object[] getParameters() {
        return this.record.getParameters();
    }

    @Override
    public void setParameters(Object[] parameters) {
        this.record.setParameters(parameters);
    }

    @Override
    public int getThreadID() {
        return this.record.getThreadID();
    }

    @Override
    public void setThreadID(int threadID) {
        this.record.setThreadID(threadID);
    }

    @Override
    public long getMillis() {
        return this.record.getMillis();
    }

    @Override
    @Deprecated
    public void setMillis(long millis) {
        this.record.setMillis(millis);
    }

    @Override
    public void setInstant(Instant instant) {
        this.record.setInstant(instant);
    }

    @Override
    public Instant getInstant() {
        return this.record.getInstant();
    }

    @Override
    public Throwable getThrown() {
        return this.record.getThrown();
    }

    @Override
    public void setThrown(Throwable thrown) {
        this.record.setThrown(thrown);
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.record.getResourceBundle();
    }

    @Override
    public void setResourceBundle(ResourceBundle bundle) {
        this.record.setResourceBundle(bundle);
    }

    @Override
    public String getResourceBundleName() {
        return this.record.getResourceBundleName();
    }

    @Override
    public void setResourceBundleName(String name) {
        this.record.setResourceBundleName(name);
    }

    public OffsetDateTime getTime() {
        return OffsetDateTime.ofInstant(this.getInstant(), TIME_ZONE);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getThrownStackTrace() {
        if (this.getThrown() == null) {
            return null;
        }
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                this.getThrown().printStackTrace(pw);
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            new ErrorManager().error("Cannot print stacktrace!", e, 5);
            return null;
        }
    }

    public String toString() {
        return this.getMessage();
    }

    private static class SourceDetector {
        private static final Set<String> LOGGING_CLASSES = Set.of("org.glassfish.main.jul.GlassFishLogger", "org.glassfish.main.jul.GlassFishLoggerWrapper", "com.sun.logging.LogDomainsLogger", "java.util.logging.Logger", "java.util.logging.LoggingProxyImpl", "java.lang.Throwable");
        private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.SHOW_REFLECT_FRAMES);

        private SourceDetector() {
        }

        static void detectClassAndMethod(LogRecord wrappedRecord) {
            STACK_WALKER.walk(stackFrames -> stackFrames.dropWhile(SourceDetector::isSourceStackFrame).filter(SourceDetector::isSourceStackFrame).findFirst()).ifPresent(frame -> {
                wrappedRecord.setSourceClassName(frame.getClassName());
                wrappedRecord.setSourceMethodName(frame.getMethodName());
            });
        }

        private static boolean isSourceStackFrame(StackWalker.StackFrame stackFrame) {
            return !SourceDetector.isLoggingStackFrame(stackFrame) && !SourceDetector.isReflectionStackFrame(stackFrame);
        }

        private static boolean isLoggingStackFrame(StackWalker.StackFrame stackFrame) {
            String sourceClassName = stackFrame.getClassName();
            return LOGGING_CLASSES.contains(sourceClassName) || sourceClassName.startsWith("sun.util.logging.");
        }

        private static boolean isReflectionStackFrame(StackWalker.StackFrame stackFrame) {
            String sourceClassName = stackFrame.getClassName();
            return sourceClassName.startsWith("jdk.internal.reflect.") || sourceClassName.startsWith("java.lang.reflect.") || sourceClassName.startsWith("java.lang.invoke.") || sourceClassName.startsWith("sun.reflect.");
        }
    }
}

