/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.persistent;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.DataSourceProvider;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistenceException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DefaultDataSourceProvider
implements DataSourceProvider {
    private static final String RM_JDBC_POOL_NAME = "jdbc/ReliableMessagingPool";
    private static final Logger LOGGER = Logger.getLogger(DefaultDataSourceProvider.class);
    private final DataSource ds = DefaultDataSourceProvider.getDataSource("jdbc/ReliableMessagingPool");

    private static synchronized DataSource getDataSource(String jndiName) throws PersistenceException {
        try {
            InitialContext ic = new InitialContext();
            Object __ds = ic.lookup(jndiName);
            if (!(__ds instanceof DataSource)) {
                throw new PersistenceException(LocalizationMessages.WSRM_1154_UNEXPECTED_CLASS_OF_JNDI_BOUND_OBJECT(__ds.getClass().getName(), jndiName, DataSource.class.getName()));
            }
            DataSource ds = (DataSource)__ds;
            return ds;
        }
        catch (NamingException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(LocalizationMessages.WSRM_1155_RM_JDBC_CONNECTION_POOL_NOT_FOUND(), ex))));
        }
    }

    @Override
    public DataSource getDataSource() {
        return this.ds;
    }
}

