/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import com.sun.messaging.jmq.util.MetricCounters;
import java.io.Serializable;

public class MetricData
implements Serializable {
    private static final long serialVersionUID = -2945599923640322420L;
    public MetricCounters totals = new MetricCounters();
    public MetricCounters rates = new MetricCounters();
    public long totalMemory;
    public long freeMemory;
    public long timestamp;
    public int nConnections;

    public MetricData() {
        this.reset();
    }

    public synchronized void reset() {
        this.totals.reset();
        this.rates.reset();
        this.timestamp = 0L;
        this.totalMemory = 0L;
        this.freeMemory = 0L;
        this.nConnections = 0;
    }

    public synchronized void setTotals(MetricCounters counters) {
        this.totals.reset();
        this.totals.update(counters);
    }

    public synchronized void setRates(MetricCounters counters) {
        this.rates.reset();
        this.rates.update(counters);
    }

    public String toString() {
        String s = "Connections: " + this.nConnections + "    JVM Heap: " + this.totalMemory + " bytes (" + this.freeMemory + " free) Threads: " + this.totals.threadsActive + " (" + this.totals.threadsLowWater + "-" + this.totals.threadsHighWater + ")\n      In: " + this.totals.messagesIn + " msgs (" + this.totals.messageBytesIn + " bytes)  " + this.totals.packetsIn + " pkts (" + this.totals.packetBytesIn + " bytes)\n     Out: " + this.totals.messagesOut + " msgs (" + this.totals.messageBytesOut + " bytes)  " + this.totals.packetsOut + " pkts (" + this.totals.packetBytesOut + " bytes)\n Rate In: " + this.rates.messagesIn + " msgs/sec (" + this.rates.messageBytesIn + " bytes/sec)  " + this.rates.packetsIn + " pkts/sec (" + this.rates.packetBytesIn + " bytes/sec)\nRate Out: " + this.rates.messagesOut + " msgs/sec (" + this.rates.messageBytesOut + " bytes/sec)  " + this.rates.packetsOut + " pkts/sec (" + this.rates.packetBytesOut + " bytes/sec)";
        return s;
    }
}

