/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import com.sun.messaging.jmq.util.lists.EventBroadcastHelper;
import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.lists.Limitable;
import com.sun.messaging.jmq.util.lists.OutOfLimitsException;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.Sized;
import com.sun.messaging.jmq.util.lists.WeakValueHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SimpleNFLHashMap<K, V>
extends HashMap<K, V>
implements EventBroadcaster,
Limitable {
    private static final long serialVersionUID = 4929344460826666399L;
    EventBroadcastHelper ebh = new EventBroadcastHelper();
    private boolean enforceLimits = true;
    private int highWaterCnt = 0;
    private long highWaterBytes = 0L;
    private long largestMessageHighWater = 0L;
    private float averageCount = 0.0f;
    private double averageBytes = 0.0;
    private double messageAverage = 0.0;
    private long numberSamples = 0L;
    protected int maxCapacity = -1;
    protected long maxByteCapacity = -1L;
    protected long bytes = 0L;
    protected long maxBytePerObject = -1L;
    Object limitLock = new Object();
    private final NLMapEntry<K, V> oldEntry = new NLMapEntry();
    private final NLMapEntry<K, V> newEntry = new NLMapEntry();
    Map<Comparator, Set> comparatorSets = null;
    Map filterMaps = null;

    public void reset() {
        this.highWaterCnt = 0;
        this.highWaterBytes = 0L;
        this.largestMessageHighWater = 0L;
        this.averageCount = 0.0f;
        this.averageBytes = 0.0;
        this.messageAverage = 0.0;
        this.numberSamples = 0L;
    }

    public Set<V> removeAll(Collection<K> c) {
        return this.removeAll(c, null);
    }

    public Set<V> removeAll(Collection<K> c, Reason r) {
        Iterator<K> itr = c.iterator();
        HashSet<V> s = new HashSet<V>();
        while (itr.hasNext()) {
            K mine = itr.next();
            V removed = this.remove(mine, r);
            if (removed == null) continue;
            s.add(removed);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        HashSet m = null;
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            m = new HashSet(this.keySet());
        }
        this.removeAll(m, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<V> subSet(Comparator<V> comparator) {
        TreeSet<V> s = new TreeSet<V>(comparator);
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            s.addAll(this.values());
            if (this.comparatorSets == null) {
                this.comparatorSets = Collections.synchronizedMap(new WeakValueHashMap("Comparator"));
            }
            this.comparatorSets.put(comparator, s);
        }
        return s;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.putAll(m, null);
    }

    public void putAll(Map<? extends K, ? extends V> m, Reason reason) {
        for (Map.Entry<K, V> me : m.entrySet()) {
            this.put(me.getKey(), me.getValue(), reason);
        }
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, null);
    }

    @Override
    public V remove(Object key) {
        return this.remove(key, null);
    }

    public V put(K key, V value, Reason reason) {
        return this.put(key, value, reason, true);
    }

    public V put(K key, V value, Reason reason, boolean overwrite) {
        return this.put(key, value, reason, overwrite, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value, Reason reason, boolean overwrite, boolean checklimit) {
        Object s;
        Iterator<Set<Object>> itr;
        boolean myenforceLimits;
        boolean bl = myenforceLimits = this.enforceLimits && checklimit;
        if (this.hasListeners(EventType.SET_CHANGED_REQUEST)) {
            this.notifyChange(EventType.SET_CHANGED_REQUEST, null, value, reason);
        }
        if (key == null && value == null) {
            throw new NullPointerException("Unable to support null keys or values");
        }
        if (this.maxByteCapacity != -1L && !(value instanceof Sized)) {
            throw new ClassCastException("Unable to add object not of type Sized when byteCapacity has been set");
        }
        if (this.maxBytePerObject != -1L && !(value instanceof Sized)) {
            throw new ClassCastException("Unable to add object not of type Sized when maxByteSize has been set");
        }
        long objsize = 0L;
        if (value instanceof Sized) {
            objsize = ((Sized)value).byteSize();
        }
        long oldBytes = 0L;
        long newBytes = 0L;
        int oldSize = 0;
        int newSize = 0;
        boolean wasEmpty = false;
        boolean isEmpty = false;
        boolean wasFull = false;
        boolean isFull = false;
        Object ret = null;
        Map map = this;
        synchronized (map) {
            oldBytes = this.bytes;
            oldSize = this.size();
            newSize = oldSize + 1;
            wasEmpty = oldSize == 0;
            isEmpty = newSize == 0;
            newBytes = this.bytes + objsize;
            wasFull = this.isFull();
            boolean bl2 = isFull = this.maxCapacity > 0 && newSize >= this.maxCapacity || this.maxByteCapacity > 0L && newBytes >= this.maxByteCapacity;
            if (myenforceLimits && this.maxBytePerObject != -1L && objsize > this.maxBytePerObject) {
                throw new OutOfLimitsException(2, objsize, this.maxBytePerObject);
            }
            if (myenforceLimits && this.maxCapacity != -1 && this.maxCapacity - newSize < 0) {
                throw new OutOfLimitsException(0, newSize, this.maxCapacity);
            }
            if (myenforceLimits && this.maxByteCapacity != -1L && this.maxByteCapacity - newBytes < 0L) {
                throw new OutOfLimitsException(1, newBytes, this.maxByteCapacity);
            }
            this.bytes = newBytes;
            if (!overwrite && super.get(key) != null) {
                throw new IllegalStateException("Message exist in the store");
            }
            ret = super.put(key, value);
            if (ret instanceof Sized) {
                this.bytes -= ((Sized)ret).byteSize();
            }
        }
        map = this.limitLock;
        synchronized (map) {
            if (newSize > this.highWaterCnt) {
                this.highWaterCnt = newSize;
            }
            if (objsize > this.largestMessageHighWater) {
                this.largestMessageHighWater = objsize;
            }
            if (this.bytes > this.highWaterBytes) {
                this.highWaterBytes = this.bytes;
            }
            this.averageCount = ((float)this.numberSamples * this.averageCount + (float)newSize) / ((float)this.numberSamples + 1.0f);
            this.averageBytes = ((double)this.numberSamples * this.averageBytes + (double)newBytes) / ((double)this.numberSamples + 1.0);
            this.messageAverage = ((double)this.numberSamples * this.messageAverage + (double)objsize) / ((double)this.numberSamples + 1.0);
            ++this.numberSamples;
        }
        if (this.comparatorSets != null && !this.comparatorSets.isEmpty()) {
            map = this.comparatorSets;
            synchronized (map) {
                itr = this.comparatorSets.values().iterator();
                while (itr.hasNext()) {
                    s = itr.next();
                    if (s != null) {
                        Set<Object> set = s;
                        synchronized (set) {
                            s.add(value);
                            continue;
                        }
                    }
                    itr.remove();
                }
            }
        }
        if (this.filterMaps != null && !this.filterMaps.isEmpty()) {
            map = this.filterMaps;
            synchronized (map) {
                itr = this.filterMaps.values().iterator();
                while (itr.hasNext()) {
                    s = (FilterMap)((Object)itr.next());
                    if (s != null && (((FilterMap)s).getFilter() == null || ((FilterMap)s).getFilter().matches(value))) {
                        ((HashMap)s).put(key, value);
                        continue;
                    }
                    if (s != null) continue;
                    itr.remove();
                }
            }
        }
        if (this.hasListeners(EventType.SIZE_CHANGED) && oldSize != newSize) {
            this.notifyChange(EventType.SIZE_CHANGED, oldSize, newSize, reason);
        }
        if (this.hasListeners(EventType.BYTES_CHANGED) && oldBytes != newBytes) {
            this.notifyChange(EventType.BYTES_CHANGED, oldBytes, newBytes, reason);
        }
        if (this.hasListeners(EventType.SET_CHANGED)) {
            NLMapEntry<K, V> oldv = null;
            this.newEntry.update(key, value);
            if (ret != null) {
                this.oldEntry.update(key, ret);
                oldv = this.oldEntry;
            }
            this.notifyChange(EventType.SET_CHANGED, oldv, this.newEntry, reason);
        }
        if (this.hasListeners(EventType.EMPTY) && wasEmpty != isEmpty) {
            this.notifyChange(EventType.EMPTY, wasEmpty, isEmpty, reason);
        }
        if (this.hasListeners(EventType.FULL) && wasFull != isFull) {
            this.notifyChange(EventType.FULL, wasFull, isFull, reason);
        }
        return ret;
    }

    public void enforceLimits(boolean b) {
        this.enforceLimits = b;
    }

    public boolean getEnforceLimits() {
        return this.enforceLimits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            return super.get(key);
        }
    }

    public V remove(K key, Reason reason) {
        return this.removeWithValue(key, null, null, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V removeWithValue(K key, V expectedValue, V errValue, Reason reason) {
        Set<Object> s;
        Iterator<Set<Object>> itr;
        V value = null;
        long oldBytes = 0L;
        long newBytes = 0L;
        int oldSize = 0;
        int newSize = 0;
        boolean wasEmpty = false;
        boolean isEmpty = false;
        boolean wasFull = false;
        boolean isFull = false;
        long objsize = 0L;
        Map map = this;
        synchronized (map) {
            if (expectedValue != null && (value = (V)super.get(key)) != null && value != expectedValue) {
                return errValue;
            }
            value = super.remove(key);
            if (value == null) {
                return null;
            }
            if (value instanceof Sized) {
                objsize = ((Sized)value).byteSize();
            }
            oldBytes = this.bytes;
            oldSize = this.size() + 1;
            newSize = oldSize - 1;
            wasEmpty = oldSize == 0;
            isEmpty = newSize == 0;
            newBytes = this.bytes - objsize;
            wasFull = this.maxCapacity > 0 && oldSize >= this.maxCapacity || this.maxByteCapacity > 0L && oldBytes >= this.maxByteCapacity;
            isFull = this.maxCapacity > 0 && newSize >= this.maxCapacity || this.maxByteCapacity > 0L && newBytes >= this.maxByteCapacity;
            this.bytes = newBytes;
        }
        if (this.hasListeners(EventType.SET_CHANGED_REQUEST)) {
            this.notifyChange(EventType.SET_CHANGED_REQUEST, value, null, reason);
        }
        map = this.limitLock;
        synchronized (map) {
            this.averageCount = ((float)this.numberSamples * this.averageCount + (float)newSize) / ((float)this.numberSamples + 1.0f);
            this.averageBytes = ((double)this.numberSamples * this.averageBytes + (double)newBytes) / ((double)this.numberSamples + 1.0);
            this.messageAverage = ((double)this.numberSamples * this.messageAverage + (double)objsize) / ((double)this.numberSamples + 1.0);
            ++this.numberSamples;
        }
        if (this.comparatorSets != null && !this.comparatorSets.isEmpty()) {
            map = this.comparatorSets;
            synchronized (map) {
                itr = this.comparatorSets.values().iterator();
                while (itr.hasNext()) {
                    s = itr.next();
                    if (s != null) {
                        Set<Object> set = s;
                        synchronized (set) {
                            s.remove(value);
                            continue;
                        }
                    }
                    itr.remove();
                }
            }
        }
        if (this.filterMaps != null && !this.filterMaps.isEmpty()) {
            map = this.filterMaps;
            synchronized (map) {
                itr = this.filterMaps.values().iterator();
                while (itr.hasNext()) {
                    s = itr.next();
                    if (s != null) {
                        s.remove(key);
                        continue;
                    }
                    itr.remove();
                }
            }
        }
        if (this.hasListeners(EventType.SIZE_CHANGED) && oldSize != newSize) {
            this.notifyChange(EventType.SIZE_CHANGED, oldSize, newSize, reason);
        }
        if (this.hasListeners(EventType.BYTES_CHANGED) && oldBytes != newBytes) {
            this.notifyChange(EventType.BYTES_CHANGED, oldBytes, newBytes, reason);
        }
        if (this.hasListeners(EventType.SET_CHANGED)) {
            NLMapEntry<K, V> oldv = this.oldEntry;
            this.oldEntry.update(key, value);
            Object newv = null;
            this.notifyChange(EventType.SET_CHANGED, oldv, newv, reason);
        }
        if (this.hasListeners(EventType.EMPTY) && wasEmpty != isEmpty) {
            this.notifyChange(EventType.EMPTY, wasEmpty, isEmpty, reason);
        }
        if (this.hasListeners(EventType.FULL) && wasFull != isFull) {
            this.notifyChange(EventType.FULL, wasFull, isFull, reason);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getAll(Filter f) {
        HashMap m = new HashMap();
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            for (Map.Entry entry : this.entrySet()) {
                Object value = entry.getValue();
                if (f != null && !f.matches(value)) continue;
                m.put(entry.getKey(), value);
            }
            return m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<K> getAllKeys() {
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            return new ArrayList(this.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<K> getFirstKeys(int count) {
        ArrayList l = new ArrayList(count);
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            Set entrySet = this.entrySet();
            Iterator itr = entrySet.iterator();
            for (int cnt = 0; cnt < count && itr.hasNext(); ++cnt) {
                Map.Entry e = itr.next();
                l.add(e.getKey());
            }
        }
        return l;
    }

    @Override
    public Object addEventListener(EventListener listener, EventType type, Object userData) {
        return this.ebh.addEventListener(listener, type, userData);
    }

    @Override
    public Object addEventListener(EventListener listener, EventType type, Reason reason, Object userData) {
        return this.ebh.addEventListener(listener, type, reason, userData);
    }

    @Override
    public Object removeEventListener(Object id) {
        return this.ebh.removeEventListener(id);
    }

    protected boolean hasListeners(EventType e) {
        return this.ebh.hasListeners(e);
    }

    protected void notifyChange(EventType e, Object oldval, Object newval, Reason r) {
        this.ebh.notifyChange(e, r, this, oldval, newval);
    }

    @Override
    public void setMaxByteSize(long bytes) {
        if (bytes < -1L) {
            bytes = -1L;
        }
        this.maxBytePerObject = bytes;
    }

    @Override
    public long maxByteSize() {
        return this.maxBytePerObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCapacity(int cnt) {
        if (cnt < -1) {
            cnt = -1;
        }
        if (!this.hasListeners(EventType.FULL)) {
            this.maxCapacity = cnt;
            return;
        }
        boolean wasFull = false;
        boolean isFull = false;
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            wasFull = this.isFull();
            this.maxCapacity = cnt;
            isFull = this.isFull();
        }
        if (wasFull != isFull) {
            this.notifyChange(EventType.FULL, wasFull, isFull, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByteCapacity(long size) {
        if (size < -1L) {
            size = -1L;
        }
        if (!this.hasListeners(EventType.FULL)) {
            this.maxByteCapacity = size;
            return;
        }
        boolean wasFull = false;
        boolean isFull = false;
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            wasFull = this.isFull();
            this.maxByteCapacity = size;
            isFull = this.isFull();
        }
        if (wasFull != isFull) {
            this.notifyChange(EventType.FULL, wasFull, isFull, null);
        }
    }

    @Override
    public int capacity() {
        return this.maxCapacity;
    }

    @Override
    public long byteCapacity() {
        return this.maxByteCapacity;
    }

    @Override
    public boolean isFull() {
        return this.maxCapacity > 0 && this.size() >= this.maxCapacity || this.maxByteCapacity > 0L && this.bytes >= this.maxByteCapacity;
    }

    @Override
    public int freeSpace() {
        if (this.maxCapacity == -1) {
            return -1;
        }
        int val = this.maxCapacity - this.size();
        if (val < 0) {
            return 0;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long freeBytes() {
        if (this.maxByteCapacity == -1L) {
            return -1L;
        }
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            long val = this.maxByteCapacity - this.bytes;
            if (val < 0L) {
                return 0L;
            }
            return val;
        }
    }

    @Override
    public long byteSize() {
        return this.bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        SimpleNFLHashMap simpleNFLHashMap = this;
        synchronized (simpleNFLHashMap) {
            return super.size();
        }
    }

    @Override
    public int highWaterCount() {
        return this.highWaterCnt;
    }

    @Override
    public long highWaterBytes() {
        return this.highWaterBytes;
    }

    @Override
    public long highWaterLargestMessageBytes() {
        return this.largestMessageHighWater;
    }

    @Override
    public float averageCount() {
        return this.averageCount;
    }

    @Override
    public double averageBytes() {
        return this.averageBytes;
    }

    @Override
    public double averageMessageBytes() {
        return this.messageAverage;
    }

    static class NLMapEntry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;

        NLMapEntry() {
        }

        public void update(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry me = (Map.Entry)o;
                return (me.getKey() == this.key || this.key != null && this.key.equals(me.getKey())) && (me.getValue() == this.value || this.value != null && this.value.equals(me.getValue()));
            }
            return false;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public V setValue(V o) {
            throw new UnsupportedOperationException("Can not set values on the entry");
        }
    }

    class FilterMap
    extends HashMap<K, V> {
        private static final long serialVersionUID = -5287488524104212543L;
        Filter f = null;

        FilterMap(Filter f) {
            this.f = f;
        }

        public Filter getFilter() {
            return this.f;
        }
    }
}

