/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.jms.ra.ConnectionCreator;
import com.sun.messaging.jms.ra.ConnectionFactoryAdapter;
import com.sun.messaging.jms.ra.ConnectionRequestInfo;
import com.sun.messaging.jms.ra.DirectConnectionFactory;
import com.sun.messaging.jms.ra.GenericConnectionFactoryProperties;
import com.sun.messaging.jms.ra.ManagedConnection;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.Util;
import com.sun.messaging.jms.ra.util.CustomTokenizer;
import jakarta.jms.JMSException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.InvalidPropertyException;
import jakarta.resource.spi.ResourceAdapterAssociation;
import jakarta.resource.spi.security.PasswordCredential;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class ManagedConnectionFactory
implements jakarta.resource.spi.ManagedConnectionFactory,
ResourceAdapterAssociation,
Serializable,
GenericConnectionFactoryProperties {
    private static final long serialVersionUID = 1L;
    private ResourceAdapter ra = null;
    private XAConnectionFactory xacf = null;
    private String addressList = null;
    private String userName = null;
    private String password = null;
    private String clientId = null;
    private boolean useSharedSubscriptionsInClusteredContainer = true;
    private boolean enableRADirect = false;
    private boolean enableAPIDirect = false;
    private boolean reconnectEnabled = false;
    private boolean reconnectEnabledSet = false;
    private int reconnectInterval = -1;
    private int reconnectAttempts = -1;
    private String addressListBehavior = null;
    private int addressListIterations = -1;
    private String options = null;
    private transient PrintWriter logWriter = null;
    private transient int mcfId = 0;
    private static int idCounter = 0;
    private ConnectionCreator connectionCreator = null;
    private static final String _className = "com.sun.messaging.jms.ra.ManagedConnectionFactory";
    protected static final String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    protected static final Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    protected static final String _lgrMIDPrefix = "MQJMSRA_MF";
    protected static final String _lgrMID_EET = "MQJMSRA_MF1001: ";
    protected static final String _lgrMID_INF = "MQJMSRA_MF1101: ";
    protected static final String _lgrMID_WRN = "MQJMSRA_MF2001: ";
    protected static final String _lgrMID_ERR = "MQJMSRA_MF3001: ";
    protected static final String _lgrMID_EXC = "MQJMSRA_MF4001: ";

    private static synchronized int incrementIdCounter() {
        return idCounter++;
    }

    public ManagedConnectionFactory() {
        _loggerOC.entering(_className, "constructor()");
        this.ra = null;
        this.logWriter = null;
        this.xacf = new XAConnectionFactory();
        this.mcfId = ManagedConnectionFactory.incrementIdCounter();
        _loggerOC.exiting(_className, "constructor()", ":Id=" + this.mcfId + ":config=" + this.toString());
    }

    public Object createConnectionFactory(ConnectionManager cm) {
        _loggerOC.entering(_className, "createConnectionFactory()", cm);
        this.connectionCreator = this.ra._isRADirectAllowed() && this.getEnableRADirect() ? new DirectConnectionFactory(this, cm) : (this.ra._isRADirect() && this.getEnableRADirect() ? new DirectConnectionFactory(this, cm) : new ConnectionFactoryAdapter(this, cm));
        return this.connectionCreator;
    }

    public Object createConnectionFactory() {
        _loggerOC.entering(_className, "createConnectionFactory()");
        return this.createConnectionFactory(ResourceAdapter._getConnectionManager());
    }

    public jakarta.resource.spi.ManagedConnection createManagedConnection(Subject subject, jakarta.resource.spi.ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        Object[] params = new Object[]{subject, cxRequestInfo};
        _loggerOC.entering(_className, "createManagedConnection()", params);
        if (this.connectionCreator == null) {
            ManagedConnectionFactory managedConnectionFactory = this;
            this.createConnectionFactory(managedConnectionFactory.ra._getConnectionManager());
        }
        ManagedConnection mc = new ManagedConnection(this, subject, (ConnectionRequestInfo)cxRequestInfo, this.ra);
        return mc;
    }

    public jakarta.resource.spi.ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, jakarta.resource.spi.ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        Object[] params = new Object[]{connectionSet, subject, cxRequestInfo};
        _loggerOC.entering(_className, "matchManagedConnections()", params);
        PasswordCredential pc = Util.getPasswordCredential(this, subject, (ConnectionRequestInfo)cxRequestInfo);
        for (Object obj : connectionSet) {
            if (!(obj instanceof ManagedConnection)) continue;
            ManagedConnection mc = (ManagedConnection)obj;
            ManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (mc.isDestroyed() || !Util.isPasswordCredentialEqual(mc.getPasswordCredential(), pc) || !mcf.equals(this)) continue;
            return mc;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        _loggerOC.entering(_className, "setLogWriter()", out);
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        _loggerOC.entering(_className, "getLogWriter()", this.logWriter);
        return this.logWriter;
    }

    public int hashCode() {
        if (this.mcfId == 0) {
            this.mcfId = ManagedConnectionFactory.incrementIdCounter();
        }
        return this.mcfId;
    }

    public boolean equals(Object other) {
        _loggerOC.entering(_className, "equals()", other);
        if (other == null) {
            return false;
        }
        if (other instanceof ManagedConnectionFactory) {
            ManagedConnectionFactory otherMCF = (ManagedConnectionFactory)other;
            if (_loggerOC.isLoggable(Level.FINER)) {
                _loggerOC.finer("MQJMSRA_MF1101: equals:thisMCF=" + this.toString() + "\n\t\totherMCF=" + otherMCF.toString());
            }
            String oMSA = otherMCF.getAddressList();
            String oUserName = otherMCF.getUserName();
            String oPassword = otherMCF.getPassword();
            String oClientId = otherMCF.getClientId();
            boolean oEnableRADirect = otherMCF.getEnableRADirect();
            boolean oEnableAPIDirect = otherMCF.getEnableAPIDirect();
            return (oMSA != null && oMSA.equals(this.addressList) || oMSA == null && this.addressList == null) && (oUserName != null && oUserName.equals(this.userName) || oUserName == null && this.userName == null) && (oPassword != null && oPassword.equals(this.password) || oPassword == null && this.password == null) && (oClientId != null && oClientId.equals(this.clientId) || oClientId == null && this.clientId == null) && oEnableRADirect == this.enableRADirect && oEnableAPIDirect == this.enableAPIDirect;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setResourceAdapter(jakarta.resource.spi.ResourceAdapter ra) throws ResourceException {
        _loggerOC.entering(_className, "setResourceAdapter()", ra);
        ManagedConnectionFactory managedConnectionFactory = this;
        synchronized (managedConnectionFactory) {
            ResourceAdapter mqra;
            if (this.ra != null) throw new ResourceException("MQRA:MCF:illegal to change resource adapter association");
            if (!(ra instanceof ResourceAdapter)) throw new ResourceException("MQRA:MCF:associating unkown resource adapter class - " + String.valueOf(ra.getClass()));
            this.ra = mqra = (ResourceAdapter)ra;
            if (!mqra.getInAppClientContainer()) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        System.setProperty("imq.DaemonThreads", "true");
                        return null;
                    }
                });
            }
            if (this.ra._isRADirectAllowed()) {
                this.setEnableRADirect(true);
            }
            if (this.ra._isAPIDirectAllowed()) {
                this.setEnableAPIDirect(true);
            }
            if (this.addressList == null) {
                try {
                    this._setAddressList(mqra._getEffectiveConnectionURL());
                }
                catch (IllegalArgumentException iae) {
                    _loggerOC.info("MQJMSRA_MF1101: setResourceAdapter:Using default addressList due to setAddressList Exception=" + iae.getMessage());
                }
            }
            if (this.userName == null) {
                try {
                    this._setUserName(mqra.getUserName());
                }
                catch (IllegalArgumentException iae) {
                    _loggerOC.info("MQJMSRA_MF1101: setResourceAdapter:Using default userName due to setUserName Exception=" + iae.getMessage());
                }
            }
            if (this.password == null) {
                try {
                    this._setPassword(mqra.getPassword());
                }
                catch (IllegalArgumentException iae) {
                    _loggerOC.info("MQJMSRA_MF1101: setResourceAdapter:Using default password due to setPassword Exception=" + iae.getMessage());
                }
            }
            if (!this.reconnectEnabledSet) {
                try {
                    this.setReconnectEnabled(mqra.getReconnectEnabled());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.reconnectInterval == -1) {
                try {
                    this.setReconnectInterval(mqra.getReconnectInterval());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.reconnectAttempts == -1) {
                try {
                    this.setReconnectAttempts(mqra.getReconnectAttempts());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.addressListIterations == -1) {
                try {
                    this.setAddressListIterations(mqra.getAddressListIterations());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.addressListBehavior != null) return;
            try {
                this.setAddressListBehavior(mqra.getAddressListBehavior());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            return;
        }
    }

    public jakarta.resource.spi.ResourceAdapter getResourceAdapter() {
        _loggerOC.entering(_className, "getResourceAdapter()", this.ra);
        return this.ra;
    }

    public int _getMCFId() {
        if (this.mcfId == 0) {
            this.mcfId = ManagedConnectionFactory.incrementIdCounter();
        }
        return this.mcfId;
    }

    public void _setMessageServiceAddressList(String messageServiceAddressList) {
        _loggerOC.entering(_className, "_setMessageServiceAddressList()", messageServiceAddressList);
        this.setAddressList(messageServiceAddressList);
    }

    public String _getMessageServiceAddressList() {
        _loggerOC.entering(_className, "_getMessageServiceAddressList()", this.addressList);
        return this.addressList;
    }

    @Override
    public void setAddressList(String addressList) {
        String tAddressList = addressList;
        _loggerOC.entering(_className, "setAddressList()", tAddressList);
        if ("localhost".equals(addressList) && this.ra == null) {
            _loggerOC.fine("MQJMSRA_MF1101: setAddressList:NOT setting default value=" + addressList);
            return;
        }
        this._setAddressList(addressList);
        if (addressList != null && !"".equals(addressList)) {
            this.setEnableRADirect(false);
            this.setEnableAPIDirect(false);
        }
    }

    private void _setAddressList(String addressList) {
        try {
            this.xacf.setProperty("imqAddressList", addressList);
            this.addressList = addressList;
        }
        catch (JMSException jmse) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_MF4001: setAddressList:setProperty Exception for value=" + addressList);
            iae.initCause(jmse);
            _loggerOC.warning(iae.getMessage());
            _loggerOC.throwing(_className, "setAddressList()", iae);
            throw iae;
        }
    }

    @Override
    public String getAddressList() {
        _loggerOC.entering(_className, "getMessageServiceAddressList()", this.addressList);
        return this.addressList;
    }

    @Override
    public void setUserName(String userName) {
        _loggerOC.entering(_className, "setUserName()", userName);
        if ("guest".equals(userName) && this.ra == null) {
            _loggerOC.fine("MQJMSRA_MF1101: setUserName:NOT setting default value=" + userName);
            return;
        }
        this._setUserName(userName);
    }

    private void _setUserName(String userName) {
        this.userName = userName;
        try {
            this.xacf.setProperty("imqDefaultUsername", userName);
        }
        catch (JMSException jmse) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_MF4001: setUserName:setProperty Exception for value=" + userName);
            iae.initCause(jmse);
            _loggerOC.warning(iae.getMessage());
            _loggerOC.throwing(_className, "setUserName()", iae);
            throw iae;
        }
    }

    @Override
    public String getUserName() {
        _loggerOC.entering(_className, "getUserName()", this.userName);
        if (this.userName != null) {
            return this.userName;
        }
        if (this.ra != null) {
            return this.ra.getUserName();
        }
        return null;
    }

    @Override
    public void setPassword(String password) {
        _loggerOC.entering(_className, "setPassword()");
        if ("guest".equals(password) && this.ra == null) {
            _loggerOC.fine("MQJMSRA_MF1101: setPassword:NOT setting default value");
            return;
        }
        this._setPassword(password);
    }

    private void _setPassword(String password) {
        this.password = password;
        try {
            this.xacf.setProperty("imqDefaultPassword", password);
        }
        catch (JMSException jmse) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_MF4001: setPassword:setProperty Exception");
            iae.initCause(jmse);
            _loggerOC.warning(iae.getMessage());
            _loggerOC.throwing(_className, "setPassword()", iae);
            throw iae;
        }
    }

    @Override
    public String getPassword() {
        _loggerOC.entering(_className, "getPassword()");
        if (this.password != null) {
            return this.password;
        }
        if (this.ra != null) {
            return this.ra.getPassword();
        }
        return null;
    }

    @Override
    public void setClientId(String clientId) {
        _loggerOC.entering(_className, "setClientId()", clientId);
        if (clientId == null || "".equals(clientId)) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_MF4001: setClientId:NULL or empty disallowed");
            _loggerOC.warning(iae.getMessage());
            _loggerOC.throwing(_className, "setClientId()", iae);
            throw iae;
        }
        this.clientId = clientId;
    }

    @Override
    public String getClientId() {
        _loggerOC.entering(_className, "getClientId()", this.clientId);
        return this.clientId;
    }

    public void setUseSharedSubscriptionInClusteredContainer(boolean b) {
        this.useSharedSubscriptionsInClusteredContainer = b;
    }

    public boolean isUseSharedSubscriptionInClusteredContainer() {
        return this.useSharedSubscriptionsInClusteredContainer;
    }

    public void setEnableRADirect(boolean flag) {
        _loggerOC.entering(_className, "setEnableRADirect()", Boolean.toString(flag));
        this.enableRADirect = this.ra != null && this.ra._isRADirectAllowed() && flag;
    }

    public void setEnableAPIDirect(boolean flag) {
        _loggerOC.entering(_className, "setEnableAPIDirect()", Boolean.toString(flag));
        if (this.ra != null && this.ra._isAPIDirectAllowed() && flag) {
            this.enableAPIDirect = true;
        } else {
            this.enableRADirect = false;
        }
    }

    public boolean getEnableRADirect() {
        _loggerOC.entering(_className, "getEnableRADirect()", Boolean.toString(this.enableRADirect));
        return this.enableRADirect;
    }

    public boolean getEnableAPIDirect() {
        _loggerOC.entering(_className, "getEnableAPIDirect()", Boolean.toString(this.enableAPIDirect));
        return this.enableAPIDirect;
    }

    @Override
    public void setReconnectEnabled(boolean flag) {
        _loggerOC.entering(_className, "setReconnectEnabled()", Boolean.toString(flag));
        try {
            this.xacf.setProperty("imqReconnectEnabled", Boolean.toString(flag));
            this.reconnectEnabled = flag;
            this.reconnectEnabledSet = true;
        }
        catch (JMSException jmse) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_MF4001: setReconnectEnabled:setProperty Exception for value " + flag);
            iae.initCause(jmse);
            _loggerOC.warning(iae.getMessage());
            _loggerOC.throwing(_className, "setReconnectEnabled()", iae);
            throw iae;
        }
    }

    @Override
    public boolean getReconnectEnabled() {
        _loggerOC.entering(_className, "getReconnectEnabled()", Boolean.toString(this.reconnectEnabled));
        return this.reconnectEnabled;
    }

    @Override
    public void setReconnectInterval(int reconnectInterval) {
        _loggerOC.entering(_className, "setReconnectInterval()", Integer.toString(reconnectInterval));
        this.reconnectInterval = reconnectInterval;
        try {
            this.xacf.setProperty("imqReconnectInterval", Integer.toString(reconnectInterval));
        }
        catch (JMSException jmse) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_MF4001: setReconnectInterval:setProperty Exception for value " + reconnectInterval);
            iae.initCause(jmse);
            _loggerOC.warning(iae.getMessage());
            _loggerOC.throwing(_className, "setReconnectInterval()", iae);
            throw iae;
        }
    }

    @Override
    public int getReconnectInterval() {
        _loggerOC.entering(_className, "getReconnectInterval()", Integer.toString(this.reconnectInterval));
        return this.reconnectInterval;
    }

    @Override
    public void setReconnectAttempts(int reconnectAttempts) {
        _loggerOC.entering(_className, "setReconnectAttempts()", Integer.toString(reconnectAttempts));
        this.reconnectAttempts = reconnectAttempts;
        try {
            this.xacf.setProperty("imqReconnectAttempts", Integer.toString(reconnectAttempts));
        }
        catch (JMSException jmse) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_MF4001: setReconnectAttempts:setProperty Exception for value " + reconnectAttempts);
            iae.initCause(jmse);
            _loggerOC.warning(iae.getMessage());
            _loggerOC.throwing(_className, "setReconnectAttempts()", iae);
            throw iae;
        }
    }

    @Override
    public int getReconnectAttempts() {
        _loggerOC.entering(_className, "getReconnectAttempts()", Integer.toString(this.reconnectAttempts));
        return this.reconnectAttempts;
    }

    @Override
    public void setAddressListBehavior(String addressListBehavior) {
        _loggerOC.entering(_className, "setAddressListBehavior()", addressListBehavior);
        this.addressListBehavior = "RANDOM".equalsIgnoreCase(addressListBehavior) ? "RANDOM" : "PRIORITY";
        try {
            this.xacf.setProperty("imqAddressListBehavior", this.addressListBehavior);
        }
        catch (JMSException jmse) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_MF4001: setAddressListBehavior:setProperty Exception for value " + addressListBehavior);
            iae.initCause(jmse);
            _loggerOC.warning(iae.getMessage());
            _loggerOC.throwing(_className, "setAddressListBehavior()", iae);
            throw iae;
        }
    }

    @Override
    public String getAddressListBehavior() {
        _loggerOC.entering(_className, "getAddressListBehavior()", this.addressListBehavior);
        return this.addressListBehavior;
    }

    @Override
    public void setAddressListIterations(int addressListIterations) {
        _loggerOC.entering(_className, "setAddressListIterations()", Integer.toString(addressListIterations));
        if (addressListIterations < 1) {
            _loggerOC.warning("MQJMSRA_MF2001: setAddressListIterations:Invalid value:" + addressListIterations + ":Setting to 1");
            this.addressListIterations = 1;
        } else {
            this.addressListIterations = addressListIterations;
        }
        try {
            this.xacf.setProperty("imqAddressListIterations", Integer.toString(this.addressListIterations));
        }
        catch (JMSException jmse) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_MF4001: setAddressListIterations:setProperty Exception for value " + addressListIterations);
            iae.initCause(jmse);
            _loggerOC.warning(iae.getMessage());
            _loggerOC.throwing(_className, "setAddressListIterations()", iae);
            throw iae;
        }
    }

    @Override
    public int getAddressListIterations() {
        _loggerOC.entering(_className, "getAddressListIterations()", Integer.toString(this.addressListIterations));
        return this.addressListIterations;
    }

    public void setProperty(String name, String value) {
        _loggerOC.entering(_className, "setProperty()", "Prop name=" + name + ":Prop value=" + value);
        try {
            if ("MessageServiceAddressList".equalsIgnoreCase(name)) {
                this.xacf.setProperty("imqAddressList", value);
            } else {
                this.xacf.setProperty(name, value);
            }
        }
        catch (JMSException jmse) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_MF4001: setProperty: exception setting property " + name + " to " + value);
            iae.initCause(jmse);
            _loggerOC.warning(iae.getMessage());
            _loggerOC.throwing(_className, "setProperty()", iae);
            throw iae;
        }
    }

    @Override
    public void setOptions(String stringProps) {
        _loggerOC.entering(_className, "setOptions()", "stringProps=" + stringProps);
        Hashtable<String, String> props = null;
        try {
            props = CustomTokenizer.parseToProperties(stringProps);
        }
        catch (InvalidPropertyException ipe) {
            String message = "ManagedConnectionFactory property options has invalid value " + stringProps + " error is: " + ipe.getMessage();
            _loggerOC.warning(_lgrMID_WRN + message);
            IllegalArgumentException iae = new IllegalArgumentException(_lgrMID_EXC + message);
            iae.initCause(ipe);
            throw iae;
        }
        Enumeration<String> keysEnum = props.keys();
        while (keysEnum.hasMoreElements()) {
            String thisPropertyName = keysEnum.nextElement();
            if (thisPropertyName.equals("imqReconnectInterval") || thisPropertyName.equals("imqDefaultUsername") || thisPropertyName.equals("imqDefaultPassword") || thisPropertyName.equals("imqAddressList") || thisPropertyName.equals("imqReconnectEnabled") || thisPropertyName.equals("imqAddressListIterations") || thisPropertyName.equals("imqReconnectAttempts") || thisPropertyName.equals("imqAddressListBehavior")) {
                _loggerOC.warning("MQJMSRA_MF2001: Cannot use ManagedConnectionFactory property options to set property " + thisPropertyName + ": ignoring");
                continue;
            }
            this.setProperty(thisPropertyName, props.get(thisPropertyName));
        }
        this.options = stringProps;
    }

    @Override
    public String getOptions() {
        return this.options;
    }

    public String getProperty(String name) {
        String propval = null;
        try {
            propval = this.xacf.getProperty(name);
        }
        catch (JMSException jmse) {
            IllegalArgumentException iae = new IllegalArgumentException("MQRA:MCF-Error getting property named-" + name);
            iae.initCause(jmse);
            throw iae;
        }
        return propval;
    }

    protected XAConnectionFactory _getXACF() {
        return this.xacf;
    }

    protected ConnectionCreator getConnectionCreator() {
        return this.connectionCreator;
    }

    public String toString() {
        return "ManagedConnectionFactory configuration=\n\tMCFId                               =" + this.mcfId + "\n\tAddressList                         =" + this.addressList + "\n\tUserName                            =" + this.userName + "\n\tClientId                            =" + this.clientId + "\n\tReconnectEnabled                    =" + this.reconnectEnabled + "\n\tReconnectInterval                   =" + this.reconnectInterval + "\n\tReconnectAttempts                   =" + this.reconnectAttempts + "\n\tAddressListBehavior                 =" + this.addressListBehavior + "\n\tAddressListIterations               =" + this.addressListIterations + "\n\toptions                             =" + this.options + "\n";
    }

    public boolean getInAppClientContainer() {
        return this.ra.getInAppClientContainer();
    }
}

