/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import com.sun.messaging.jmq.util.BASE64Decoder;
import com.sun.messaging.jmq.util.BASE64Encoder;
import com.sun.messaging.jmq.util.PassfileObfuscator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PassfileObfuscatorImpl
implements PassfileObfuscator {
    private static final String FORMAT_VERSION = "01F4";
    private static final String MAGIC = "4D5101F4";
    private static String OBSUFFIX_START = "{";
    private static String OBSUFFIX_END = "}";
    private static String OBSUFFIX_MAGIC_END = "4D5101F4" + OBSUFFIX_END;
    private List<String> unobfuscatedKeys = Collections.synchronizedList(new ArrayList());

    @Override
    public void obfuscateFile(String source, String target, String prefix) throws IOException {
        try {
            FileReader fr = new FileReader(source);
            BufferedReader br = new BufferedReader(fr);
            FileWriter fw = new FileWriter(target);
            BufferedWriter bw = new BufferedWriter(fw);
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            BASE64Encoder encoder = new BASE64Encoder();
            String line = null;
            while ((line = br.readLine()) != null) {
                int ind;
                if (line.startsWith(prefix) && (ind = line.indexOf("=")) > 0 && line.length() > ind + 1) {
                    String key = line.substring(0, ind);
                    if (!(key = key.trim()).endsWith(OBSUFFIX_MAGIC_END)) {
                        String pw = line.substring(ind + 1);
                        String epw = encoder.encode(pw.getBytes("UTF8"));
                        SecureRandom random = new SecureRandom();
                        byte[] randombytes = new byte[4];
                        random.nextBytes(randombytes);
                        String finalmagic = new BigInteger(randombytes).toString(16) + MAGIC;
                        String hashstr = this.hashpw(pw, finalmagic, md);
                        bw.write(key + OBSUFFIX_START + finalmagic + OBSUFFIX_END + "=" + hashstr + ":" + epw);
                        bw.newLine();
                        continue;
                    }
                }
                bw.write(line);
                bw.newLine();
            }
            bw.close();
            fw.close();
            br.close();
            fr.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception ee) {
            throw new IOException(ee.toString(), ee);
        }
    }

    @Override
    public void deobfuscateFile(String source, String target, String prefix) throws IOException {
        this.deobfuscateFile(source, target, prefix, false);
    }

    private StringBuffer deobfuscateFile(String source, String target, String prefix, boolean returnContentOnly) throws IOException {
        try {
            this.unobfuscatedKeys.clear();
            FileReader fr = new FileReader(source);
            BufferedReader br = new BufferedReader(fr);
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            BASE64Decoder decoder = new BASE64Decoder();
            StringBuffer contents = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                int ind;
                if (line.startsWith(prefix) && (ind = line.indexOf("=")) > 0 && line.length() > ind + 1) {
                    String key = line.substring(0, ind);
                    if ((key = key.trim()).endsWith(OBSUFFIX_MAGIC_END)) {
                        String hashepw = line.substring(ind + 1);
                        int ind2 = hashepw.indexOf(":");
                        if (ind2 > 0 && hashepw.length() > ind2 + 1) {
                            String epw = hashepw.substring(ind2 + 1);
                            String hashstr = hashepw.substring(0, ind2);
                            byte[] hashbytes = decoder.decodeBuffer(epw);
                            String pw = new String(hashbytes, "UTF8");
                            int indstart = key.lastIndexOf(OBSUFFIX_START);
                            if (indstart < 0 || indstart >= key.lastIndexOf(OBSUFFIX_MAGIC_END)) {
                                throw new IOException("Corrupted line[" + indstart + ", " + key.lastIndexOf(OBSUFFIX_MAGIC_END) + "]: " + line);
                            }
                            int indend = key.lastIndexOf(OBSUFFIX_END);
                            if (indend < 0 || indend <= indstart + OBSUFFIX_MAGIC_END.length()) {
                                throw new IOException("Corrupted line[" + indend + ", " + indstart + "+" + OBSUFFIX_MAGIC_END.length() + "]: " + line);
                            }
                            String finalmagic = key.substring(indstart + 1, indend);
                            String myhashstr = this.hashpw(pw, finalmagic, md);
                            if (!hashstr.equals(myhashstr)) {
                                throw new IOException("Password corrupted in line: " + line);
                            }
                            contents.append(key.substring(0, indstart) + "=" + pw);
                            contents.append(System.getProperty("line.separator"));
                            continue;
                        }
                        throw new IOException("Corrupted line[" + ind2 + ", " + hashepw.length() + ", " + (ind2 + 1) + "]: " + line);
                    }
                    this.unobfuscatedKeys.add(key);
                }
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
            if (returnContentOnly) {
                br.close();
                fr.close();
                return contents;
            }
            FileWriter fw = new FileWriter(target);
            BufferedWriter bw = new BufferedWriter(fw);
            String str = contents.toString();
            bw.write(str);
            bw.close();
            fw.close();
            br.close();
            fr.close();
            return null;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception ee) {
            throw new IOException(ee.toString(), ee);
        }
    }

    @Override
    public InputStream retrieveObfuscatedFile(String source, String prefix) throws IOException {
        StringBuffer contents = this.deobfuscateFile(source, null, prefix, true);
        byte[] bytes = contents.toString().getBytes("UTF8");
        ByteArrayInputStream pipeis = new ByteArrayInputStream(bytes);
        return pipeis;
    }

    @Override
    public boolean isObfuscated(String source, String prefix) throws IOException {
        return this.unobfuscatedKeys.isEmpty();
    }

    private String hashpw(String pw, String finalmagic, MessageDigest md) throws Exception {
        byte[] salt = finalmagic.getBytes("UTF8");
        boolean even = false;
        if (salt[0] % 2 == 0) {
            even = true;
            byte b0 = salt[0];
            salt[0] = salt[salt.length - 1];
            salt[salt.length - 1] = b0;
        } else {
            byte b1 = salt[1];
            salt[1] = salt[salt.length - 1];
            salt[salt.length - 1] = b1;
        }
        md.reset();
        md.update(salt);
        byte[] hashbytes = md.digest(pw.getBytes("UTF8"));
        if (even) {
            md.reset();
            hashbytes = md.digest(hashbytes);
            md.reset();
            hashbytes = md.digest(hashbytes);
        } else {
            md.reset();
            hashbytes = md.digest(hashbytes);
        }
        return new BigInteger(hashbytes).toString(16);
    }
}

