/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth;

import com.sun.messaging.jmq.auth.api.FailedLoginException;
import com.sun.messaging.jmq.auth.api.server.AccessControlContext;
import com.sun.messaging.jmq.auth.api.server.AuthenticationProtocolHandler;
import com.sun.messaging.jmq.auth.api.server.model.UserRepository;
import com.sun.messaging.jmq.auth.jaas.MQUser;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.JMQAccessControlContext;
import com.sun.messaging.jmq.util.MD5;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import javax.security.auth.Refreshable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class JMQDigestAuthenticationHandler
implements AuthenticationProtocolHandler {
    private String nonce = null;
    private AccessControlContext acc = null;
    private Properties authProps;
    private Refreshable cacheData = null;

    @Override
    public String getType() {
        return "digest";
    }

    @Override
    public byte[] init(int sequence, Properties authProperties, Refreshable cacheData) throws LoginException {
        this.authProps = authProperties;
        String clientip = this.authProps.getProperty("imq.clientIP");
        long timestamp = System.currentTimeMillis();
        String seed = this.authProps.getProperty("imq.connectionID");
        this.nonce = MD5.getHashString((String)(clientip + ":" + timestamp + seed));
        try {
            return this.nonce.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LoginException(e.getMessage());
        }
    }

    @Override
    public byte[] handleResponse(byte[] authResponse, int sequence) throws LoginException {
        Subject subject = null;
        ByteArrayInputStream bis = new ByteArrayInputStream(authResponse);
        DataInputStream dis = new DataInputStream(bis);
        try {
            String username = dis.readUTF();
            String credential = dis.readUTF();
            dis.close();
            String rep = this.authProps.getProperty("imq.authentication." + this.getType() + ".user_repository");
            if (rep == null || rep.trim().equals("")) {
                throw new LoginException(Globals.getBrokerResources().getKString("B4041", this.getType()));
            }
            String cn = this.authProps.getProperty("imq.user_repository." + rep + ".class");
            if (cn == null) {
                throw new LoginException(Globals.getBrokerResources().getKString("B4042", rep, this.getType()));
            }
            UserRepository repository = (UserRepository)Class.forName(cn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            repository.open(this.getType(), this.authProps, this.cacheData);
            subject = repository.findMatch(username, credential, this.nonce, this.getMatchType());
            this.cacheData = repository.getCacheData();
            repository.close();
            if (subject == null) {
                FailedLoginException ex = new FailedLoginException(Globals.getBrokerResources().getKString("B4051", username));
                ex.setUser(username);
                throw ex;
            }
            this.acc = new JMQAccessControlContext(new MQUser(username), subject, this.authProps);
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "ClassNotFoundException: " + e.getMessage()));
        }
        catch (IOException e) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "IOException: " + e.getMessage()));
        }
        catch (InstantiationException e) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "InstantiationException: " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "IllegalAccessException: " + e.getMessage()));
        }
        catch (ClassCastException e) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "cLassCastException: " + e.getMessage()));
        }
        catch (NoSuchMethodException e) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "NoSuchMethodException: " + e.getMessage()));
        }
        catch (InvocationTargetException e) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "InvocationTargetException: " + e.getMessage()));
        }
    }

    @Override
    public void logout() {
    }

    @Override
    public AccessControlContext getAccessControlContext() {
        return this.acc;
    }

    @Override
    public Refreshable getCacheData() {
        return this.cacheData;
    }

    public String getMatchType() {
        return this.getType();
    }
}

