/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.common.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.UniqueID;
import com.sun.messaging.jmq.util.log.Logger;
import java.nio.ByteBuffer;
import java.util.Hashtable;

public class GenerateUIDHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        ByteBuffer body;
        Hashtable<String, Object> props;
        block9: {
            block8: {
                if (DEBUG) {
                    this.logger.log(1, "GenerateUIDHandler: handle() [ Received GenerateUID Packet]");
                }
                props = null;
                try {
                    props = msg.getProperties();
                }
                catch (Exception ex) {
                    this.logger.logStack(16, "GEN-UID Packet.getProperties()", ex);
                    props = new Hashtable<String, Object>();
                }
                Integer value = null;
                int quantity = 1;
                if (props != null && (value = (Integer)props.get("JMQQuantity")) != null) {
                    quantity = value;
                }
                int status = 200;
                int size = quantity * 8;
                body = ByteBuffer.allocate(size);
                short prefix = UID.getPrefix();
                for (int n = 0; n < quantity; ++n) {
                    body.putLong(UniqueID.generateID(prefix));
                }
                props = new Hashtable();
                props.put("JMQStatus", status);
                props.put("JMQQuantity", quantity);
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)con;
                if (IMQBasicConnection.getDumpPacket()) break block8;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)con;
                if (!IMQBasicConnection.getDumpOutPacket()) break block9;
            }
            props.put("JMQReqID", msg.getSysMessageID().toString());
        }
        Packet pkt = new Packet(con.useDirectBuffers());
        pkt.setPacketType(63);
        pkt.setConsumerID(msg.getConsumerID());
        pkt.setProperties(props);
        body.rewind();
        pkt.setMessageBody(body);
        con.sendControlMessage(pkt);
        return true;
    }
}

