/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.MQAuthenticator;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.service.MetricManager;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.net.IPAddress;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import javax.security.auth.login.LoginException;

public class IMQDirectConnection
extends IMQConnection {
    private Object timerLock = new Object();
    public boolean METRICS_ON = MetricManager.isEnabled();
    Object ctrlEL = null;
    private MQAuthenticator authenticator = null;
    String remoteHostString = null;
    String remoteConString = null;
    String localsvcstring = null;
    int destroyRecurse = 0;

    public IMQDirectConnection(Service svc) throws BrokerException {
        super(svc);
        InetAddress ia = null;
        try {
            ia = InetAddress.getLocalHost();
            if (ia != null) {
                this.setRemoteIP(ia.getAddress());
            }
        }
        catch (UnknownHostException e) {
            throw new BrokerException(Globals.getBrokerResources().getString("B3152"));
        }
        this.setConnectionState(0);
        try {
            this.authenticator = new MQAuthenticator(svc.getName(), svc.getServiceType());
        }
        catch (Exception e) {
            String errStr = "Authenticator initialization failed for IMQDirectService: " + String.valueOf(e);
            this.logger.log(16, errStr);
            throw new BrokerException(errStr);
        }
        this.accessController = this.authenticator.getAccessController();
        if (ia != null) {
            this.accessController.setClientIP(ia.getHostAddress());
        }
        Globals.getDestinationList();
        this.pstore = DestinationList.assignStorePartition(svc.getServiceType(), this.getConnectionUID(), null);
        this.setConnectionState(1);
    }

    public void authenticate(String username, String password) throws BrokerException, LoginException {
        if (this.authenticator != null) {
            this.setConnectionState(2);
            this.authenticator.authenticate(username, password, false);
            this.accessController = this.authenticator.getAccessController();
            this.setConnectionState(3);
            this.setConnectionState(4);
        }
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    public int getLocalPort() {
        return 0;
    }

    @Override
    public boolean useDirectBuffers() {
        return false;
    }

    @Override
    public String toString() {
        return "IMQDirectConn[" + IMQDirectConnection.getConnectionStateString(this.state) + "," + this.getRemoteConnectionString() + "," + this.localServiceString() + "]";
    }

    @Override
    public String remoteHostString() {
        if (this.remoteHostString == null) {
            try {
                InetAddress inetaddr = InetAddress.getByAddress(this.remoteIP);
                this.remoteHostString = inetaddr.getHostName();
            }
            catch (Exception e) {
                this.remoteHostString = IPAddress.rawIPToString(this.remoteIP, true, true);
            }
        }
        return this.remoteHostString;
    }

    @Override
    public String getRemoteConnectionString() {
        String userString;
        String remotePortString;
        boolean userset;
        block6: {
            if (this.remoteConString != null) {
                return this.remoteConString;
            }
            userset = false;
            remotePortString = "0";
            userString = "???";
            if (this.state >= 4) {
                try {
                    Principal principal = this.getAuthenticatedName();
                    if (principal != null) {
                        userString = principal.getName();
                        userset = true;
                    }
                }
                catch (BrokerException e) {
                    if (!DEBUG) break block6;
                    this.logger.log(4, "Exception getting authentication name " + String.valueOf(this.conId), e);
                }
            }
        }
        String retstr = userString + "@" + IPAddress.rawIPToString(this.remoteIP, true, true) + ":" + remotePortString;
        if (userset) {
            this.remoteConString = retstr;
        }
        return retstr;
    }

    @Override
    protected String localServiceString() {
        if (this.localsvcstring != null) {
            return this.localsvcstring;
        }
        String localPortString = "0";
        this.localsvcstring = this.service.getName() + ":" + localPortString;
        return this.localsvcstring;
    }

    @Override
    public synchronized void closeConnection(boolean force, int reason, String reasonStr) {
        if (this.state >= 6) {
            this.logger.log(4, "Requested close of already closed connection:" + String.valueOf(this));
            return;
        }
        this.state = 6;
        this.notifyConnectionClosed();
        this.stopConnection();
        this.cleanup(reason == 1);
        if (reason == 1) {
            this.cleanupConnection();
        } else {
            this.cleanup(false);
        }
    }

    @Override
    protected void cleanupControlPackets(boolean shutdown) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyConnection(boolean force, int reason, String reasonstr) {
        int oldstate = 0;
        boolean destroyOK = false;
        try {
            MetricManager mm;
            IMQDirectConnection iMQDirectConnection = this;
            synchronized (iMQDirectConnection) {
                block13: {
                    oldstate = this.state;
                    if (this.state < 7) break block13;
                    return;
                }
                if (this.state < 6) {
                    this.closeConnection(force, reason, reasonstr);
                }
                this.setConnectionState(7);
            }
            Globals.getConnectionManager().removeConnection(this.getConnectionUID(), force, reason, reasonstr);
            if (this.accessController.isAuthenticated()) {
                this.authenticator.logout();
            }
            if ((mm = Globals.getMetricManager()) != null) {
                mm.depositTotals(this.service.getName(), this.counters);
            }
            this.counters.reset();
            this.logConnectionInfo(true, reasonstr);
            this.setConnectionState(8);
            destroyOK = true;
            this.wakeup();
        }
        finally {
            if (!(destroyOK || reason == 1 || Globals.getMemManager() != null && Globals.getMemManager().getCurrentLevel() <= 0)) {
                this.state = oldstate;
                if (this.destroyRecurse < 2) {
                    ++this.destroyRecurse;
                    this.destroyConnection(force, reason, reasonstr);
                }
            }
            Globals.getClusterBroadcast().connectionClosed(this.getConnectionUID(), this.isAdminConnection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setConnectionState(int state) {
        Object object = this.timerLock;
        synchronized (object) {
            this.state = state;
            if (this.state >= 6) {
                this.wakeup();
                return false;
            }
            if (state != 0) {
                if (state == 1 || state == 2 || state == 3) {
                    if (state == 1) {
                        return true;
                    }
                    if (state == 3) {
                        return true;
                    }
                } else if ((state >= 4 || state == -1) && state == 4) {
                    this.logConnectionInfo(false);
                }
            }
        }
        return true;
    }

    @Override
    public void logConnectionInfo(boolean closing) {
        this.logConnectionInfo(closing, "Unknown");
    }

    public void logConnectionInfo(boolean closing, String reason) {
        Object[] args = new String[]{this.getRemoteConnectionString(), this.localServiceString(), Integer.toString(Globals.getConnectionManager().size()), reason, "0", Integer.toString(this.service.size())};
        if (!closing) {
            this.logger.log(8, "B1065", args);
        } else {
            this.logger.log(8, "B1066", args);
        }
    }

    @Override
    public void sendControlMessage(Packet msg) {
    }

    void dumpConnectionInfo() {
    }

    @Override
    protected void sayGoodbye(int reason, String reasonStr) {
    }

    @Override
    protected void sendConsumerInfo(int requestType, String destName, int destType, int infoType) {
    }

    @Override
    protected void checkState() {
        assert (Thread.holdsLock(this.stateLock));
    }

    protected void sayGoodbye(boolean force, int reason, String reasonStr) {
    }

    @Override
    protected void checkConnection() {
    }

    @Override
    protected void flushConnection(long timeout) {
    }

    @Override
    public void eventOccured(EventType type, Reason r, Object target, Object oldval, Object newval, Object userdata) {
    }
}

