/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.connectors.jms.config.JmsHost;
import com.sun.enterprise.connectors.jms.config.JmsService;
import com.sun.enterprise.connectors.jms.system.ActiveJmsResourceAdapter;
import com.sun.enterprise.connectors.jms.system.JMSConfigListener;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.List;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=20, mode=0)
public class JmsProviderLifecycle
implements PostConstruct {
    private static final String JMS_INITIALIZE_ON_DEMAND = "org.glassfish.jms.InitializeOnDemand";
    public static final String EMBEDDED = "EMBEDDED";
    public static final String LOCAL = "LOCAL";
    public static final String REMOTE = "REMOTE";
    public static final String JMS_SERVICE = "jms-service";
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    private Provider<JMSConfigListener> jmsConfigListenerProvider;
    @Inject
    private Provider<ConnectorRuntime> connectorRuntimeProvider;
    @Inject
    private ActiveJmsResourceAdapter activeJmsResourceAdapter;

    public void postConstruct() {
        JmsService jmsService = (JmsService)this.config.getExtensionByType(JmsService.class);
        if (this.eagerStartupRequired()) {
            try {
                this.initializeBroker();
            }
            catch (ConnectorRuntimeException e) {
                e.printStackTrace();
                e.printStackTrace();
            }
        }
        this.activeJmsResourceAdapter.initializeLazyListener(jmsService);
        this.configureConfigListener();
    }

    private void configureConfigListener() {
        this.jmsConfigListenerProvider.get();
    }

    public void initializeBroker() throws ConnectorRuntimeException {
        String module = "jmsra";
        String loc = ConnectorsUtil.getSystemModuleLocation((String)module);
        ConnectorRuntime connectorRuntime = (ConnectorRuntime)this.connectorRuntimeProvider.get();
        connectorRuntime.createActiveResourceAdapter(loc, module, null);
    }

    private boolean eagerStartupRequired() {
        JmsService jmsService = this.getJmsService();
        if (jmsService == null) {
            return false;
        }
        String integrationMode = jmsService.getType();
        List<JmsHost> jmsHostList = jmsService.getJmsHost();
        if (jmsHostList == null) {
            return false;
        }
        String defaultJmsHostName = jmsService.getDefaultJmsHost();
        JmsHost defaultJmsHost = null;
        for (JmsHost host : jmsHostList) {
            if (defaultJmsHostName == null || !defaultJmsHostName.equals(host.getName())) continue;
            defaultJmsHost = host;
            break;
        }
        if (defaultJmsHost == null && jmsHostList.size() > 0) {
            defaultJmsHost = jmsHostList.get(0);
        }
        boolean lazyInit = false;
        if (defaultJmsHost != null) {
            lazyInit = Boolean.parseBoolean(defaultJmsHost.getLazyInit());
        }
        if (REMOTE.equals(integrationMode)) {
            return false;
        }
        String jmsInitializeOnDemand = System.getProperty(JMS_INITIALIZE_ON_DEMAND);
        if ("true".equals(jmsInitializeOnDemand)) {
            return false;
        }
        if (EMBEDDED.equals(integrationMode) && !lazyInit) {
            return true;
        }
        return LOCAL.equals(integrationMode);
    }

    private JmsService getJmsService() {
        return (JmsService)this.config.getExtensionByType(JmsService.class);
    }
}

