/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgi.cli.remote.impl;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;

public abstract class OsgiShellService {
    public static final String ASADMIN_OSGI_SHELL = "asadmin-osgi-shell";
    private static final Logger LOG = Logger.getLogger(OsgiShellService.class.getName());
    private final ActionReport report;
    private final ByteArrayOutputStream stdoutBytes;
    private final ByteArrayOutputStream stderrBytes;
    protected final PrintStream stdout;
    protected final PrintStream stderr;

    protected OsgiShellService(ActionReport report) {
        this.report = report;
        this.stdoutBytes = new ByteArrayOutputStream(1024);
        this.stdout = new PrintStream(this.stdoutBytes);
        this.stderrBytes = new ByteArrayOutputStream(1024);
        this.stderr = new PrintStream(this.stderrBytes);
    }

    public ActionReport exec(String cmdName, String cmd) throws Exception {
        LOG.log(Level.FINE, "exec: {0}", cmd);
        this.execCommand(cmdName, cmd);
        this.stdout.flush();
        this.stderr.flush();
        return this.generateReport();
    }

    protected abstract void execCommand(String var1, String var2) throws Exception;

    private ActionReport generateReport() {
        String output = this.stdoutBytes.toString(StandardCharsets.UTF_8);
        this.report.setMessage(output);
        String errors = this.stderrBytes.toString(StandardCharsets.UTF_8);
        if (errors.isEmpty()) {
            this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        } else {
            this.report.setMessage(errors);
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        return this.report;
    }
}

