/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.asm.Label;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.tree.BinaryCompareExpression;
import org.glassfish.rmic.tools.tree.BooleanExpression;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.LessExpression;

public class GreaterExpression
extends BinaryCompareExpression {
    public GreaterExpression(long where, Expression left, Expression right) {
        super(22, where, left, right);
    }

    @Override
    Expression eval(int a, int b) {
        return new BooleanExpression(this.where, a > b);
    }

    @Override
    Expression eval(long a, long b) {
        return new BooleanExpression(this.where, a > b);
    }

    @Override
    Expression eval(float a, float b) {
        return new BooleanExpression(this.where, a > b);
    }

    @Override
    Expression eval(double a, double b) {
        return new BooleanExpression(this.where, a > b);
    }

    @Override
    Expression simplify() {
        if (this.left.isConstant() && !this.right.isConstant()) {
            return new LessExpression(this.where, this.right, this.left);
        }
        return this;
    }

    @Override
    void codeBranch(Environment env, Context ctx, Assembler asm, Label lbl, boolean whenTrue) {
        this.left.codeValue(env, ctx, asm);
        switch (this.left.type.getTypeCode()) {
            case 4: {
                if (this.right.equals(0)) break;
                this.right.codeValue(env, ctx, asm);
                asm.add(this.where, whenTrue ? 163 : 164, lbl, whenTrue);
                return;
            }
            case 5: {
                this.right.codeValue(env, ctx, asm);
                asm.add(this.where, 148);
                break;
            }
            case 6: {
                this.right.codeValue(env, ctx, asm);
                asm.add(this.where, 149);
                break;
            }
            case 7: {
                this.right.codeValue(env, ctx, asm);
                asm.add(this.where, 151);
                break;
            }
            default: {
                throw new CompilerError("Unexpected Type");
            }
        }
        asm.add(this.where, whenTrue ? 157 : 158, lbl, whenTrue);
    }
}

