/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.java.ClassDeclaration;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.CheckContext;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.Statement;
import org.glassfish.rmic.tools.tree.Vset;

public class ThrowStatement
extends Statement {
    Expression expr;

    public ThrowStatement(long where, Expression expr) {
        super(104, where);
        this.expr = expr;
    }

    @Override
    Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        this.checkLabel(env, ctx);
        try {
            vset = this.reach(env, vset);
            this.expr.checkValue(env, ctx, vset, exp);
            if (this.expr.type.isType(10)) {
                ClassDeclaration throwable;
                ClassDefinition def;
                ClassDeclaration c = env.getClassDeclaration(this.expr.type);
                if (exp.get(c) == null) {
                    exp.put(c, this);
                }
                if (!(def = c.getClassDefinition(env)).subClassOf(env, throwable = env.getClassDeclaration(idJavaLangThrowable))) {
                    env.error(this.where, "throw.not.throwable", def);
                }
                this.expr = this.convert(env, ctx, Type.tObject, this.expr);
            } else if (!this.expr.type.isType(13)) {
                env.error(this.expr.where, "throw.not.throwable", this.expr.type);
            }
        }
        catch (ClassNotFound e) {
            env.error(this.where, "class.not.found", e.name, opNames[this.op]);
        }
        CheckContext exitctx = ctx.getTryExitContext();
        if (exitctx != null) {
            exitctx.vsTryExit = exitctx.vsTryExit.join(vset);
        }
        return DEAD_END;
    }

    @Override
    public Statement inline(Environment env, Context ctx) {
        this.expr = this.expr.inlineValue(env, ctx);
        return this;
    }

    @Override
    public Statement copyInline(Context ctx, boolean valNeeded) {
        ThrowStatement s = (ThrowStatement)this.clone();
        s.expr = this.expr.copyInline(ctx);
        return s;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        return 1 + this.expr.costInline(thresh, env, ctx);
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        this.expr.codeValue(env, ctx, asm);
        asm.add(this.where, 191);
    }

    @Override
    public void print(PrintStream out, int indent) {
        super.print(out, indent);
        out.print("throw ");
        this.expr.print(out);
        out.print(":");
    }
}

