/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.EmbeddedInhabitantsParser;
import com.sun.enterprise.glassfish.bootstrap.GlassFishImpl;
import com.sun.enterprise.glassfish.bootstrap.JarUtil;
import com.sun.enterprise.glassfish.bootstrap.SingleHK2Factory;
import com.sun.enterprise.glassfish.bootstrap.Util;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.ContextDuplicatePostProcessor;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.hk2.api.ServiceLocator;

public class StaticGlassFishRuntime
extends GlassFishRuntime {
    private static final Logger LOG = Util.getLogger();
    private static final String AUTO_DELETE = "org.glassfish.embeddable.autoDelete";
    private final Map<String, GlassFish> glassFishInstances = new HashMap<String, GlassFish>();
    private final Main main;

    public StaticGlassFishRuntime(Main main) {
        this.main = main;
    }

    public synchronized GlassFish newGlassFish(GlassFishProperties glassFishProperties) throws GlassFishException {
        try {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)glassFishProperties.getProperties());
            final GlassFishProperties gfProps = new GlassFishProperties(properties);
            this.setEnv(gfProps);
            StartupContext startupContext = new StartupContext(gfProps.getProperties());
            ModulesRegistry modulesRegistry = SingleHK2Factory.getInstance().createModulesRegistry();
            ServiceLocator serviceLocator = this.main.createServiceLocator(modulesRegistry, startupContext, List.of(new EmbeddedInhabitantsParser(), new ContextDuplicatePostProcessor()), null);
            ModuleStartup gfKernel = this.main.findStartupService(modulesRegistry, serviceLocator, null, startupContext);
            GlassFishImpl glassFish = new GlassFishImpl(gfKernel, serviceLocator, gfProps.getProperties()){

                @Override
                public void dispose() throws GlassFishException {
                    try {
                        super.dispose();
                    }
                    finally {
                        File instanceRoot;
                        StaticGlassFishRuntime.this.glassFishInstances.remove(gfProps.getInstanceRoot());
                        if (Boolean.parseBoolean(gfProps.getProperties().getProperty(StaticGlassFishRuntime.AUTO_DELETE)) && gfProps.getInstanceRoot() != null && (instanceRoot = new File(gfProps.getInstanceRoot())).exists()) {
                            Util.deleteRecursive(instanceRoot);
                        }
                    }
                }
            };
            this.glassFishInstances.put(gfProps.getInstanceRoot(), glassFish);
            return glassFish;
        }
        catch (GlassFishException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GlassFishException((Throwable)e);
        }
    }

    public synchronized void shutdown() throws GlassFishException {
        for (GlassFish glassFish : this.glassFishInstances.values()) {
            try {
                glassFish.dispose();
            }
            catch (IllegalStateException ex) {
                LOG.log(Level.FINER, "GlassFish dispose failed: " + ex.getMessage());
            }
        }
        this.glassFishInstances.clear();
        try {
            StaticGlassFishRuntime.shutdownInternal();
        }
        catch (GlassFishException ex) {
            LOG.log(Level.WARNING, "NCLS-BOOTSTRAP-00039", ex.getMessage());
        }
    }

    private void setEnv(GlassFishProperties gfProps) throws Exception {
        String instanceRootValue = gfProps.getInstanceRoot();
        if (instanceRootValue == null) {
            instanceRootValue = this.createTempInstanceRoot(gfProps);
            gfProps.setInstanceRoot(instanceRootValue);
        }
        File instanceRoot = new File(instanceRootValue);
        System.setProperty("com.sun.aas.instanceRoot", instanceRoot.getAbsolutePath());
        System.setProperty("com.sun.aas.instanceRootURI", instanceRoot.toURI().toString());
        String installRootValue = System.getProperty("org.glassfish.embeddable.installRoot");
        if (installRootValue == null) {
            installRootValue = instanceRoot.getAbsolutePath();
            gfProps.setProperty("-type", "EMBEDDED");
            JarUtil.extractRars(installRootValue);
        }
        JarUtil.setEnv(installRootValue);
        File installRoot = new File(installRootValue);
        System.setProperty("com.sun.aas.installRoot", installRoot.getAbsolutePath());
        System.setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
        gfProps.setProperty("com.sun.aas.installRoot", installRoot.getAbsolutePath());
        gfProps.setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
    }

    private String createTempInstanceRoot(GlassFishProperties gfProps) throws Exception {
        String tmpDir = gfProps.getProperties().getProperty("glassfish.embedded.tmpdir");
        if (tmpDir == null) {
            tmpDir = System.getProperty("glassfish.embedded.tmpdir", System.getProperty("java.io.tmpdir"));
        } else {
            new File(tmpDir).mkdirs();
        }
        File instanceRoot = File.createTempFile("gfembed", "tmp", new File(tmpDir));
        if (!instanceRoot.delete() || !instanceRoot.mkdir()) {
            throw new Exception("cannot create directory: " + instanceRoot.getAbsolutePath());
        }
        try {
            String[] configFiles = new String[]{"config/keyfile", "config/server.policy", "config/cacerts.jks", "config/keystore.jks", "config/login.conf", "config/admin-keyfile", "org/glassfish/web/embed/default-web.xml", "org/glassfish/embed/domain.xml"};
            File instanceConfigDir = new File(instanceRoot, "config");
            instanceConfigDir.mkdirs();
            new File(instanceRoot, "docroot").mkdirs();
            ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
            for (String configFile : configFiles) {
                StaticGlassFishRuntime.copy(cl.getResource(configFile), new File(instanceConfigDir, configFile.substring(configFile.lastIndexOf(47) + 1)), false);
            }
            String configFileURI = gfProps.getConfigFileURI();
            if (configFileURI != null) {
                StaticGlassFishRuntime.copy(URI.create(configFileURI).toURL(), new File(instanceConfigDir, "domain.xml"), true);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to create instanceRoot", ex);
        }
        String autoDelete = gfProps.getProperties().getProperty(AUTO_DELETE, "true");
        gfProps.setProperty(AUTO_DELETE, autoDelete);
        return instanceRoot.getAbsolutePath();
    }

    public static void copy(URL url, File destFile, boolean overwrite) {
        if (url == null || destFile == null) {
            return;
        }
        try {
            if (!(destFile.exists() && !overwrite || destFile.toURI().equals(url.toURI()))) {
                InputStream stream = url.openStream();
                destFile.getParentFile().mkdirs();
                Util.copy(stream, new FileOutputStream(destFile), stream.available());
                LOG.log(Level.FINER, () -> "Copied " + String.valueOf(url) + " to " + destFile.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            LOG.log(Level.FINER, ex, () -> "Failed to copy " + String.valueOf(url) + " to " + destFile.getAbsolutePath());
        }
    }
}

