/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul;

import java.util.Properties;
import org.glassfish.main.jul.GlassFishLogManager;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public final class GlassFishLogManagerInitializer {
    private GlassFishLogManagerInitializer() {
    }

    public static synchronized boolean tryToSetAsDefault() {
        return GlassFishLogManagerInitializer.tryToSetAsDefault(null);
    }

    public static synchronized boolean tryToSetAsDefault(Properties configuration) {
        GlassFishLoggingTracer.stacktrace(GlassFishLogManagerInitializer.class, "tryToSetAsDefault(" + String.valueOf(configuration) + ")");
        if (System.getProperty("java.util.logging.manager") != null) {
            GlassFishLoggingTracer.trace(GlassFishLogManagerInitializer.class, "The Log Manager implementation is already configured.");
            return false;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader originalContectClassLoader = currentThread.getContextClassLoader();
        try {
            ClassLoader newClassLoader = GlassFishLogManagerInitializer.class.getClassLoader();
            currentThread.setContextClassLoader(newClassLoader);
            System.setProperty("java.util.logging.manager", "org.glassfish.main.jul.GlassFishLogManager");
            Class<?> logManagerClass = newClassLoader.loadClass("org.glassfish.main.jul.GlassFishLogManager");
            GlassFishLoggingTracer.trace(GlassFishLogManagerInitializer.class, () -> "Will initialize log manager " + String.valueOf(logManagerClass));
            boolean bl = GlassFishLogManager.initialize(configuration);
            return bl;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not initialize logging system.", e);
        }
        finally {
            currentThread.setContextClassLoader(originalContectClassLoader);
        }
    }
}

