/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELException;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.ServiceLoader;

class FactoryFinder {
    private static final boolean IS_SECURITY_ENABLED = System.getSecurityManager() != null;

    FactoryFinder() {
    }

    private static Object newInstance(final String className, ClassLoader classLoader, Properties properties) {
        try {
            final Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            if (properties != null) {
                Constructor<?> constr = null;
                try {
                    constr = spiClass.getConstructor(Properties.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (constr != null) {
                    return constr.newInstance(properties);
                }
            }
            if (IS_SECURITY_ENABLED) {
                return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            return spiClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception x) {
                            throw new ELException("Provider " + className + " could not be instantiated: " + x, x);
                        }
                    }
                });
            }
            return spiClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException x) {
            throw new ELException("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ELException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static Object find(Class<?> serviceClass, final String factoryId, String fallbackClassName, Properties properties) {
        ClassLoader classLoader;
        try {
            classLoader = IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            }) : Thread.currentThread().getContextClassLoader();
        }
        catch (Exception x) {
            throw new ELException(x.toString(), x);
        }
        try {
            ServiceLoader<?> serviceLoader = ServiceLoader.load(serviceClass, classLoader);
            for (Object service : serviceLoader) {
                if (service == null) continue;
                return service;
            }
        }
        catch (Exception serviceLoader) {
            // empty catch block
        }
        try {
            String factoryClassName = null;
            factoryClassName = IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return FactoryFinder.getFactoryClassName(factoryId);
                }
            }) : FactoryFinder.getFactoryClassName(factoryId);
            if (factoryClassName != null) {
                return FactoryFinder.newInstance(factoryClassName, classLoader, properties);
            }
        }
        catch (Exception factoryClassName) {
            // empty catch block
        }
        try {
            String systemProp = IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(factoryId);
                }
            }) : System.getProperty(factoryId);
            if (systemProp != null) {
                return FactoryFinder.newInstance(systemProp, classLoader, properties);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (fallbackClassName == null) {
            throw new ELException("Provider for " + factoryId + " cannot be found", null);
        }
        return FactoryFinder.newInstance(fallbackClassName, classLoader, properties);
    }

    private static String getFactoryClassName(String factoryId) {
        String factoryClass = null;
        String javah = System.getProperty("java.home");
        String configFileName = javah + File.separator + "lib" + File.separator + "el.properties";
        File configFile = new File(configFileName);
        if (configFile.exists()) {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(configFile));
            }
            catch (Exception exception) {
                // empty catch block
            }
            factoryClass = props.getProperty(factoryId);
        }
        return factoryClass;
    }
}

