/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.GlassfishBootstrapClassLoader;
import com.sun.enterprise.glassfish.bootstrap.MainHelper;
import com.sun.enterprise.glassfish.bootstrap.Util;
import com.sun.enterprise.module.bootstrap.ArgumentManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;

public class GlassFishMain {
    private static final String ENV_AS_TRACE_LOGGING = "AS_TRACE_LOGGING";
    private static final String ENV_AS_TRACE_BOOTSTRAP = "AS_TRACE_BOOTSTRAP";
    private static final Pattern COMMAND_PATTERN = Pattern.compile("([^\"']\\S*|\".*?\"|'.*?')\\s*");
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;

    public static void main(String[] args) throws Exception {
        File installRoot = MainHelper.findInstallRoot();
        ClassLoader jdkExtensionCL = ClassLoader.getSystemClassLoader().getParent();
        GlassfishBootstrapClassLoader gfBootCL = new GlassfishBootstrapClassLoader(installRoot, jdkExtensionCL);
        GlassFishMain.initializeLogManager(gfBootCL);
        MainHelper.checkJdkVersion();
        Properties argsAsProps = ArgumentManager.argsToMap(args);
        String platform = MainHelper.whichPlatform();
        STDOUT.println("Launching GlassFish on " + platform + " platform");
        File instanceRoot = MainHelper.findInstanceRoot(installRoot, argsAsProps);
        Properties startupCtx = MainHelper.buildStartupContext(platform, installRoot, instanceRoot, args);
        ClassLoader launcherCL = MainHelper.createLauncherCL(startupCtx, gfBootCL);
        Class<?> launcherClass = launcherCL.loadClass(Launcher.class.getName());
        Object launcher = launcherClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Method method = launcherClass.getMethod("launch", Properties.class);
        method.invoke(launcher, startupCtx);
    }

    private static void initializeLogManager(GlassfishBootstrapClassLoader gfMainCL) throws Exception {
        Class<?> loggingInitializer = gfMainCL.loadClass("org.glassfish.main.jul.GlassFishLogManagerInitializer");
        Properties loggingCfg = GlassFishMain.createDefaultLoggingProperties();
        loggingInitializer.getMethod("tryToSetAsDefault", Properties.class).invoke(loggingInitializer, loggingCfg);
    }

    private static Properties createDefaultLoggingProperties() {
        Properties cfg = new Properties();
        cfg.setProperty("handlers", "org.glassfish.main.jul.handler.SimpleLogHandler,org.glassfish.main.jul.handler.GlassFishLogHandler");
        cfg.setProperty("org.glassfish.main.jul.handler.SimpleLogHandler.formatter", "org.glassfish.main.jul.formatter.UniformLogFormatter");
        if ("true".equals(System.getenv(ENV_AS_TRACE_LOGGING))) {
            cfg.setProperty("org.glassfish.main.jul.tracing.enabled", "true");
        }
        cfg.setProperty("systemRootLogger.level", Level.INFO.getName());
        cfg.setProperty(".level", Level.INFO.getName());
        if ("true".equals(System.getenv(ENV_AS_TRACE_BOOTSTRAP))) {
            cfg.setProperty("org.glassfish.main.jul.record.resolveLevelWithIncompleteConfiguration", "false");
        } else {
            cfg.setProperty("org.glassfish.main.jul.record.resolveLevelWithIncompleteConfiguration", "true");
        }
        return cfg;
    }

    public static class Launcher {
        private volatile GlassFish gf;
        private volatile GlassFishRuntime gfr;

        public void launch(Properties ctx) throws Exception {
            this.addShutdownHook();
            this.gfr = GlassFishRuntime.bootstrap((BootstrapProperties)new BootstrapProperties(ctx), (ClassLoader)this.getClass().getClassLoader());
            this.gf = this.gfr.newGlassFish(new GlassFishProperties(ctx));
            if (Boolean.valueOf(Util.getPropertyOrSystemProperty(ctx, "GlassFish_Interactive", "false")).booleanValue()) {
                this.startConsole();
            } else {
                this.gf.start();
            }
        }

        private void startConsole() throws IOException {
            String command;
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while ((command = this.readCommand(reader)) != null) {
                try {
                    Deployer deployer;
                    STDOUT.println("command = " + command);
                    if ("start".equalsIgnoreCase(command)) {
                        if (this.gf.getStatus() != GlassFish.Status.STARTED || this.gf.getStatus() == GlassFish.Status.STOPPING || this.gf.getStatus() == GlassFish.Status.STARTING) {
                            this.gf.start();
                            continue;
                        }
                        STDOUT.println("Already started or stopping or starting");
                        continue;
                    }
                    if ("stop".equalsIgnoreCase(command)) {
                        if (this.gf.getStatus() != GlassFish.Status.STARTED) {
                            STDOUT.println("GlassFish is not started yet. Please execute start first.");
                            continue;
                        }
                        this.gf.stop();
                        continue;
                    }
                    if (command.startsWith("deploy")) {
                        if (this.gf.getStatus() != GlassFish.Status.STARTED) {
                            STDOUT.println("GlassFish is not started yet. Please execute start first.");
                            continue;
                        }
                        deployer = (Deployer)this.gf.getService(Deployer.class, null);
                        String[] tokens = command.split("\\s");
                        if (tokens.length < 2) {
                            STDOUT.println("Syntax: deploy <options> file");
                            continue;
                        }
                        URI uri = URI.create(tokens[tokens.length - 1]);
                        String[] params = Arrays.copyOfRange(tokens, 1, tokens.length - 1);
                        String name = deployer.deploy(uri, params);
                        STDOUT.println("Deployed = " + name);
                        continue;
                    }
                    if (command.startsWith("undeploy")) {
                        if (this.gf.getStatus() != GlassFish.Status.STARTED) {
                            STDOUT.println("GlassFish is not started yet. Please execute start first.");
                            continue;
                        }
                        deployer = (Deployer)this.gf.getService(Deployer.class, null);
                        String name = command.substring(command.indexOf(32)).trim();
                        deployer.undeploy(name, new String[0]);
                        STDOUT.println("Undeployed = " + name);
                        continue;
                    }
                    if ("quit".equalsIgnoreCase(command)) {
                        System.exit(0);
                        continue;
                    }
                    if (this.gf.getStatus() != GlassFish.Status.STARTED) {
                        STDOUT.println("GlassFish is not started yet. Please execute start first.");
                        continue;
                    }
                    CommandRunner cmdRunner = this.gf.getCommandRunner();
                    this.runCommand(cmdRunner, command);
                }
                catch (Exception e) {
                    e.printStackTrace(STDERR);
                }
            }
        }

        private String readCommand(BufferedReader reader) throws IOException {
            this.prompt();
            String command = null;
            while ((command = reader.readLine()) != null && command.isEmpty()) {
            }
            return command;
        }

        private void prompt() {
            STDOUT.print("Enter any of the following commands: start, stop, quit, deploy <path to file>, undeploy <name of app>\nglassfish$ ");
            STDOUT.flush();
        }

        private void addShutdownHook() {
            Runtime.getRuntime().addShutdownHook(new Thread("GlassFish Shutdown Hook"){

                @Override
                public void run() {
                    try {
                        if (gfr != null) {
                            gfr.shutdown();
                        }
                    }
                    catch (Exception ex) {
                        STDERR.println("Error stopping framework: " + String.valueOf(ex));
                        ex.printStackTrace(STDERR);
                    }
                }
            });
        }

        private void runCommand(CommandRunner cmdRunner, String command) throws GlassFishException {
            String[] tokens = command.split("\\s");
            CommandResult result = cmdRunner.run(tokens[0], Arrays.copyOfRange(tokens, 1, tokens.length));
            System.out.println(result.getExitStatus());
            System.out.println(result.getOutput());
            if (result.getFailureCause() != null) {
                result.getFailureCause().printStackTrace(STDERR);
            }
        }
    }
}

