/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.security;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.security.PrivilegedExceptionAction;

public class PrivilegedGetThreadInfo
implements PrivilegedExceptionAction<ThreadInfo[]> {
    private final long[] ids;
    private final int maxDepth;

    public PrivilegedGetThreadInfo(long[] ids, int maxDepth) {
        this.ids = ids;
        this.maxDepth = maxDepth;
    }

    public PrivilegedGetThreadInfo(int maxDepth) {
        this.ids = null;
        this.maxDepth = maxDepth;
    }

    @Override
    public ThreadInfo[] run() throws Exception {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (this.ids != null) {
            return threadMXBean.getThreadInfo(this.ids, this.maxDepth);
        }
        return threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), this.maxDepth);
    }
}

