/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.domain;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Map;
import org.glassfish.soteria.mechanisms.openid.domain.ClaimsConfiguration;
import org.glassfish.soteria.mechanisms.openid.domain.LogoutConfiguration;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdProviderData;

public class OpenIdConfiguration {
    private String clientId;
    private char[] clientSecret;
    private String redirectURI;
    private boolean redirectToOriginalResource;
    private String scopes;
    private String responseType;
    private String responseMode;
    private Map<String, String> extraParameters;
    private String prompt;
    private String display;
    private boolean useNonce;
    private boolean useSession;
    private int jwksConnectTimeout;
    private int jwksReadTimeout;
    private OpenIdProviderData providerMetadata;
    private ClaimsConfiguration claimsConfiguration;
    private LogoutConfiguration logoutConfiguration;
    private boolean tokenAutoRefresh;
    private int tokenMinValidity;
    static final String BASE_URL_EXPRESSION = "${baseURL}";

    public String getClientId() {
        return this.clientId;
    }

    public OpenIdConfiguration setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public char[] getClientSecret() {
        return this.clientSecret;
    }

    public OpenIdConfiguration setClientSecret(char[] clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public String buildRedirectURI(HttpServletRequest request) {
        if (this.redirectURI.contains(BASE_URL_EXPRESSION)) {
            String baseURL = request.getRequestURL().substring(0, request.getRequestURL().length() - request.getRequestURI().length()) + request.getContextPath();
            return this.redirectURI.replace(BASE_URL_EXPRESSION, baseURL);
        }
        return this.redirectURI;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public OpenIdConfiguration setRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
        return this;
    }

    public boolean isRedirectToOriginalResource() {
        return this.redirectToOriginalResource;
    }

    public OpenIdConfiguration setRedirectToOriginalResource(boolean redirectToOriginalResource) {
        this.redirectToOriginalResource = redirectToOriginalResource;
        return this;
    }

    public String getScopes() {
        return this.scopes;
    }

    public OpenIdConfiguration setScopes(String scopes) {
        this.scopes = scopes;
        return this;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public OpenIdConfiguration setResponseType(String responseType) {
        this.responseType = responseType;
        return this;
    }

    public String getResponseMode() {
        return this.responseMode;
    }

    public OpenIdConfiguration setResponseMode(String responseMode) {
        this.responseMode = responseMode;
        return this;
    }

    public Map<String, String> getExtraParameters() {
        return this.extraParameters;
    }

    public OpenIdConfiguration setExtraParameters(Map<String, String> extraParameters) {
        this.extraParameters = extraParameters;
        return this;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public OpenIdConfiguration setPrompt(String prompt) {
        this.prompt = prompt;
        return this;
    }

    public String getDisplay() {
        return this.display;
    }

    public OpenIdConfiguration setDisplay(String display) {
        this.display = display;
        return this;
    }

    public boolean isUseNonce() {
        return this.useNonce;
    }

    public OpenIdConfiguration setUseNonce(boolean useNonce) {
        this.useNonce = useNonce;
        return this;
    }

    public boolean isUseSession() {
        return this.useSession;
    }

    public int getJwksConnectTimeout() {
        return this.jwksConnectTimeout;
    }

    public OpenIdConfiguration setJwksConnectTimeout(int jwksConnectTimeout) {
        this.jwksConnectTimeout = jwksConnectTimeout;
        return this;
    }

    public int getJwksReadTimeout() {
        return this.jwksReadTimeout;
    }

    public OpenIdConfiguration setJwksReadTimeout(int jwksReadTimeout) {
        this.jwksReadTimeout = jwksReadTimeout;
        return this;
    }

    public OpenIdConfiguration setUseSession(boolean useSession) {
        this.useSession = useSession;
        return this;
    }

    public OpenIdProviderData getProviderMetadata() {
        return this.providerMetadata;
    }

    public OpenIdConfiguration setProviderMetadata(OpenIdProviderData providerMetadata) {
        this.providerMetadata = providerMetadata;
        return this;
    }

    public ClaimsConfiguration getClaimsConfiguration() {
        return this.claimsConfiguration;
    }

    public OpenIdConfiguration setClaimsConfiguration(ClaimsConfiguration claimsConfiguration) {
        this.claimsConfiguration = claimsConfiguration;
        return this;
    }

    public LogoutConfiguration getLogoutConfiguration() {
        return this.logoutConfiguration;
    }

    public OpenIdConfiguration setLogoutConfiguration(LogoutConfiguration logoutConfiguration) {
        this.logoutConfiguration = logoutConfiguration;
        return this;
    }

    public boolean isTokenAutoRefresh() {
        return this.tokenAutoRefresh;
    }

    public OpenIdConfiguration setTokenAutoRefresh(boolean tokenAutoRefresh) {
        this.tokenAutoRefresh = tokenAutoRefresh;
        return this;
    }

    public int getTokenMinValidity() {
        return this.tokenMinValidity;
    }

    public OpenIdConfiguration setTokenMinValidity(int tokenMinValidity) {
        this.tokenMinValidity = tokenMinValidity;
        return this;
    }

    public String toString() {
        return OpenIdConfiguration.class.getSimpleName() + "{clientID=" + this.clientId + ", clientSecret=" + Arrays.toString(this.clientSecret) + ", redirectURI=" + this.redirectURI + ", scopes=" + this.scopes + ", responseType=" + this.responseType + ", responseMode=" + this.responseMode + ", extraParameters=" + this.extraParameters + ", prompt=" + this.prompt + ", display=" + this.display + ", useNonce=" + this.useNonce + ", useSession=" + this.useSession + ", providerMetadata=" + this.providerMetadata + ", claimsConfiguration=" + this.claimsConfiguration + ", tokenAutoRefresh=" + this.tokenAutoRefresh + ", tokenMinValidity=" + this.tokenMinValidity + "}";
    }
}

