/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import org.eclipse.persistence.eis.mappings.EISOneToManyMapping;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;

public class ManyToManyAccessor
extends CollectionAccessor {
    public ManyToManyAccessor() {
        super("<many-to-many>");
    }

    public ManyToManyAccessor(MetadataAnnotation manyToMany, MetadataAnnotatedElement annotatedElement, ClassAccessor classAccessor) {
        super(manyToMany, (MetadataAccessibleObject)annotatedElement, classAccessor);
        this.setMappedBy(manyToMany.getAttributeString("mappedBy"));
    }

    @Override
    public boolean equals(Object objectToCompare) {
        return super.equals(objectToCompare) && objectToCompare instanceof ManyToManyAccessor;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected DatabaseTable getDefaultTableForEntityMapKey() {
        return this.getJoinTableMetadata().getDatabaseTable();
    }

    @Override
    protected String getLoggingContext() {
        return "metadata_default_many_to_many_reference_class";
    }

    @Override
    public boolean isManyToMany() {
        return true;
    }

    @Override
    public boolean isPrivateOwned() {
        if (super.isPrivateOwned()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_private_owned", this);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process() {
        super.process();
        CollectionMapping mapping = this.getDescriptor().getClassDescriptor().newManyToManyMapping();
        this.process(mapping);
        if (this.hasMappedBy()) {
            DatabaseMapping owningMapping = this.getOwningMapping();
            if (!owningMapping.isManyToManyMapping()) throw ValidationException.invalidMapping((Object)this.getJavaClass(), (Object)this.getReferenceClass());
            ManyToManyMapping ownerMapping = (ManyToManyMapping)owningMapping;
            this.processMappedByRelationTable(ownerMapping.getRelationTableMechanism(), ((ManyToManyMapping)mapping).getRelationTableMechanism());
            mapping.setIsReadOnly(true);
            return;
        } else if (mapping instanceof ManyToManyMapping) {
            this.processJoinTable((ForeignReferenceMapping)mapping, ((ManyToManyMapping)mapping).getRelationTableMechanism(), this.getJoinTableMetadata());
            return;
        } else {
            if (!(mapping instanceof EISOneToManyMapping)) return;
            this.processEISOneToManyMapping((EISOneToManyMapping)mapping);
        }
    }
}

