/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.composite;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.common.ActionReporter;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorContext;
import jakarta.validation.ValidatorFactory;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.RestExtension;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.composite.Primitive;
import org.glassfish.admin.rest.composite.RestModel;
import org.glassfish.admin.rest.composite.metadata.AttributeReference;
import org.glassfish.admin.rest.composite.metadata.DefaultBeanReference;
import org.glassfish.admin.rest.composite.metadata.HelpText;
import org.glassfish.admin.rest.utils.JsonUtil;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.SseCommandHelper;
import org.glassfish.admin.rest.utils.StringUtil;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.internal.api.Globals;
import org.glassfish.jersey.media.sse.EventOutput;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.MessageInterpolatorImpl;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class CompositeUtil {
    private static final Map<String, Class<?>> generatedClasses = new HashMap();
    private static final Map<String, List<String>> modelExtensions = new HashMap<String, List<String>>();
    private final boolean extensionsLoaded = false;
    private static volatile Validator beanValidator = null;
    private static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(CompositeUtil.class);

    private CompositeUtil() {
    }

    public static CompositeUtil instance() {
        return LazyHolder.INSTANCE;
    }

    public synchronized <T> T getModel(Class<T> modelIface) {
        String className = modelIface.getName() + "Impl";
        if (!generatedClasses.containsKey(className)) {
            Class<?> clazz;
            HashMap<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
            Set<Class<?>> interfaces = this.getModelExtensions(modelIface);
            interfaces.add(modelIface);
            for (Class<?> clazz2 : interfaces) {
                this.analyzeInterface(clazz2, properties);
            }
            ClassWriter classWriter = new ClassWriter(1);
            this.visitClass(classWriter, className, interfaces, properties);
            for (Map.Entry entry : properties.entrySet()) {
                String name = (String)entry.getKey();
                Map property = (Map)entry.getValue();
                Class type = (Class)property.get("type");
                this.createField(classWriter, name, type);
                this.createGettersAndSetters(classWriter, modelIface, className, name, property);
            }
            this.createConstructor(classWriter, className, properties);
            classWriter.visitEnd();
            try {
                clazz = this.defineClass(modelIface, className, classWriter.toByteArray());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            generatedClasses.put(className, clazz);
        }
        try {
            return (T)generatedClasses.get(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Object getResourceExtensions(Class<?> baseClass, Object data, String method) {
        ArrayList<RestExtension> extensions = new ArrayList<RestExtension>();
        for (RestExtension extension : Globals.getDefaultHabitat().getAllServices(RestExtension.class, new Annotation[0])) {
            RestLogging.restLogger.info(() -> "Processing detected extension: " + String.valueOf(extension));
            if (!baseClass.getName().equals(extension.getParent())) continue;
            extensions.add(extension);
        }
        if ("get".equalsIgnoreCase(method)) {
            this.handleGetExtensions(extensions, data);
        } else if ("post".equalsIgnoreCase(method)) {
            return this.handlePostExtensions(extensions, data);
        }
        return Void.TYPE;
    }

    public ParameterMap addToParameterMap(ParameterMap parameters, String basePath, Class<?> configBean, Object source, Subject subject) {
        Map<String, String> currentValues = Util.getCurrentValues(basePath, Globals.getDefaultHabitat(), subject);
        for (Method cbMethod : configBean.getMethods()) {
            String name = cbMethod.getName();
            if (!name.startsWith("set")) continue;
            String getterName = "get" + name.substring(3, 4).toUpperCase(Locale.getDefault()) + name.substring(4);
            try {
                String currentValue;
                Method getter = source.getClass().getMethod(getterName, new Class[0]);
                String key = ResourceUtil.convertToXMLName(name.substring(3));
                Object value = null;
                try {
                    value = getter.invoke(source, new Object[0]);
                }
                catch (Exception ex) {
                    RestLogging.restLogger.log(Level.SEVERE, null, ex);
                }
                if (value == null || (currentValue = currentValues.get(basePath + key)) != null && !"".equals(value) && currentValue.equals(value)) continue;
                parameters.add((Object)"DEFAULT", (Object)(basePath + "." + key + "=" + String.valueOf(value)));
            }
            catch (NoSuchMethodException ex) {
                RestLogging.restLogger.log(Level.FINE, null, ex);
            }
        }
        return parameters;
    }

    public <T> T unmarshallClass(Locale locale, Class<T> modelClass, JSONObject json) throws JSONException {
        T model = this.getModel(modelClass);
        for (Method setter : this.getSetters(modelClass)) {
            String name = setter.getName();
            String attribute = name.substring(3, 4).toLowerCase(Locale.getDefault()) + name.substring(4);
            Type param0 = setter.getGenericParameterTypes()[0];
            Class<?> class0 = setter.getParameterTypes()[0];
            if (!json.has(attribute)) continue;
            Object o = json.get(attribute);
            if (JSONArray.class.isAssignableFrom(o.getClass())) {
                Object values = this.processJsonArray(locale, param0, (JSONArray)o);
                this.invoke(locale, setter, attribute, model, values);
                continue;
            }
            if (JSONObject.class.isAssignableFrom(o.getClass())) {
                this.invoke(locale, setter, attribute, model, this.unmarshallClass(locale, class0, (JSONObject)o));
                continue;
            }
            if ("null".equals(o.toString())) {
                o = null;
            }
            if (this.isUnmodifiedConfidentialProperty(modelClass, name, o)) continue;
            this.invoke(locale, setter, attribute, model, o);
        }
        return model;
    }

    private boolean isUnmodifiedConfidentialProperty(Class modelClass, String setterMethodName, Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        String s = (String)value;
        if (!"@_Oracle_Confidential_Property_Set_V1.1_#".equals(s)) {
            return false;
        }
        String getterMethodName = "g" + setterMethodName.substring(1);
        return JsonUtil.isConfidentialProperty(modelClass, getterMethodName);
    }

    private Object processJsonArray(Locale locale, Type param0, JSONArray array) throws JSONException {
        Class<?> type;
        boolean isArray = false;
        if (ParameterizedType.class.isAssignableFrom(param0.getClass())) {
            type = ((ParameterizedType)param0).getActualTypeArguments()[0];
        } else {
            isArray = ((Class)param0).isArray();
            type = ((Class)param0).getComponentType();
        }
        ArrayList values = isArray ? Array.newInstance(type, array.length()) : new ArrayList();
        for (int i = 0; i < array.length(); ++i) {
            Object element = array.get(i);
            if (JSONObject.class.isAssignableFrom(element.getClass())) {
                if (isArray) {
                    Array.set(values, i, this.unmarshallClass(locale, type, (JSONObject)element));
                    continue;
                }
                ((List)values).add(this.unmarshallClass(locale, type, (JSONObject)element));
                continue;
            }
            if (isArray) {
                Array.set(values, i, element);
                continue;
            }
            ((List)values).add(element);
        }
        return values;
    }

    private void invoke(Locale locale, Method m, String attribute, Object o, Object ... args) {
        try {
            m.invoke(o, args);
        }
        catch (IllegalArgumentException iae) {
            String message = "An exception occured while trying to set the value for the property '" + attribute + "': " + iae.getLocalizedMessage();
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build());
        }
        catch (Exception e) {
            String message = "An exception occured while trying to set the value for the property '" + attribute + "': " + e.getLocalizedMessage();
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).build());
        }
    }

    public String getHelpText(Annotation[] annos) {
        String helpText = null;
        if (annos != null) {
            for (Annotation annotation : annos) {
                if (!HelpText.class.isAssignableFrom(annotation.getClass())) continue;
                HelpText ht = (HelpText)annotation;
                ResourceBundle bundle = ResourceBundle.getBundle(ht.bundle(), Locale.getDefault());
                helpText = bundle.getString(ht.key());
            }
        }
        return helpText;
    }

    public <T> Set<ConstraintViolation<T>> validateRestModel(Locale locale, T model) {
        CompositeUtil.initBeanValidator();
        Set constraintViolations = beanValidator.validate(model, new Class[0]);
        if (constraintViolations == null || constraintViolations.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return constraintViolations;
    }

    public <T> String getValidationFailureMessages(Locale locale, Set<ConstraintViolation<T>> constraintViolations, T model) {
        StringBuilder msg = new StringBuilder(adminStrings.getLocalString("rest.model.validationFailure", "Properties for model {0} violate the following constraints: ", new Object[]{model.getClass().getSimpleName()}));
        String sep = "";
        String violationMsg = adminStrings.getLocalString("rest.model.validationFailure.reason", "on property [ {1} ] violation reason [ {0} ]");
        for (ConstraintViolation<T> cv : constraintViolations) {
            msg.append(sep).append(MessageFormat.format(violationMsg, cv.getMessage(), cv.getPropertyPath()));
            sep = "\n";
        }
        return msg.toString();
    }

    public void applyChanges(Map<String, String> changes, String basePath, Subject subject) {
        RestActionReporter ar = Util.applyChanges(changes, basePath, subject);
        if (!ar.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ar.getCombinedMessage()).build());
        }
    }

    public ActionReporter executeDeleteCommand(Subject subject, String command) {
        return this.executeDeleteCommand(subject, command, new ParameterMap());
    }

    public ActionReporter executeDeleteCommand(Subject subject, String command, ParameterMap parameters) {
        return this.executeCommand(subject, command, parameters, Response.Status.BAD_REQUEST, true, true, false);
    }

    public ActionReporter executeDeleteCommandManaged(Subject subject, String command, ParameterMap parameters) {
        return this.executeCommand(subject, command, parameters, Response.Status.BAD_REQUEST, true, true, true);
    }

    public ActionReporter executeWriteCommand(Subject subject, String command) {
        return this.executeWriteCommand(subject, command, new ParameterMap());
    }

    public ActionReporter executeWriteCommand(Subject subject, String command, ParameterMap parameters) {
        return this.executeCommand(subject, command, parameters, Response.Status.BAD_REQUEST, true, true, false);
    }

    public ActionReporter executeWriteCommandManaged(Subject subject, String command, ParameterMap parameters) {
        return this.executeCommand(subject, command, parameters, Response.Status.BAD_REQUEST, true, true, true);
    }

    public ActionReporter executeReadCommand(Subject subject, String command) {
        return this.executeReadCommand(subject, command, new ParameterMap());
    }

    public ActionReporter executeReadCommand(Subject subject, String command, ParameterMap parameters) {
        return this.executeCommand(subject, command, parameters, Response.Status.NOT_FOUND, true, true, false);
    }

    public ActionReporter executeCommand(Subject subject, String command, ParameterMap parameters, Response.Status status, boolean includeFailureMessage, boolean throwOnWarning, boolean managed) {
        RestActionReporter ar = ResourceUtil.runCommand(command, parameters, subject, managed);
        ActionReport.ExitCode code = ar.getActionExitCode();
        if (code.equals((Object)ActionReport.ExitCode.FAILURE) || code.equals((Object)ActionReport.ExitCode.WARNING) && throwOnWarning) {
            Throwable t = ar.getFailureCause();
            if (t instanceof SecurityException) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
            if (includeFailureMessage) {
                throw new WebApplicationException(Response.status((Response.Status)status).entity((Object)ar.getCombinedMessage()).build());
            }
            throw new WebApplicationException(status);
        }
        return ar;
    }

    public EventOutput executeSseCommand(Subject subject, String command, ParameterMap parameters) {
        return this.executeSseCommand(subject, command, parameters, null);
    }

    public EventOutput executeSseCommand(Subject subject, String command, ParameterMap parameters, SseCommandHelper.ActionReportProcessor processor) {
        return ResourceUtil.runCommandWithSse(command, parameters, subject, processor);
    }

    public Locale getLocale(HttpHeaders requestHeaders) {
        return this.getLocale((MultivaluedMap<String, String>)requestHeaders.getRequestHeaders());
    }

    public Locale getLocale(MultivaluedMap<String, String> requestHeaders) {
        String hdr = (String)requestHeaders.getFirst((Object)"Accept-Language");
        return hdr != null ? new Locale(hdr) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Class<?>> getModelExtensions(Class<?> baseModel) {
        HashSet exts = new HashSet();
        Map<String, List<String>> map = modelExtensions;
        synchronized (map) {
            this.loadModelExtensionMetadata(baseModel);
        }
        List<String> list = modelExtensions.get(baseModel.getName());
        if (list != null) {
            for (String className : list) {
                try {
                    Class<?> c = Class.forName(className, true, baseModel.getClassLoader());
                    exts.add(c);
                }
                catch (ClassNotFoundException ex) {
                    RestLogging.restLogger.log(Level.SEVERE, null, ex);
                }
            }
        }
        return exts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadModelExtensionMetadata(Class<?> similarClass) {
        BufferedReader reader = null;
        try {
            Enumeration<URL> urls = similarClass.getClassLoader().getResources("META-INF/restmodelextensions");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
                while (reader.ready()) {
                    String line = reader.readLine();
                    if (line == null || line.isEmpty() || line.charAt(0) == '#') continue;
                    if (!line.contains(":")) {
                        RestLogging.restLogger.log(Level.INFO, "NCLS-REST-00002", new String[]{"META-INF/restmodelextensions", line});
                    }
                    String[] entry = line.split(":");
                    String base = entry[0];
                    String ext = entry[1];
                    List<String> list = modelExtensions.get(base);
                    if (list == null) {
                        list = new ArrayList<String>();
                        modelExtensions.put(base, list);
                    }
                    list.add(ext);
                }
            }
        }
        catch (IOException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    RestLogging.restLogger.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private List<Method> getSetters(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().startsWith("set")) continue;
            methods.add(method);
        }
        return methods;
    }

    private void analyzeInterface(Class<?> iface, Map<String, Map<String, Object>> properties) throws SecurityException {
        String defaultBean = null;
        if (iface.isAnnotationPresent(DefaultBeanReference.class)) {
            DefaultBeanReference beanRef = iface.getAnnotation(DefaultBeanReference.class);
            defaultBean = beanRef.bean();
        }
        for (Method method : iface.getMethods()) {
            Attribute attr;
            String name = method.getName();
            boolean isGetter = name.startsWith("get");
            if (!isGetter && !name.startsWith("set")) continue;
            Map<String, Object> property = properties.get(name = name.substring(3));
            if (property == null) {
                property = new HashMap<String, Object>();
                properties.put(name, property);
            }
            String bean = null;
            String attribute = null;
            AttributeReference ar = method.getAnnotation(AttributeReference.class);
            if (ar != null) {
                bean = ar.bean();
                attribute = ar.attribute();
            }
            if (!StringUtil.notEmpty(bean)) {
                bean = defaultBean;
            }
            if (!StringUtil.notEmpty(attribute)) {
                attribute = name;
            }
            if (StringUtil.notEmpty(bean) && StringUtil.notEmpty(attribute)) {
                property.put("annotations", this.gatherReferencedAttributes(bean, attribute));
            }
            if ((attr = method.getAnnotation(Attribute.class)) != null) {
                property.put("defaultValue", attr.defaultValue());
            }
            Class<?> type = isGetter ? method.getReturnType() : method.getParameterTypes()[0];
            property.put("type", type);
        }
    }

    private Map<String, Map<String, Object>> gatherReferencedAttributes(String bean, String attribute) {
        HashMap<String, Map<String, Object>> annos = new HashMap<String, Map<String, Object>>();
        try {
            Class<?> configBeanClass = Class.forName(bean);
            Method m = configBeanClass.getMethod("get" + attribute, new Class[0]);
            for (Annotation a : m.getAnnotations()) {
                HashMap<String, Object> anno = new HashMap<String, Object>();
                for (Method am : a.annotationType().getDeclaredMethods()) {
                    String methodName = am.getName();
                    Object value = am.invoke((Object)a, new Object[0]);
                    anno.put(methodName, value);
                }
                annos.put(a.annotationType().getName(), anno);
            }
        }
        catch (Exception ex) {
            RestLogging.restLogger.log(Level.SEVERE, ex.getLocalizedMessage());
        }
        return annos;
    }

    private void handleGetExtensions(List<RestExtension> extensions, Object data) {
        RestLogging.restLogger.finest(() -> "Handling detected GET extension: " + String.valueOf(extensions));
        for (RestExtension re : extensions) {
            re.get(data);
        }
    }

    private ParameterMap handlePostExtensions(List<RestExtension> extensions, Object data) {
        RestLogging.restLogger.finest(() -> "Handling detected POST extension: " + String.valueOf(extensions));
        ParameterMap parameters = new ParameterMap();
        for (RestExtension re : extensions) {
            parameters.mergeAll((MultiMap)re.post(data));
        }
        return parameters;
    }

    private String getInternalTypeString(Class<?> type) {
        return type.isPrimitive() ? Primitive.getPrimitive(type.getName()).getInternalType() : (type.isArray() ? this.getInternalName(type.getName()) : "L" + this.getInternalName(type.getName() + ";"));
    }

    private String getPropertyName(String name) {
        return name.substring(0, 1).toLowerCase(Locale.getDefault()) + name.substring(1);
    }

    private void visitClass(ClassWriter classWriter, String className, Set<Class<?>> ifaces, Map<String, Map<String, Object>> properties) {
        String[] ifaceNames = new String[ifaces.size() + 1];
        int i = 1;
        ifaceNames[0] = this.getInternalName(RestModel.class.getName());
        for (Class<?> iface : ifaces) {
            ifaceNames[i++] = iface.getName().replace(".", "/");
        }
        className = this.getInternalName(className);
        classWriter.visit(55, 33, className, null, "org/glassfish/admin/rest/composite/RestModelImpl", ifaceNames);
        classWriter.visitAnnotation("Ljakarta/xml/bind/annotation/XmlRootElement;", true).visitEnd();
        AnnotationVisitor annotation = classWriter.visitAnnotation("Ljakarta/xml/bind/annotation/XmlAccessorType;", true);
        annotation.visitEnum("value", "Ljakarta/xml/bind/annotation/XmlAccessType;", "FIELD");
        annotation.visitEnd();
    }

    private void createConstructor(ClassWriter cw, String className, Map<String, Map<String, Object>> properties) {
        MethodVisitor method = cw.visitMethod(1, "<init>", "()V", null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitMethodInsn(183, "org/glassfish/admin/rest/composite/RestModelImpl", "<init>", "()V", false);
        for (Map.Entry<String, Map<String, Object>> property : properties.entrySet()) {
            String fieldName = property.getKey();
            String defaultValue = (String)property.getValue().get("defaultValue");
            if (defaultValue == null || defaultValue.isEmpty()) continue;
            this.setDefaultValue(method, className, fieldName, (Class)property.getValue().get("type"), defaultValue);
        }
        method.visitInsn(177);
        method.visitMaxs(1, 1);
        method.visitEnd();
    }

    private void setDefaultValue(MethodVisitor method, String className, String fieldName, Class<?> fieldClass, String defaultValue) {
        String type = this.getInternalTypeString(fieldClass);
        Object value = defaultValue;
        fieldName = this.getPropertyName(fieldName);
        if (fieldClass.isPrimitive()) {
            switch (Primitive.getPrimitive(type)) {
                case SHORT: {
                    value = Short.valueOf(defaultValue);
                    break;
                }
                case LONG: {
                    value = Long.valueOf(defaultValue);
                    break;
                }
                case INT: {
                    value = Integer.valueOf(defaultValue);
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(defaultValue);
                    break;
                }
                case DOUBLE: {
                    value = Double.valueOf(defaultValue);
                    break;
                }
                case BYTE: {
                    value = Byte.valueOf(defaultValue);
                    break;
                }
                case BOOLEAN: {
                    value = Boolean.valueOf(defaultValue);
                }
            }
            method.visitVarInsn(25, 0);
            method.visitLdcInsn(value);
            method.visitFieldInsn(181, this.getInternalName(className), fieldName, type);
        } else if (!fieldClass.equals(String.class)) {
            method.visitVarInsn(25, 0);
            String internalName = this.getInternalName(fieldClass.getName());
            method.visitTypeInsn(187, internalName);
            method.visitInsn(89);
            method.visitLdcInsn((Object)defaultValue);
            method.visitMethodInsn(183, internalName, "<init>", "(Ljava/lang/String;)V", false);
            method.visitFieldInsn(181, this.getInternalName(className), fieldName, type);
        } else {
            method.visitVarInsn(25, 0);
            method.visitLdcInsn(value);
            method.visitFieldInsn(181, this.getInternalName(className), fieldName, type);
        }
    }

    private void createField(ClassWriter cw, String name, Class<?> type) {
        String internalType = this.getInternalTypeString(type);
        FieldVisitor field = cw.visitField(2, this.getPropertyName(name), internalType, null, null);
        field.visitAnnotation("Ljakarta/xml/bind/annotation/XmlAttribute;", true).visitEnd();
        field.visitEnd();
    }

    private void createGettersAndSetters(ClassWriter cw, Class c, String className, String name, Map<String, Object> props) {
        Class type = (Class)props.get("type");
        String internalType = this.getInternalTypeString(type);
        className = this.getInternalName(className);
        MethodVisitor getter = cw.visitMethod(1, "get" + name, "()" + internalType, null, null);
        getter.visitCode();
        getter.visitVarInsn(25, 0);
        getter.visitFieldInsn(180, className, this.getPropertyName(name), internalType);
        getter.visitInsn(type.isPrimitive() ? Primitive.getPrimitive(internalType).getReturnOpcode() : 176);
        getter.visitMaxs(0, 0);
        getter.visitEnd();
        Map annotations = (Map)props.get("annotations");
        if (annotations != null) {
            for (Map.Entry entry : annotations.entrySet()) {
                String annotationClass = (String)entry.getKey();
                Map annotationValues = (Map)entry.getValue();
                AnnotationVisitor av = getter.visitAnnotation("L" + this.getInternalName(annotationClass) + ";", true);
                for (Map.Entry values : annotationValues.entrySet()) {
                    String paramName = (String)values.getKey();
                    Object paramValue = values.getValue();
                    if (Class.class.isAssignableFrom(paramValue.getClass())) {
                        paramValue = org.objectweb.asm.Type.getType((String)("L" + this.getInternalName(paramValue.getClass().getName()) + ";"));
                    }
                    if (paramValue.getClass().isArray() && Array.getLength(paramValue) == 0) continue;
                    av.visit(paramName, paramValue);
                }
                av.visitEnd();
            }
        }
        MethodVisitor setter = cw.visitMethod(1, "set" + name, "(" + internalType + ")V", null, null);
        setter.visitCode();
        setter.visitVarInsn(25, 0);
        setter.visitVarInsn(type.isPrimitive() ? Primitive.getPrimitive(internalType).getSetOpCode() : 25, 1);
        setter.visitFieldInsn(181, className, this.getPropertyName(name), internalType);
        setter.visitVarInsn(25, 0);
        setter.visitLdcInsn((Object)name);
        setter.visitMethodInsn(182, className, "fieldSet", "(Ljava/lang/String;)V", false);
        setter.visitInsn(177);
        setter.visitMaxs(0, 0);
        setter.visitEnd();
    }

    private String getInternalName(String className) {
        return className.replace(".", "/");
    }

    private Class<?> defineClass(Class<?> similarClass, String className, byte[] classBytes) throws Exception {
        RestLogging.restLogger.log(Level.FINEST, "Loading bytecode for {0}", className);
        return MethodHandles.privateLookupIn(similarClass, MethodHandles.lookup()).defineClass(classBytes);
    }

    private static synchronized void initBeanValidator() {
        if (beanValidator != null) {
            return;
        }
        ClassLoader cl = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        try {
            Thread.currentThread().setContextClassLoader(Validation.class.getClassLoader());
            ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
            ValidatorContext validatorContext = validatorFactory.usingContext();
            validatorContext.messageInterpolator((MessageInterpolator)new MessageInterpolatorImpl());
            beanValidator = validatorContext.getValidator();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private static class LazyHolder {
        public static final CompositeUtil INSTANCE = new CompositeUtil();

        private LazyHolder() {
        }
    }
}

