/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Set;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.composite.CompositeUtil;
import org.glassfish.admin.rest.composite.RestModel;

@Provider
@Produces(value={"application/vnd.oracle.glassfish+json"})
@Consumes(value={"application/vnd.oracle.glassfish+json"})
public class RestModelReader<T extends RestModel>
implements MessageBodyReader<T> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        String submittedType = mediaType.toString();
        int index = submittedType.indexOf(";");
        if (index > -1) {
            submittedType = submittedType.substring(0, index);
        }
        return submittedType.equals("application/vnd.oracle.glassfish+json") && RestModel.class.isAssignableFrom(type);
    }

    public T readFrom(Class<T> type, Type type1, Annotation[] antns, MediaType mt, MultivaluedMap<String, String> mm, InputStream entityStream) throws WebApplicationException, IOException {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(entityStream));
            StringBuilder sb = new StringBuilder();
            String line = in.readLine();
            while (line != null) {
                sb.append(line);
                line = in.readLine();
            }
            Locale locale = CompositeUtil.instance().getLocale(mm);
            JSONObject o = new JSONObject(sb.toString());
            RestModel model = (RestModel)CompositeUtil.instance().unmarshallClass(locale, type, o);
            Set cv = CompositeUtil.instance().validateRestModel(locale, model);
            if (!cv.isEmpty()) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)CompositeUtil.instance().getValidationFailureMessages(locale, cv, model)).build();
                throw new WebApplicationException(response);
            }
            return (T)model;
        }
        catch (JSONException ex) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getLocalizedMessage()).build());
        }
    }
}

