/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util.jmx.stringifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.glassfish.admin.amx.util.ListUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.TypeCast;
import org.glassfish.admin.amx.util.stringifier.Stringifier;

public final class ObjectNameStringifier
implements Stringifier {
    public static final ObjectNameStringifier DEFAULT = new ObjectNameStringifier();
    private static List<String> PROPS = null;
    private List<String> mOrderedProps;
    private boolean mOmitDomain;

    private static synchronized List<String> getPROPS() {
        if (PROPS == null) {
            PROPS = Collections.unmodifiableList(ListUtil.newListFromArray(new String[]{"j2eeType", "type", "name", "J2EEDomain", "J2EEServer", "JVM", "Node", "J2EEApplication", "AppClientModule", "EJBModule", "EntityBean", "StatefulSessionBean", "StatelessSessionBean", "MessageDrivenBean", "WebModule", "Servlet", "ResourceAdapterModule", "JavaMailResource", "JCAResource", "JCAConnectionFactory", "JCAManagedConnectionFactory", "JDBCResource", "JDBCDataSource", "JDBCDriver", "JMSResource", "JNDIResource", "JTAResource", "RMI_IIOPResource", "URL_Resource"}));
        }
        return PROPS;
    }

    public ObjectNameStringifier() {
        this(ObjectNameStringifier.getPROPS());
    }

    public ObjectNameStringifier(List<String> props) {
        this.mOrderedProps = props;
        this.mOmitDomain = false;
    }

    public ObjectNameStringifier(String[] props) {
        this(ListUtil.newListFromArray(props));
    }

    private String makeProp(String name, String value) {
        return name + "=" + value;
    }

    @Override
    public String stringify(Object o) {
        if (o == null) {
            return "null";
        }
        ObjectName on = (ObjectName)o;
        StringBuffer buf = new StringBuffer();
        if (!this.mOmitDomain) {
            buf.append(on.getDomain() + ":");
        }
        Map props = TypeCast.asMap(on.getKeyPropertyList());
        ArrayList<String> ordered = new ArrayList<String>(this.mOrderedProps);
        ordered.retainAll(props.keySet());
        Iterator iter = ordered.iterator();
        while (iter.hasNext() && props.keySet().size() >= 2) {
            String key = (String)iter.next();
            String value = (String)props.get(key);
            if (value == null) continue;
            buf.append(this.makeProp(key, value) + ",");
            props.remove(key);
        }
        Set remainingSet = props.keySet();
        Object[] remaining = new String[remainingSet.size()];
        remainingSet.toArray(remaining);
        Arrays.sort(remaining);
        for (int i = 0; i < remaining.length; ++i) {
            Object key = remaining[i];
            String value = (String)props.get(key);
            buf.append(this.makeProp((String)key, value) + ",");
        }
        String result = StringUtil.stripSuffix(buf.toString(), ",");
        return result;
    }

    public List getProps() {
        return this.mOrderedProps;
    }

    public void setProps(List<String> props) {
        this.mOrderedProps = props;
    }

    public boolean getOmitDomain() {
        return this.mOmitDomain;
    }

    public void setOmitDomain(boolean omit) {
        this.mOmitDomain = omit;
    }
}

